/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.stubs.model.trees;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.QName;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Edge;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.GDoc;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.InnerNode;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Leaf;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Node;

public class Nodes {
    public static final Class<Leaf> L = Leaf.class;
    public static final Class<InnerNode> N = InnerNode.class;
    private static DatatypeFactory typeFactory;

    public static GDoc gdoc(GDoc doc) {
        return new GDoc(doc);
    }

    public static GDoc gdoc(String collID, String id, Edge ... edges) {
        return new GDoc(collID, id, edges);
    }

    public static GDoc gdoc(String id, Edge ... edges) {
        return new GDoc(id, edges);
    }

    public static GDoc gdoc(Edge ... edges) {
        return Nodes.gdoc(null, edges);
    }

    public static InnerNode gdoc(InnerNode n) {
        return new InnerNode(n);
    }

    public static InnerNode n(String id, Edge ... edges) {
        return new InnerNode(id, edges);
    }

    public static InnerNode n(Edge ... edges) {
        return Nodes.n(null, edges);
    }

    public static Edge e(Edge e) {
        return new Edge(e);
    }

    public static Edge e(String prefix, String ns, String name, Node node) throws IllegalArgumentException {
        return new Edge(new QName(ns, name, prefix), node);
    }

    public static Edge e(String ns, String name, Node node) throws IllegalArgumentException {
        return new Edge(new QName(ns, name), node);
    }

    public static Edge e(String name, Node node) throws IllegalArgumentException {
        return new Edge(new QName(name), node);
    }

    public static Edge e(String ns, String name, Object v) throws IllegalArgumentException {
        return new Edge(new QName(ns, name), (Node)Nodes.l(v));
    }

    public static Edge e(String prefix, String ns, String name, Object v) {
        return new Edge(new QName(ns, name, prefix), (Node)Nodes.l(v));
    }

    public static Edge e(String l, Object v) throws IllegalArgumentException {
        return new Edge(new QName(l), (Node)Nodes.l(v));
    }

    public static Leaf l(Leaf l) {
        return new Leaf(l);
    }

    public static Leaf l(String id, Object v) {
        String value = Nodes.toString(v);
        return new Leaf(id, value);
    }

    public static Leaf l(Object v) {
        return Nodes.l(null, v);
    }

    public static <N extends Node> N attr(N n, Attribute attribute, Attribute ... as) {
        n.setAttribute(attribute.name, attribute.value);
        for (Attribute att : as) {
            n.setAttribute(att.name, att.value);
        }
        return n;
    }

    public static Attribute a(String name, Object v) throws IllegalArgumentException {
        return Nodes.a(new QName(name), v);
    }

    public static Attribute a(String ns, String local, Object v) throws IllegalArgumentException {
        return Nodes.a(new QName(ns, local), v);
    }

    public static Attribute a(QName n, Object v) {
        Attribute a = new Attribute();
        a.name = n;
        a.value = Nodes.toString(v);
        return a;
    }

    public static void addURIs(GDoc doc) throws IllegalArgumentException {
        if (doc.collectionID() == null) {
            throw new IllegalArgumentException(doc.id() + " document does not belong to a collection, hence it is not resolvable");
        }
        Nodes.addURIs((Node)doc);
    }

    public static void addURIs(Node n) {
        QName urlName = new QName("http://gcube-system.org/namespaces/contentmanagement/gdoc", "uri", "g");
        try {
            n.setAttribute(urlName, n.uri().toString());
        }
        catch (IllegalStateException abort) {
            return;
        }
        if (n instanceof Leaf) {
            return;
        }
        for (InnerNode child : ((InnerNode)n).children(N)) {
            try {
                child.setAttribute(urlName, child.uri().toString());
                Nodes.addURIs(child);
            }
            catch (IllegalStateException tolerate) {}
        }
    }

    public static void removeURIs(InnerNode n) {
        QName urlName = new QName("http://gcube-system.org/namespaces/contentmanagement/gdoc", "uri");
        n.removeAttribute(urlName);
        for (InnerNode child : n.children(InnerNode.class)) {
            child.removeAttribute(urlName);
            Nodes.removeURIs(child);
        }
    }

    private static String toString(Object v) {
        return v instanceof Date ? Nodes.toDateString((Date)v) : (v instanceof Calendar ? Nodes.toDateString(((Calendar)v).getTime()) : String.valueOf(v));
    }

    public static synchronized String toDateString(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        return typeFactory.newXMLGregorianCalendar(c).toString();
    }

    public static synchronized Date toDate(String date) throws IllegalArgumentException {
        return typeFactory.newXMLGregorianCalendar(date.trim()).toGregorianCalendar().getTime();
    }

    public static boolean matches(QName lbl, QName regexp) {
        return lbl.getNamespaceURI().matches(regexp.getNamespaceURI()) && lbl.getLocalPart().matches(regexp.getLocalPart());
    }

    static {
        try {
            typeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException("could not configure datatype factory", e);
        }
    }

    private static class Attribute {
        public QName name;
        public String value;

        private Attribute() {
        }
    }
}

