/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.ecomodelling.generators.examples.hspec;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.BoundingBoxInformation;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.DistributionGeneratorInterface;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.GenerationModel;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.Hcaf;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.Hspec;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.Hspen;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.subconnectors.Coordinates;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.subconnectors.Envelope;

public class FineProcessing {
    public static void main(String[] args) throws Exception {
        DistributionGeneratorInterface generator = new DistributionGeneratorInterface(GenerationModel.AQUAMAPS, "./cfg/");
        Hspen hspen = new Hspen();
        hspen.setSpeciesID("Fis-124204");
        Envelope temperature = new Envelope("16.97", "23.08", "28.67", "32.87");
        hspen.setTemperature(temperature);
        Envelope depth = new Envelope("0", "126", "434", "1000");
        hspen.setDepth(depth);
        Envelope iceConcentration = new Envelope("-1", "0", "0", "0");
        hspen.setIceConcentration(iceConcentration);
        Envelope landDistance = new Envelope("4", "18", "202", "324");
        hspen.setLandDistance(landDistance);
        Envelope primaryproduction = new Envelope("37", "477", "1399", "1860");
        hspen.setPrimaryProduction(primaryproduction);
        Envelope salinity = new Envelope("29.26", "31.55", "35.31", "38.54");
        hspen.setSalinity(salinity);
        Coordinates coordinates = new Coordinates("28", "10", "-115", "-78", "32.25", "6.25");
        hspen.setCoordinates(coordinates);
        hspen.setLayer("s");
        hspen.setMeanDepth(null);
        hspen.setPelagic(true);
        hspen.setLandDistanceYN(false);
        hspen.setFaoAreas("77");
        Hcaf hcaf = new Hcaf();
        hcaf.setCsquareCode("1000:100:1");
        hcaf.setCenterlat("0.25");
        hcaf.setCenterlong("0.25");
        hcaf.setDepthmax("5014");
        hcaf.setDepthmean("4896");
        hcaf.setDepthmin("4760");
        hcaf.setFaoaream("34");
        hcaf.setIceconann("0");
        hcaf.setLanddist("594");
        hcaf.setOceanarea("3091.036");
        hcaf.setPrimprodmean("450");
        hcaf.setSalinitybmean("34.826");
        hcaf.setSalinitymean("34.76");
        hcaf.setSbtanmean("1.89");
        hcaf.setSstanmean("27.27");
        System.out.println("EXAMPLE 1:");
        double probability = generator.computeProbability(hcaf, hspen);
        System.out.println("Point probability: " + probability);
        System.out.println("EXAMPLE 2:");
        boolean generationFor2050 = false;
        BoundingBoxInformation box = generator.getBoudingBox(hcaf, hspen, generationFor2050);
        System.out.println("In Bounding Box flag:" + box.isInBoundingBox() + " InFAOArea flag:" + box.isInFaoArea());
        System.out.println("EXAMPLE 3:");
        ArrayList<Hcaf> hcaflist = new ArrayList<Hcaf>();
        hcaflist.add(hcaf);
        hcaflist.add(hcaf);
        List<Hspec> hspecList = generator.compute(hcaflist, hspen);
        for (Hspec hspec : hspecList) {
            System.out.println("CALCULATED HSPEC:" + hspec.getSpeciesID() + " , " + hspec.getCsquarecode() + " , " + hspec.getProbability() + " , " + hspec.getBoundingBox().isInBoundingBox() + " , " + hspec.getBoundingBox().isInFaoArea());
        }
        System.out.println("EXAMPLE 4:");
        ArrayList<Hspen> hspenlist = new ArrayList<Hspen>();
        hspenlist.add(hspen);
        HashMap<String, List<Hspec>> hspecMap = generator.compute(hcaflist, hspenlist);
        for (String speciesID : hspecMap.keySet()) {
            List hspecsublist = (List)hspecMap.get(speciesID);
            System.out.println("SPECIES: " + speciesID);
            for (Hspec hspecelement : hspecsublist) {
                System.out.println("CALCULATED HSPEC:" + hspecelement.getSpeciesID() + " , " + hspecelement.getCsquarecode() + " , " + hspecelement.getProbability() + " , " + hspecelement.getBoundingBox().isInBoundingBox() + " , " + hspecelement.getBoundingBox().isInFaoArea());
            }
        }
    }
}

