/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.ecomodelling.generators.processing.experiments;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.gcube.application.aquamaps.ecomodelling.generators.configuration.EngineConfiguration;
import org.gcube.application.aquamaps.ecomodelling.generators.utils.DatabaseFactory;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.hibernate.SessionFactory;

public class CrossSpeciesCalculator {
    HashMap<String, Integer> crossSpecies;
    HashSet<String> speciesSet;
    private static String speciesSelectionQuery = "select speciesid from %1$s";
    private static String selectionQuery = "select csquarecode, speciesid from %1$s limit %2$s offset %3$s";
    private int chunkSize = 152000;
    protected SessionFactory vreConnection;
    private String defaultDatabaseFile = "DestinationDBHibernate.cfg.xml";
    private String defaultLogFile = "ALog.properties";

    private void populateSelectedSpecies(String hspenTable) {
        this.speciesSet = new HashSet();
        String speciesSelectionQueryInst = String.format(speciesSelectionQuery, hspenTable);
        List<Object> species = DatabaseFactory.executeSQLQuery(speciesSelectionQueryInst, this.vreConnection);
        for (Object spec : species) {
            this.speciesSet.add((String)spec);
        }
    }

    public void initDBSession(EngineConfiguration engineConf) throws Exception {
        if (engineConf != null && engineConf.getConfigPath() != null) {
            this.defaultDatabaseFile = engineConf.getConfigPath() + this.defaultDatabaseFile;
            this.defaultLogFile = engineConf.getConfigPath() + this.defaultLogFile;
            AnalysisLogger.setLogger((String)this.defaultLogFile);
            this.vreConnection = DatabaseFactory.initDBConnection(this.defaultDatabaseFile, engineConf);
        }
    }

    public CrossSpeciesCalculator(EngineConfiguration engineConf) throws Exception {
        this.initDBSession(engineConf);
    }

    public void generateCrossSpeciesMap(String hspenTable, String hspecTable) throws Exception {
        AnalysisLogger.getLogger().trace((Object)"CrossSpeciesMap->populating species");
        this.crossSpecies = new HashMap();
        this.populateSelectedSpecies(hspenTable);
        int currentIndex = 0;
        String selectionQueryInst = String.format(selectionQuery, hspecTable, this.chunkSize, currentIndex);
        long t0 = System.currentTimeMillis();
        AnalysisLogger.getLogger().trace((Object)("CrossSpeciesMap->taking chunks of species: " + selectionQueryInst));
        List<Object> csquaresSpecies = DatabaseFactory.executeSQLQuery(selectionQueryInst, this.vreConnection);
        int i = 0;
        while (csquaresSpecies.size() > 0) {
            for (Object row : csquaresSpecies) {
                Object[] rowArr = (Object[])row;
                String csquare = (String)rowArr[0];
                String species = (String)rowArr[1];
                if (!this.speciesSet.contains(species)) continue;
                Integer nspec = this.crossSpecies.get(csquare);
                if (nspec != null) {
                    Integer n = nspec;
                    Integer n2 = nspec = Integer.valueOf(nspec + 1);
                    continue;
                }
                this.crossSpecies.put(csquare, 1);
            }
            long t1 = System.currentTimeMillis();
            AnalysisLogger.getLogger().trace((Object)("CrossSpeciesMap->Processed chunk " + i + " in " + (t1 - t0) + " ms"));
            selectionQueryInst = String.format(selectionQuery, hspecTable, this.chunkSize, currentIndex += this.chunkSize);
            t0 = System.currentTimeMillis();
            AnalysisLogger.getLogger().trace((Object)("CrossSpeciesMap->taking chunks of species: " + selectionQueryInst));
            csquaresSpecies = DatabaseFactory.executeSQLQuery(selectionQueryInst, this.vreConnection);
            ++i;
        }
        this.vreConnection.close();
    }
}

