/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.ecomodelling.generators.test;

import java.util.ArrayList;
import java.util.List;
import org.gcube.application.aquamaps.ecomodelling.generators.configuration.EngineConfiguration;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.EnvelopeGeneratorInterface;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.EnvelopeModel;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.EnvelopeName;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.Hspen;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.subconnectors.Envelope;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.subconnectors.OccurrencePoint;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.subconnectors.OccurrencePointSets;

public class TestFineProcessing {
    public static void main(String[] args) throws Exception {
        EnvelopeGeneratorInterface eg = new EnvelopeGeneratorInterface(EnvelopeModel.AQUAMAPS, "./cfg/");
        EngineConfiguration e = new EngineConfiguration();
        e.setDatabaseUserName("utente");
        e.setDatabasePassword("d4science");
        e.setDatabaseURL("jdbc:postgresql://dbtest.research-infrastructures.eu/aquamapsorgupdated");
        e.setOccurrenceCellsTable("occurrencecells");
        e.setHcafTable("hcaf_d");
        Hspen hspenExample = new Hspen();
        hspenExample.setSpeciesID("Fis-116939");
        hspenExample.setLayer("s");
        hspenExample.setPrimaryProduction(new Envelope("224", "227", "1223", "1687"));
        hspenExample.setSalinity(new Envelope("33.66", "34.16", "35.16", "36.34"));
        hspenExample.setTemperature(new Envelope("22.02", "25.43", "28.44", "32.64"));
        hspenExample.setIceConcentration(new Envelope("-1", "0", "0", "0"));
        hspenExample.setLandDistance(new Envelope("14.5", "16", "27", "111"));
        Hspen newHspen = eg.reCalculateEnvelope(e, hspenExample);
        System.out.println("computation finished for Example - 1\n");
        EnvelopeGeneratorInterface eg2 = new EnvelopeGeneratorInterface(EnvelopeModel.AQUAMAPS, "./cfg/");
        Hspen hspenExample2 = new Hspen();
        hspenExample2.setSpeciesID("Fis-112490");
        hspenExample2.setLayer("s");
        hspenExample2.setPrimaryProduction(new Envelope("224", "227", "1223", "1687"));
        hspenExample2.setSalinity(new Envelope("33.66", "34.16", "35.16", "36.34"));
        hspenExample2.setTemperature(new Envelope("22.02", "25.43", "28.44", "32.64"));
        hspenExample2.setIceConcentration(new Envelope("-1", "0", "0", "0"));
        hspenExample2.setLandDistance(new Envelope("14.5", "16", "27", "111"));
        ArrayList<Hspen> hspenList = new ArrayList<Hspen>();
        hspenList.add(hspenExample);
        hspenList.add(hspenExample2);
        List<Hspen> newHspen2 = eg2.reCalculateEnvelope(e, hspenList);
        System.out.println("computation finished for Example - 2\n");
        EnvelopeGeneratorInterface eg3 = new EnvelopeGeneratorInterface(EnvelopeModel.AQUAMAPS, "./cfg/");
        OccurrencePointSets ocs = new OccurrencePointSets();
        String exampleSpecies = "Fis-116939";
        String occurrenceListTemperature = "" + (Object)((Object)EnvelopeName.TEMPERATURE);
        ArrayList<OccurrencePoint> orderedTemperatureFeatures = new ArrayList<OccurrencePoint>();
        for (int i = 0; i < 21; ++i) {
            orderedTemperatureFeatures.add(new OccurrencePoint(exampleSpecies, "1000:100:" + i, 27.27));
        }
        String occurrenceListSalinity = "" + (Object)((Object)EnvelopeName.SALINITY);
        ArrayList<OccurrencePoint> orderedSalinityFeatures = new ArrayList<OccurrencePoint>();
        for (int i = 0; i < 21; ++i) {
            orderedSalinityFeatures.add(new OccurrencePoint(exampleSpecies, "1000:100:" + i, 34.826));
        }
        String occurrenceListPrimProd = "" + (Object)((Object)EnvelopeName.PRIMARY_PRODUCTION);
        ArrayList<OccurrencePoint> orderedPrimProdFeatures = new ArrayList<OccurrencePoint>();
        for (int i = 0; i < 21; ++i) {
            orderedPrimProdFeatures.add(new OccurrencePoint(exampleSpecies, "1000:100:" + i, 450.0));
        }
        String occurrenceListLanddist = "" + (Object)((Object)EnvelopeName.LAND_DISTANCE);
        ArrayList<OccurrencePoint> orderedLanddistFeatures = new ArrayList<OccurrencePoint>();
        for (int i = 0; i < 21; ++i) {
            orderedLanddistFeatures.add(new OccurrencePoint(exampleSpecies, "1000:100:" + i, 594.0));
        }
        String occurrenceListIceConcentration = "" + (Object)((Object)EnvelopeName.ICE_CONCENTRATION);
        ArrayList<OccurrencePoint> orderedIceConcentrationFeatures = new ArrayList<OccurrencePoint>();
        for (int i = 0; i < 21; ++i) {
            orderedIceConcentrationFeatures.add(new OccurrencePoint(exampleSpecies, "1000:100:" + i, 27.27));
        }
        ocs.addOccurrencePointList(occurrenceListTemperature, orderedTemperatureFeatures);
        ocs.addOccurrencePointList(occurrenceListSalinity, orderedSalinityFeatures);
        ocs.addOccurrencePointList(occurrenceListPrimProd, orderedPrimProdFeatures);
        ocs.addOccurrencePointList(occurrenceListLanddist, orderedLanddistFeatures);
        ocs.addOccurrencePointList(occurrenceListIceConcentration, orderedIceConcentrationFeatures);
        Hspen newHspen3 = eg3.reCalculateEnvelope(hspenExample, ocs);
        System.out.println("computation finished for Example - 3");
    }
}

