/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.ecomodelling.generators.processing.experiments;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.gcube.application.aquamaps.ecomodelling.generators.configuration.EngineConfiguration;
import org.gcube.application.aquamaps.ecomodelling.generators.utils.DatabaseFactory;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.hibernate.SessionFactory;

public class CrossSpeciesGenerator {
    String hspecTableName;
    String tmpTable;
    String username;
    String crossSpeciesTable;
    final double threshold = 0.5;
    final String query = "select csquarecode, count(%1$s.speciesid) as maxspeciescountinacell from %1$s inner join %2$s ON %1$s.speciesid = %2$s.speciesid where probability > %3$s group by csquarecode order by maxspeciescountinacell DESC";
    final String createTempTableQuery = "create table %1$s ( speciesid character varying) WITH (OIDS=FALSE ); ALTER TABLE %1$s OWNER TO %2$s; CREATE INDEX %1$s_idx ON %1$s USING btree (speciesid)";
    final String dropTempTableQuery = "drop table %1$s";
    final String createCrossSpeciesQuery = "create table %1$s ( csquarecode character varying, maxspeciescountinacell integer ) WITH (OIDS=FALSE ); ALTER TABLE %1$s OWNER TO %2$s; CREATE INDEX %1$s_idx ON %1$s USING btree (csquarecode)";
    final String insertionStatement = "insert into %1$s values %2$s;";
    String defaultDatabaseFile = "DestinationDBHibernate.cfg.xml";
    String defaultLogFile = "ALog.properties";
    String default_species_list = "selectedSpecies.txt";
    private SessionFactory vreConnection;
    private ArrayList<Object> selectedSpecies;
    private List<Object> crossSpecies;

    private void createSpeciesTempTable() {
        AnalysisLogger.getLogger().trace("creating cross species temporary table");
        this.tmpTable = "tmp_speciesList_" + UUID.randomUUID();
        this.tmpTable = this.tmpTable.replace("-", "");
        String createTempQuery = String.format("create table %1$s ( speciesid character varying) WITH (OIDS=FALSE ); ALTER TABLE %1$s OWNER TO %2$s; CREATE INDEX %1$s_idx ON %1$s USING btree (speciesid)", this.tmpTable, this.username);
        try {
            DatabaseFactory.executeSQLUpdate(createTempQuery, this.vreConnection);
            AnalysisLogger.getLogger().trace("creating cross species temporary table - OK!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cleanTargetTable() {
        String dropTargetQuery = String.format("drop table %1$s", this.crossSpeciesTable);
        AnalysisLogger.getLogger().trace("destroying crossSpeciesTable table");
        try {
            DatabaseFactory.executeSQLUpdate(dropTargetQuery, this.vreConnection);
        }
        catch (Exception e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().trace("could not destroy crossSpeciesTable table .. continuing");
        }
    }

    private void destroySpeciesTempTable() {
        String dropTempQuery = String.format("drop table %1$s", this.tmpTable);
        AnalysisLogger.getLogger().trace("destroying temporary table");
        try {
            DatabaseFactory.executeSQLUpdate(dropTempQuery, this.vreConnection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void populateTempTable() {
        AnalysisLogger.getLogger().trace("populating temporary table");
        try {
            StringBuffer buffer = new StringBuffer();
            int size = this.selectedSpecies.size();
            int i = 0;
            for (Object species : this.selectedSpecies) {
                String species$ = (String)species;
                buffer.append("('" + species + "'" + ")");
                if (i < size - 1) {
                    buffer.append(",");
                }
                ++i;
            }
            AnalysisLogger.getLogger().trace("species buffer fullfilled");
            AnalysisLogger.getLogger().trace("Writing table of species names");
            String insertQuery = String.format("insert into %1$s values %2$s;", this.tmpTable, buffer.toString());
            DatabaseFactory.executeSQLUpdate(insertQuery, this.vreConnection);
            AnalysisLogger.getLogger().trace("populating temporary table - OK");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void populateCrossSpeciesBuffer() {
        String crossspeciesQuery = String.format("select csquarecode, count(%1$s.speciesid) as maxspeciescountinacell from %1$s inner join %2$s ON %1$s.speciesid = %2$s.speciesid where probability > %3$s group by csquarecode order by maxspeciescountinacell DESC", this.hspecTableName, this.tmpTable, 0.5);
        AnalysisLogger.getLogger().trace("populating cross-species table: " + crossspeciesQuery);
        long t0 = System.currentTimeMillis();
        try {
            this.crossSpecies = DatabaseFactory.executeSQLQuery(crossspeciesQuery, this.vreConnection);
            long t1 = System.currentTimeMillis();
            AnalysisLogger.getLogger().trace("populating cross-species table - OK - elapsed: " + (t1 - t0) + " ms");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveCrossSpeciesTable() {
        String crossSpeciesQuery = String.format("create table %1$s ( csquarecode character varying, maxspeciescountinacell integer ) WITH (OIDS=FALSE ); ALTER TABLE %1$s OWNER TO %2$s; CREATE INDEX %1$s_idx ON %1$s USING btree (csquarecode)", this.crossSpeciesTable, this.username);
        AnalysisLogger.getLogger().trace("saving cross-species object");
        try {
            DatabaseFactory.executeSQLUpdate(crossSpeciesQuery, this.vreConnection);
            StringBuffer buffer = new StringBuffer();
            int size = this.crossSpecies.size();
            int i = 0;
            for (Object speciesCount : this.crossSpecies) {
                Object[] speciesCountRow = (Object[])speciesCount;
                String species = "" + speciesCountRow[0];
                String count = "" + speciesCountRow[1];
                buffer.append("('" + species + "'" + "," + "'" + count + "'" + ")");
                if (i < size - 1) {
                    buffer.append(",");
                }
                ++i;
            }
            AnalysisLogger.getLogger().trace("object buffer fullfilled");
            AnalysisLogger.getLogger().trace("Writing table of species");
            String insertQuery = String.format("insert into %1$s values %2$s;", this.crossSpeciesTable, buffer.toString());
            DatabaseFactory.executeSQLUpdate(insertQuery, this.vreConnection);
            AnalysisLogger.getLogger().trace("saving cross-species object - OK");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initDBSession(EngineConfiguration engineConf) throws Exception {
        if (engineConf != null && engineConf.getConfigPath() != null) {
            AnalysisLogger.getLogger().trace("Initializing Database Connection");
            this.defaultDatabaseFile = engineConf.getConfigPath() + this.defaultDatabaseFile;
            this.vreConnection = DatabaseFactory.initDBConnection(this.defaultDatabaseFile, engineConf);
        }
    }

    public void shutdownConnection() {
        AnalysisLogger.getLogger().trace("Shuttingdown Database Connection");
        this.vreConnection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateSelectedSpecies() {
        BufferedReader br = null;
        if (this.selectedSpecies == null) {
            AnalysisLogger.getLogger().trace("fulfilling species list");
            try {
                br = new BufferedReader(new FileReader(this.default_species_list));
                this.selectedSpecies = new ArrayList();
                String line = br.readLine();
                while (line != null) {
                    this.selectedSpecies.add(line.trim());
                    line = br.readLine();
                }
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().trace("SELECTED SPECIES - FILE NOT FOUND");
            }
            finally {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
            AnalysisLogger.getLogger().trace("fulfilling species list - OK!");
        }
    }

    public void generateCrossSpeciesTable(EngineConfiguration engine, String crossSpeciesTable) throws Exception {
        if (engine != null) {
            this.defaultLogFile = engine.getConfigPath() + this.defaultLogFile;
            this.default_species_list = engine.getConfigPath() + this.default_species_list;
            AnalysisLogger.setLogger((String)this.defaultLogFile);
            this.username = engine.getDatabaseUserName();
            this.crossSpeciesTable = crossSpeciesTable;
            this.hspecTableName = engine.getDistributionTable();
            this.initDBSession(engine);
            this.cleanTargetTable();
            this.populateSelectedSpecies();
            this.createSpeciesTempTable();
            this.populateTempTable();
            this.populateCrossSpeciesBuffer();
            this.saveCrossSpeciesTable();
            this.destroySpeciesTempTable();
            this.shutdownConnection();
        }
    }
}

