/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.gcubedocumentlibrary.io;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.contentmanagement.contentmanager.stubs.calls.ManagerCall;
import org.gcube.contentmanagement.contentmanager.stubs.calls.exceptions.UnknownDocumentException;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.RemoteIterator;
import org.gcube.contentmanagement.contentmanager.stubs.model.protocol.URIs;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Node;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.BaseReader;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentCache;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentReader;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.SimpleLRUCache;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.DocumentProjection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projection;
import org.gcube.contentmanagement.gcubedocumentlibrary.streams.dsl.Streams;
import org.gcube.contentmanagement.gcubedocumentlibrary.streams.faults.FaultPolicy;
import org.gcube.contentmanagement.gcubedocumentlibrary.streams.filters.Processor;
import org.gcube.contentmanagement.gcubemodellibrary.elements.BaseInnerElement;
import org.gcube.contentmanagement.gcubemodellibrary.elements.Conversions;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeElement;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeInnerElement;

public class CachingReader
extends BaseReader {
    private DocumentReader inner;
    private DocumentCache cache;

    public CachingReader(DocumentReader r, DocumentCache c) {
        this.inner = r;
        this.cache = c;
    }

    public CachingReader(DocumentReader r) {
        this(r, new SimpleLRUCache());
    }

    @Override
    public String collectionID() {
        return this.inner.collectionID();
    }

    private GCubeDocument getAndValidate(GCubeDocument doc, Projection<?, ?> p) throws Exception {
        return doc == null || !p.documentPredicate().matches((Node)Conversions.toTree((GCubeDocument)doc)) ? null : doc;
    }

    @Override
    public GCubeDocument get(String id, Projection<?, ?> p) throws UnknownDocumentException, ManagerCall.DiscoveryException, GCUBEException, Exception {
        GCubeDocument doc = this.getAndValidate(this.cache.get(id), p);
        if (doc == null) {
            doc = this.inner.get(id, p);
            this.cache.put(doc);
        }
        return doc;
    }

    @Override
    public RemoteIterator<GCubeDocument> get(Iterator<String> ids, final Projection<?, ?> p) throws ManagerCall.DiscoveryException, GCUBEException, Exception {
        Object newDocuments;
        final LinkedList cachedDocuments = new LinkedList();
        Iterator<String> newIDs = Streams.pipe(ids).through(new Processor<String>(){

            @Override
            protected void process(String element) throws Exception {
                GCubeDocument doc = CachingReader.this.getAndValidate(CachingReader.this.cache.get(element), p);
                if (doc != null) {
                    cachedDocuments.add(doc);
                    throw new FaultPolicy.SkipElementException();
                }
            }
        }).withDefaults();
        if (newIDs.hasNext()) {
            RemoteIterator<GCubeDocument> remotes = this.inner.get(newIDs, p);
            newDocuments = Streams.pipe(remotes).through(new CachingProcessor()).withRemoteDefaults();
        } else {
            newDocuments = Streams.convert(new ArrayList().iterator());
        }
        return new CacheAppender<GCubeDocument>(cachedDocuments.iterator(), (RemoteIterator<GCubeDocument>)newDocuments);
    }

    @Override
    public RemoteIterator<GCubeDocument> get(Projection<?, ?> p) throws ManagerCall.DiscoveryException, GCUBEException, Exception {
        return Streams.pipe(this.inner.get(p)).through(new CachingProcessor()).withRemoteDefaults();
    }

    @Override
    public <EL extends GCubeInnerElement> EL resolve(URI uri, Projection<EL, ?> p) throws IllegalArgumentException, UnknownDocumentException, ManagerCall.DiscoveryException, GCUBEException, Exception {
        Object el;
        GCubeDocument doc = this.getAndValidate(this.cache.get(URIs.documentID((URI)uri)), new DocumentProjection(this.mergeURI(uri, p)));
        if (doc == null) {
            el = this.inner.resolve(uri, p);
            this.cache.put(this.toDocument((GCubeElement)el));
        } else {
            el = (GCubeInnerElement)this.fromDocument(URIs.nodeID((URI)uri), doc);
        }
        return el;
    }

    @Override
    public <EL extends GCubeInnerElement> RemoteIterator<EL> resolve(Iterator<URI> uris, final Projection<EL, ?> p) throws ManagerCall.DiscoveryException, GCUBEException, Exception {
        Object newElements;
        final LinkedList cachedElements = new LinkedList();
        Iterator<URI> newURIs = Streams.pipe(uris).through(new Processor<URI>(){

            @Override
            protected void process(URI element) throws Exception {
                GCubeDocument doc = CachingReader.this.getAndValidate(CachingReader.this.cache.get(URIs.documentID((URI)element)), new DocumentProjection(CachingReader.this.mergeURI(element, p)));
                if (doc != null) {
                    GCubeInnerElement el = (GCubeInnerElement)CachingReader.this.fromDocument(URIs.nodeID((URI)element), doc);
                    cachedElements.add(el);
                    throw new FaultPolicy.SkipElementException();
                }
            }
        }).withDefaults();
        if (newURIs.hasNext()) {
            RemoteIterator<EL> remotes = this.inner.resolve(newURIs, p);
            newElements = Streams.pipe(remotes).through(new CachingProcessor()).withRemoteDefaults();
        } else {
            newElements = Streams.convert(new ArrayList().iterator());
        }
        return new CacheAppender(cachedElements.iterator(), newElements);
    }

    private GCubeDocument toDocument(GCubeElement el) {
        return el instanceof GCubeDocument ? (GCubeDocument)el : ((BaseInnerElement)el).document();
    }

    private static class CacheAppender<T>
    implements RemoteIterator<T> {
        private Iterator<T> it1;
        private RemoteIterator<T> rit2;

        public CacheAppender(Iterator<T> it1, RemoteIterator<T> rit2) {
            this.it1 = it1;
            this.rit2 = rit2;
        }

        public boolean hasNext() {
            return this.it1.hasNext() ? true : this.rit2.hasNext();
        }

        public T next() throws Exception, NoSuchElementException {
            if (this.it1.hasNext()) {
                return this.it1.next();
            }
            if (this.rit2.hasNext()) {
                return (T)this.rit2.next();
            }
            throw new NoSuchElementException();
        }

        public String locator() {
            return this.rit2.locator();
        }

        public void close() {
            this.rit2.close();
        }
    }

    private class CachingProcessor<EL extends GCubeElement>
    extends Processor<EL> {
        private CachingProcessor() {
        }

        @Override
        protected void process(EL element) throws Exception {
            CachingReader.this.cache.put(CachingReader.this.toDocument(element));
        }
    }
}

