/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.gcubedocumentlibrary.io;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.stubs.calls.ManagerCall;
import org.gcube.contentmanagement.contentmanager.stubs.calls.exceptions.UnknownDocumentException;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.RemoteIterator;
import org.gcube.contentmanagement.contentmanager.stubs.model.constraints.AnyValue;
import org.gcube.contentmanagement.contentmanager.stubs.model.constraints.Constraint;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.EdgePredicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.LeafPredicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Predicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.TreePredicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.protocol.URIs;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.BaseReader;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.InvalidProjectionException;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.Reader;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.AlternativeProjection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.AnnotationProjection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.DocumentProjection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.MetadataProjection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.PartProjection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projections;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.PropertyProjection;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeElement;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeInnerElement;

public class ViewReader
extends BaseReader {
    private static GCUBELog logger = new GCUBELog(ViewReader.class);
    private Projection<? extends GCubeElement, ?> view;
    private Reader reader;
    private static Map<QName, TreePredicate> empties = new HashMap<QName, TreePredicate>();

    public ViewReader(Projection<?, ?> f, Reader r) {
        this.view = f;
        this.reader = r;
    }

    @Override
    public String collectionID() {
        return this.reader.collectionID();
    }

    @Override
    public GCubeDocument get(String id, Projection<?, ?> p) throws InvalidProjectionException, UnknownDocumentException, ManagerCall.DiscoveryException, GCUBEException, Exception {
        return this.reader.get(id, this.merge(this.view.documentPredicate(), p.documentPredicate()));
    }

    public Projection<?, ?> view() {
        return this.view;
    }

    @Override
    public RemoteIterator<GCubeDocument> get(Iterator<String> ids, Projection<?, ?> p) throws InvalidProjectionException, ManagerCall.DiscoveryException, GCUBEException, Exception {
        return this.reader.get(ids, this.merge(this.view.documentPredicate(), p.documentPredicate()));
    }

    @Override
    public RemoteIterator<GCubeDocument> get(Projection<?, ?> p) throws InvalidProjectionException, GCUBEException, Exception {
        return this.reader.get(this.merge(this.view.documentPredicate(), p.documentPredicate()));
    }

    @Override
    public <EL extends GCubeInnerElement> EL resolve(URI uri, Projection<EL, ?> p) throws IllegalArgumentException, InvalidProjectionException, UnknownDocumentException, ManagerCall.DiscoveryException, GCUBEException, Exception {
        logger.trace((Object)("getting element " + uri + " that matches " + p.predicate()));
        TreePredicate predicate = this.mergeURI(uri, p);
        DocumentProjection merged = this.merge(this.view.documentPredicate(), predicate);
        String id = URIs.documentID((URI)uri);
        GCubeDocument doc = this.reader.get(id, merged);
        GCubeInnerElement element = (GCubeInnerElement)this.fromDocument(URIs.nodeID((URI)uri), doc);
        return (EL)element;
    }

    @Override
    public <EL extends GCubeInnerElement> RemoteIterator<EL> resolve(Iterator<URI> uris, Projection<EL, ?> p) throws ManagerCall.DiscoveryException, GCUBEException, Exception {
        return this.reader.resolve(uris, p);
    }

    DocumentProjection merge(TreePredicate view, TreePredicate input) {
        TreePredicate merged = this.recmerge(view, this.expand(input));
        return new DocumentProjection(merged);
    }

    TreePredicate recmerge(TreePredicate view, TreePredicate input) {
        ArrayList<EdgePredicate> merged = new ArrayList<EdgePredicate>(view.getPredicates());
        Iterator i$ = input.getPredicates().iterator();
        while (i$.hasNext()) {
            EdgePredicate inputEP;
            EdgePredicate mergedEP = inputEP = (EdgePredicate)i$.next();
            EdgePredicate viewEP = view.getPredicate(inputEP.label());
            if (viewEP != null) {
                try {
                    TreePredicate mergedTarget;
                    merged.remove(viewEP);
                    mergedEP = this.merge(viewEP, inputEP);
                    Predicate viewEPTarget = viewEP.predicate();
                    Predicate inputEPTarget = inputEP.predicate();
                    if (viewEPTarget instanceof LeafPredicate) {
                        mergedTarget = this.merge((LeafPredicate)viewEPTarget, (LeafPredicate)inputEPTarget);
                    } else {
                        TreePredicate expanded = this.expand((TreePredicate)inputEPTarget, inputEP.label());
                        mergedTarget = this.recmerge((TreePredicate)viewEPTarget, expanded);
                    }
                    mergedEP.setPredicate(mergedTarget);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(input + " clashes with " + view + " at " + inputEP.label() + "\n", e);
                }
            }
            merged.add(mergedEP);
        }
        TreePredicate tp = new TreePredicate(merged);
        tp.setIdPredicate(input.getIdPredicate());
        return tp;
    }

    private LeafPredicate<?, ?> merge(LeafPredicate<?, ?> viewLP, LeafPredicate<?, ?> inputLP) throws InvalidProjectionException {
        Constraint mergedConstraint;
        Class<?> viewLPClass = viewLP.getClass();
        if (!viewLPClass.isAssignableFrom(inputLP.getClass())) {
            throw new InvalidProjectionException(viewLP + " is not compatible with " + inputLP);
        }
        Constraint viewLPConstraint = viewLP.constraint();
        Constraint inputLPConstraint = inputLP.constraint();
        if (viewLPConstraint.getClass().equals(AnyValue.class)) {
            mergedConstraint = inputLPConstraint;
        } else if (inputLPConstraint.getClass().equals(AnyValue.class)) {
            mergedConstraint = viewLPConstraint;
        } else {
            if (!viewLPConstraint.equals(inputLPConstraint)) {
                throw new InvalidProjectionException(viewLP.constraint() + " is not compatible with " + inputLP.constraint());
            }
            mergedConstraint = viewLPConstraint;
        }
        try {
            return (LeafPredicate)viewLP.getClass().getConstructor(Constraint.class).newInstance(mergedConstraint);
        }
        catch (Throwable e) {
            throw new RuntimeException("unexpected error instantiating ", e);
        }
    }

    private EdgePredicate merge(EdgePredicate viewEP, EdgePredicate inputEP) {
        EdgePredicate ep = null;
        if (inputEP.range().includes(viewEP.range())) {
            ep = viewEP;
            if (inputEP.isCondition()) {
                ep.setAsCondition();
            } else {
                ep.unsetAsCondition();
            }
        } else if (viewEP.range().includes(inputEP.range())) {
            ep = inputEP;
        } else {
            throw new IllegalArgumentException("view cardinality of " + viewEP.getClass() + "and input cardinality of " + inputEP.getClass() + " are not compatible");
        }
        return ep;
    }

    private TreePredicate expand(TreePredicate input) {
        return this.expand(input, null);
    }

    private TreePredicate expand(TreePredicate input, QName name) {
        if (input.getPredicates().size() > 0) {
            return input;
        }
        TreePredicate expanded = new TreePredicate(empties.get(name).getPredicates());
        expanded.setIdPredicate(input.getIdPredicate());
        return expanded;
    }

    static {
        empties.put(null, ((DocumentProjection)Projections.document().etc()).predicate());
        empties.put(Projections.METADATA.name(), ((MetadataProjection)Projections.metadata().etc()).predicate());
        empties.put(Projections.ANNOTATION.name(), ((AnnotationProjection)Projections.annotation().etc()).predicate());
        empties.put(Projections.PART.name(), ((PartProjection)Projections.part().etc()).predicate());
        empties.put(Projections.ALTERNATIVE.name(), ((AlternativeProjection)Projections.alternative().etc()).predicate());
        empties.put(Projections.PROPERTY.name(), ((PropertyProjection)Projections.property().etc()).predicate());
    }
}

