/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.gcubedocumentlibrary.projections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.gcube.contentmanagement.contentmanager.stubs.model.constraints.Constraint;
import org.gcube.contentmanagement.contentmanager.stubs.model.constraints.Constraints;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.EdgePredicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.LeafPredicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Many;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Predicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Predicates;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.TreePredicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Nodes;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projections;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.Property;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.PropertyTypes;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeElement;

public abstract class BaseProjection<E extends GCubeElement, P extends Property, SELF extends BaseProjection<E, P, SELF>>
implements Projection<E, P> {
    static final List<PropertyTypes.CommonProperty> COMMONPROPERTIES = Arrays.asList(Projections.NAME, Projections.CREATION_TIME, Projections.LANGUAGE, Projections.LAST_UPDATE, Projections.BYTESTREAM, Projections.BYTESTREAM_URI, Projections.MIME_TYPE, Projections.SCHEMA_NAME, Projections.SCHEMA_URI, Projections.LENGTH, Projections.PROPERTY);
    private Map<QName, P> validProperties = new HashMap<QName, P>();
    private Map<P, EdgePredicate> constraints = new HashMap<P, EdgePredicate>();
    private LeafPredicate<?, ?> idPredicate = null;

    BaseProjection() {
        Iterator<PropertyTypes.CommonProperty> i$ = COMMONPROPERTIES.iterator();
        while (i$.hasNext()) {
            PropertyTypes.CommonProperty common;
            PropertyTypes.CommonProperty p = common = i$.next();
            this.validProperties.put(p.name(), p);
        }
        for (Property p : this.validProperties()) {
            this.validProperties.put(p.newPredicate().label(), p);
        }
    }

    BaseProjection(TreePredicate p) {
        this();
        for (EdgePredicate ep : p.getPredicates()) {
            Property prop = (Property)this.validProperties.get(ep.label());
            if (prop == null) continue;
            this.constraints.put(prop, ep);
        }
        this.idPredicate = p.getIdPredicate();
    }

    BaseProjection(Projection<E, P> p) {
        this();
        for (Map.Entry<P, Predicate> entry : p.constraints().entrySet()) {
            this.constraints.put(entry.getKey(), ((Property)entry.getKey()).newPredicate(entry.getValue()));
        }
    }

    public SELF with(P property, P ... properties) {
        this.with(property, property.newPredicate().predicate());
        for (P prop : properties) {
            this.with(prop, prop.newPredicate().predicate());
        }
        return this.self();
    }

    public SELF withValue(P property, Object o) {
        return this.with(property, (Predicate)Predicates.text((Constraint)Constraints.is((Object)Nodes.l((Object)o).value())));
    }

    public SELF with(P property, Predicate p) {
        this.constraints.put(property, property.newPredicate(p));
        return this.self();
    }

    public SELF with(P prop, EdgePredicate ep) throws IllegalArgumentException {
        if (!prop.name().equals(ep.label())) {
            throw new IllegalStateException("edge predicate's " + ep.label() + " does not match property's" + prop.name());
        }
        ep.unsetAsCondition();
        this.constraints.put(prop, ep);
        return this.self();
    }

    public SELF with(P property, Projection<?, ?> p) {
        return this.with(property, (Predicate)p.predicate());
    }

    public SELF where(P property, P ... properties) {
        this.where(property, property.newPredicate().predicate());
        for (P prop : properties) {
            this.where(prop, prop.newPredicate().predicate());
        }
        return this.self();
    }

    public SELF whereValue(P property, Object o) {
        return this.where(property, (Predicate)Predicates.text((Constraint)Constraints.is((Object)Nodes.l((Object)o).value())));
    }

    public SELF where(P prop, Predicate pred) {
        EdgePredicate ep = prop.newPredicate(pred);
        ep.setAsCondition();
        this.constraints.put(prop, ep);
        return this.self();
    }

    public SELF where(P prop, EdgePredicate ep) throws IllegalArgumentException {
        if (!prop.name().equals(ep.label())) {
            throw new IllegalStateException("edge predicate's " + ep.label() + " does not match property's" + prop.name());
        }
        ep.setAsCondition();
        this.constraints.put(prop, ep);
        return this.self();
    }

    public SELF where(P property, Projection<?, ?> p) {
        return this.where(property, (Predicate)p.predicate());
    }

    public SELF etc() {
        for (Property p : this.validProperties.values()) {
            if (this.isConstrained(p)) continue;
            this.with(Projections.opt(p), new Property[0]);
        }
        return this.self();
    }

    public SELF allexcept(P property, P ... properties) {
        ArrayList<P> props = new ArrayList<P>(Arrays.asList(properties));
        props.add(property);
        for (Property p : this.validProperties.values()) {
            if (this.isConstrained(p) || props.contains(p)) continue;
            this.with(Projections.opt(p), new Property[0]);
        }
        return this.self();
    }

    public boolean isConstrained(P p) {
        return this.constraints.containsKey(p);
    }

    public boolean isFiltered(P p) {
        return this.isConstrained(p) ? this.predicate().getPredicate(p.name()).isCondition() : false;
    }

    public boolean isIncluded(P p) {
        return this.isConstrained(p) ? !this.predicate().getPredicate(p.name()).isCondition() : false;
    }

    public boolean isOptional(P p) {
        return this.isConstrained(p) ? this.predicate().getPredicate(p.name()) instanceof Many : false;
    }

    public boolean isExcluded(P p) {
        return this.isFiltered(p) || this.isOptional(p);
    }

    protected abstract SELF self();

    protected abstract List<P> validProperties();

    @Override
    public Map<P, Predicate> constraints() {
        HashMap<P, Predicate> cs = new HashMap<P, Predicate>();
        for (Map.Entry<P, EdgePredicate> entry : this.constraints.entrySet()) {
            cs.put(entry.getKey(), entry.getValue().predicate());
        }
        return cs;
    }

    @Override
    public TreePredicate predicate() {
        try {
            TreePredicate p = (TreePredicate)Predicates.clone((Predicate)new TreePredicate(new ArrayList<EdgePredicate>(this.constraints.values())));
            return Predicates.id(this.idPredicate, (TreePredicate)p);
        }
        catch (Exception e) {
            throw new RuntimeException("could not clone " + this);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return this.predicate().equals((Object)((Projection)obj).predicate());
    }

    public int hashCode() {
        return this.predicate().hashCode();
    }

    public String toString() {
        return this.documentPredicate().toString();
    }
}

