/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.gcubedocumentlibrary.streams.folding;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.RemoteIterator;
import org.gcube.contentmanagement.gcubedocumentlibrary.streams.faults.IFaultPolicy;
import org.gcube.contentmanagement.gcubedocumentlibrary.streams.filters.Filter;

public abstract class UnfoldingAbstractAdapter<FROM, TO, E extends Exception> {
    private RemoteIterator<FROM> inner;
    private Iterator<? extends TO> elements;
    private int faultCount;
    private Filter<FROM, List<TO>> filter;
    private IFaultPolicy<? extends E> errorHandler;

    public UnfoldingAbstractAdapter(RemoteIterator<FROM> rit, Filter<FROM, List<TO>> f, IFaultPolicy<? extends E> h) {
        this.inner = rit;
        this.filter = f;
        this.errorHandler = h;
    }

    protected RemoteIterator<FROM> inner() {
        return this.inner;
    }

    public boolean hasNext() {
        if (this.elements != null && this.elements.hasNext()) {
            return true;
        }
        if (this.inner.hasNext()) {
            try {
                this.elements = this.filter.apply(this.inner.next()).iterator();
                return this.hasNext();
            }
            catch (Exception e) {
                ++this.faultCount;
                return this.delegateToHandler(e, this.faultCount);
            }
        }
        return false;
    }

    protected IFaultPolicy<? extends E> errorHandler() {
        return this.errorHandler;
    }

    protected abstract boolean delegateToHandler(Exception var1, int var2);

    public TO next() throws E {
        if (this.elements == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.elements.next();
    }
}

