/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.gcubedocumentlibrary.util;

import java.io.Reader;
import java.io.StringReader;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.XMLResult;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericResourceQuery;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.gcubedocumentlibrary.util.Collection;
import org.gcube.contentmanagement.gcubedocumentlibrary.util.CollectionDescription;

public class Collections {
    public static final String PROVIDER_NS = "declare namespace gc = 'http://gcube-system.org/namespaces/common/core/porttypes/GCUBEProvider';\n";
    public static final String COMMON_NS = "declare namespace common = 'http://gcube-system.org/namespaces/common';\n";
    protected static final String CONTENT_NS = "declare namespace content = 'http://gcube-system.org/namespaces/contentmanagement/contentmanager';\n";
    protected static GCUBELog logger = new GCUBELog(Collections.class);
    private static JAXBContext jaxbContext = null;

    private static synchronized JAXBContext getJAXBContext() throws Exception {
        if (jaxbContext == null) {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{CollectionDescription.class});
        }
        return jaxbContext;
    }

    public static List<Collection> findById(String id) throws Exception {
        return Collections.find(GCUBEScopeManager.DEFAULT.getScope(), new Collection(id, null, null, null, null));
    }

    public static List<Collection> findById(GCUBEScope scope, String id) throws Exception {
        return Collections.find(scope, new Collection(id, null, null, null, null));
    }

    public static List<Collection> findByName(String name) throws Exception {
        return Collections.find(GCUBEScopeManager.DEFAULT.getScope(), new Collection(null, name, null, null, null));
    }

    public static List<Collection> findByName(GCUBEScope scope, String name) throws Exception {
        return Collections.find(scope, new Collection(null, name, null, null, null));
    }

    public static List<Collection> list() throws Exception {
        return Collections.find(GCUBEScopeManager.DEFAULT.getScope(), new Collection[0]);
    }

    public static List<Collection> list(GCUBEScope scope) throws Exception {
        return Collections.find(scope, new Collection[0]);
    }

    public static List<Collection> find(Collection ... collection) throws Exception {
        return Collections.find(GCUBEScopeManager.DEFAULT.getScope(), new Collection[0]);
    }

    public static List<Collection> find(GCUBEScope scope, Collection ... collection) throws Exception {
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBEGenericResourceQuery query = (GCUBEGenericResourceQuery)client.getQuery(GCUBEGenericResourceQuery.class);
        query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/SecondaryType", "GCUBECollection")});
        if (collection != null && collection.length > 0) {
            Collection collectionStub = collection[0];
            if (collectionStub.getId() != null) {
                query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/ID", collectionStub.getId())});
            }
            if (collectionStub.getName() != null) {
                query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/Name", collectionStub.getName())});
            }
            if (collectionStub.getDescription() != null) {
                query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/Description", collectionStub.getDescription())});
            }
            if (collectionStub.getUserCollection() != null) {
                query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/Body/CollectionInfo/user", String.valueOf(collectionStub.isUserCollection()))});
            }
        }
        List resources = client.execute((ISQuery)query, scope);
        return Collections.getCollections(resources);
    }

    protected static List<Collection> getCollections(List<GCUBEGenericResource> resources) throws Exception {
        LinkedList<Collection> collections = new LinkedList<Collection>();
        for (GCUBEGenericResource resource : resources) {
            collections.add(Collections.getCollection(resource));
        }
        return collections;
    }

    protected static Collection getCollection(GCUBEGenericResource resource) throws JAXBException, Exception {
        String id = resource.getID();
        String name = resource.getName();
        String description = resource.getDescription();
        CollectionDescription collectionDescription = (CollectionDescription)Collections.getJAXBContext().createUnmarshaller().unmarshal((Reader)new StringReader(resource.getBody()));
        Boolean isUserCollection = collectionDescription.isUser();
        Calendar creationTime = collectionDescription.getCreationTime();
        return new Collection(id, name, description, creationTime, isUserCollection);
    }

    protected static String getCardinalityQuery(String collectionId) {
        StringBuilder expression = new StringBuilder();
        expression.append(PROVIDER_NS);
        expression.append(COMMON_NS);
        expression.append(CONTENT_NS);
        expression.append("for $outer in collection(\"/db/Properties\")//Document, $res in $outer/Data where $res/gc:ServiceClass/string() eq 'ContentManagement' and $res/gc:ServiceName/string() eq 'ContentManager' and ($res/common:Type/string() eq 'gDocRead' or $res/common:Type/string() eq 'gDocWrite') and $res/common:CollectionID/string() eq '");
        expression.append(collectionId);
        expression.append("' return <Cardinality>{$outer/Data/content:Cardinality/string()}</Cardinality>");
        return expression.toString();
    }

    public static int getCardinality(String collectionId) throws Exception {
        return Collections.getCardinality(GCUBEScopeManager.DEFAULT.getScope(), collectionId);
    }

    public static int getCardinality(GCUBEScope scope, String collectionId) throws Exception {
        Iterator i$;
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBEGenericQuery query = (GCUBEGenericQuery)client.getQuery(GCUBEGenericQuery.class);
        String expression = Collections.getCardinalityQuery(collectionId);
        logger.trace((Object)("Query: " + expression));
        query.setExpression(expression);
        List listWSResources = client.execute((ISQuery)query, scope);
        if (listWSResources.size() > 0 && (i$ = listWSResources.iterator()).hasNext()) {
            XMLResult result = (XMLResult)i$.next();
            List cardinalities = result.evaluate("/Cardinality/text()");
            if (cardinalities.size() != 1) {
                throw new Exception("Wrong Collection resource, the Cardinality tag is missing");
            }
            String cardinality = (String)cardinalities.get(0);
            return Integer.parseInt(cardinality);
        }
        throw new Exception("No results found for IS query.");
    }
}

