/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.gcubedocumentlibrary.views;

import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.informationsystem.ISException;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.stubs.calls.ManagerCall;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.Property;
import org.gcube.contentmanagement.gcubedocumentlibrary.views.AnnotationView;
import org.gcube.contentmanagement.gcubedocumentlibrary.views.CollectionView;
import org.gcube.contentmanagement.gcubedocumentlibrary.views.GenericView;
import org.gcube.contentmanagement.gcubedocumentlibrary.views.MetadataView;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeElement;
import org.gcube.contentmanagement.viewmanager.stubs.model.View;
import org.gcube.contentmanagement.viewmanager.stubs.model.ViewProperty;

public class Views {
    private static GCUBELog logger = new GCUBELog(Views.class);
    static final String PROVIDER_NS = "declare namespace gc = 'http://gcube-system.org/namespaces/common/core/porttypes/GCUBEProvider';\n";
    static final String CONTENT_NS = "declare namespace content = 'http://gcube-system.org/namespaces/contentmanagement/contentmanager';\n";
    static final String VIEWMANAGER_NS = "declare namespace wmns= 'http://gcube-system.org/namespaces/contentmanagement/viewmanager';\n";
    static ISClient client;
    static Map<QName, Class<? extends CollectionView<?, ?>>> viewTypes;
    protected static JAXBContext context;

    static synchronized ISClient client() {
        if (client == null) {
            try {
                client = (ISClient)GHNContext.getImplementation(ISClient.class);
            }
            catch (Exception e) {
                throw new RuntimeException("could not instantiate client", e);
            }
        }
        return client;
    }

    public static void registerType(QName n, Class<? extends CollectionView<?, ?>> c) {
        viewTypes.put(n, c);
    }

    static String newQuery(CollectionView<?, ?> view) {
        StringBuilder expression = new StringBuilder();
        expression.append(PROVIDER_NS);
        expression.append(VIEWMANAGER_NS);
        expression.append("for $outer in collection(\"/db/Properties\")//Document, $res in  $outer/Data where $res/gc:ServiceClass/string() eq 'ContentManagement' and $res/gc:ServiceName/string() eq 'ViewManager' and count($res//wmns:View)>0");
        if (view.id() != null) {
            expression.append(" and $res/wmns:View/wmns:id/string() eq '");
            expression.append(view.id());
            expression.append("'");
        }
        if (view.collectionId() != null) {
            expression.append(" and $res/wmns:View/wmns:collectionID/string() eq '");
            expression.append(view.collectionId());
            expression.append("'");
        }
        if (view.type() != null) {
            expression.append(" and $res/wmns:View/wmns:type/string() eq '");
            expression.append(view.type());
            expression.append("'");
        }
        for (ViewProperty property : view.properties().values()) {
            expression.append(" and $res/wmns:View/wmns:property[./wmns:name/string() eq '");
            expression.append(property.getName());
            expression.append("' and ./wmns:value/string() eq '");
            expression.append(property.getValue());
            expression.append("']");
        }
        expression.append(" return $outer");
        logger.trace((Object)("expression: " + expression.toString()));
        return expression.toString();
    }

    static String newTypedQuery(String collectionId) {
        StringBuilder expression = new StringBuilder();
        expression.append(PROVIDER_NS);
        expression.append(VIEWMANAGER_NS);
        expression.append("for $outer in collection(\"/db/Properties\")//Document, $res in  $outer/Data where $res/gc:ServiceClass/string() eq 'ContentManagement' and $res/gc:ServiceName/string() eq 'ViewManager' and $res/wmns:View/wmns:collectionID/string() eq '");
        expression.append(collectionId);
        expression.append("' return $outer");
        return expression.toString();
    }

    static String viewQuery() {
        StringBuilder expression = new StringBuilder();
        expression.append(PROVIDER_NS);
        expression.append(VIEWMANAGER_NS);
        expression.append("for $outer in collection(\"/db/Properties\")//Document, $res in  $outer/Data where $res/gc:ServiceClass/string() eq 'ContentManagement' and count($res//wmns:View)>0 and $res/gc:ServiceName/string() eq 'ViewManager' ");
        expression.append("return $outer");
        return expression.toString();
    }

    public static <E extends GCubeElement, P extends Property, V extends CollectionView<E, P>> List<V> findLike(V view) throws ManagerCall.DiscoveryException, GCUBEException, Exception {
        WSResourceQuery query = (WSResourceQuery)Views.client().getQuery(WSResourceQuery.class);
        query.setExpression(Views.newQuery(view));
        List results = null;
        try {
            results = Views.client().execute((ISQuery)query, view.scope());
        }
        catch (ISException e) {
            throw new ManagerCall.DiscoveryException();
        }
        logger.trace((Object)("found " + results.size() + " results"));
        ArrayList<CollectionView> views = new ArrayList<CollectionView>();
        for (RPDocument r : results) {
            try {
                List nodes = r.evaluate("//View");
                if (nodes.size() == 0) {
                    throw new Exception("the View tag has been not found in the RPDocument");
                }
                View untyped = Views.unmarshalView((String)nodes.get(0));
                QName type = untyped.getType();
                logger.trace((Object)("View Type: " + type));
                untyped.setEndpointReference(r.getEndpoint());
                if (type.equals(view.type())) {
                    try {
                        CollectionView tview = view.securityManager() == null ? (CollectionView)view.getClass().getConstructor(View.class, GCUBEScope.class).newInstance(untyped, view.scope()) : (CollectionView)view.getClass().getConstructor(View.class, GCUBEScope.class, GCUBESecurityManager.class).newInstance(untyped, view.scope(), view.securityManager());
                        views.add(tview);
                    }
                    catch (InvocationTargetException e) {
                        logger.error((Object)("could not parse " + untyped + " as a " + view.getClass().getSimpleName()), e.getCause());
                    }
                    catch (Exception e) {
                        logger.error((Object)("could not parse " + untyped + " as a " + view.getClass().getSimpleName()), (Throwable)e);
                    }
                    continue;
                }
                logger.trace((Object)("skipping type " + type));
            }
            catch (Exception e) {
                logger.error((Object)("Error converting the view in WSResource " + r), (Throwable)e);
            }
        }
        logger.trace((Object)("returning " + views.size() + " views"));
        return views;
    }

    public static List<? extends CollectionView<?, ?>> find(String collectionId) throws ISException, Exception {
        return Views.find(collectionId, GCUBEScopeManager.DEFAULT.getScope(), null);
    }

    public static List<? extends CollectionView<?, ?>> find(String collectionId, GCUBEScope s) throws ISException, Exception {
        return Views.find(collectionId, s, null);
    }

    public static List<? extends CollectionView<?, ?>> find(String collectionId, GCUBESecurityManager m) throws ISException, Exception {
        return Views.find(collectionId, GCUBEScopeManager.DEFAULT.getScope(), m);
    }

    public static List<? extends CollectionView<?, ?>> find(String collectionId, GCUBEScope s, GCUBESecurityManager m) throws ISException, Exception {
        WSResourceQuery query = (WSResourceQuery)Views.client().getQuery(WSResourceQuery.class);
        query.setExpression(Views.newTypedQuery(collectionId));
        List results = Views.client().execute((ISQuery)query, s);
        logger.trace((Object)("found " + results.size() + " results"));
        return Views.convert(results, s, m);
    }

    public static List<? extends CollectionView<?, ?>> listViews() throws Exception {
        return Views.listViews(GCUBEScopeManager.DEFAULT.getScope(), null);
    }

    public static List<? extends CollectionView<?, ?>> listViews(GCUBEScope scope) throws Exception {
        return Views.listViews(scope, null);
    }

    public static List<? extends CollectionView<?, ?>> listViews(GCUBESecurityManager securityManager) throws Exception {
        return Views.listViews(GCUBEScopeManager.DEFAULT.getScope(), securityManager);
    }

    public static List<? extends CollectionView<?, ?>> listViews(GCUBEScope scope, GCUBESecurityManager securityManager) throws Exception {
        WSResourceQuery query = (WSResourceQuery)Views.client().getQuery(WSResourceQuery.class);
        query.setExpression(Views.viewQuery());
        List results = Views.client().execute((ISQuery)query, scope);
        return Views.convert(results, scope, securityManager);
    }

    public static List<? extends CollectionView<?, ?>> convert(List<RPDocument> results, GCUBEScope s, GCUBESecurityManager m) throws JAXBException {
        ArrayList views = new ArrayList();
        for (RPDocument r : results) {
            View untyped;
            try {
                List nodes = r.evaluate("//View");
                if (nodes.size() == 0) {
                    throw new Exception("the View tag has been not found in the RPDocument");
                }
                untyped = Views.unmarshalView((String)nodes.get(0));
            }
            catch (Exception e) {
                logger.warn((Object)("error converting the view " + r), (Throwable)e);
                continue;
            }
            untyped.setEndpointReference(r.getEndpoint());
            Class<CollectionView<?, ?>> clazz = viewTypes.get(untyped.getType());
            if (clazz == null) {
                logger.warn((Object)("could not bind view \n" + r.toString() + "\n as its type " + untyped.getType() + " is unknown"));
                continue;
            }
            try {
                CollectionView<?, ?> tview = m == null ? clazz.getConstructor(View.class, GCUBEScope.class).newInstance(untyped, s) : clazz.getConstructor(View.class, GCUBEScope.class, GCUBESecurityManager.class).newInstance(untyped, s, m);
                views.add(tview);
            }
            catch (Exception e) {
                logger.error((Object)("could not bind view \n" + r.toString() + "\n even if its type " + untyped.getType() + " is known"));
            }
        }
        return views;
    }

    static View unmarshalView(String view) throws JAXBException {
        return (View)context.createUnmarshaller().unmarshal((Reader)new StringReader(view));
    }

    static void marshalView(View view, Result r) throws JAXBException {
        context.createMarshaller().marshal((Object)view, r);
    }

    static {
        viewTypes = new HashMap();
        Views.registerType(GenericView.TYPE, GenericView.class);
        Views.registerType(MetadataView.TYPE, MetadataView.class);
        Views.registerType(AnnotationView.TYPE, AnnotationView.class);
        try {
            context = JAXBContext.newInstance((Class[])new Class[]{View.class});
        }
        catch (Exception e) {
            throw new RuntimeException("could not initialise JAXB context", e);
        }
    }
}

