/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.nc2.iosp.grib.tables.GribTemplate;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.FileManager;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

public class GribWmoTemplatesPanel
extends JPanel {
    private PreferencesExt prefs;
    private BeanTableSorted codeTable;
    private BeanTableSorted entryTable;
    private JSplitPane split;
    private JSplitPane split2;
    private TextHistoryPane compareTA;
    private IndependentWindow infoWindow;
    private FileManager fileChooser;

    public GribWmoTemplatesPanel(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        this.codeTable = new BeanTableSorted(CodeBean.class, (PreferencesExt)prefs.node("CodeBean"), false);
        this.codeTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CodeBean csb = (CodeBean)GribWmoTemplatesPanel.this.codeTable.getSelectedBean();
                GribWmoTemplatesPanel.this.setEntries(csb.code);
            }
        });
        this.entryTable = new BeanTableSorted(EntryBean.class, (PreferencesExt)prefs.node("EntryBean"), false);
        this.entryTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                EntryBean csb = (EntryBean)GribWmoTemplatesPanel.this.entryTable.getSelectedBean();
            }
        });
        this.compareTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.compareTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 800, 600)));
        this.split = new JSplitPane(0, false, this.codeTable, this.entryTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
        try {
            List<GribTemplate> codes = GribTemplate.getWmoStandard();
            ArrayList<CodeBean> dds = new ArrayList<CodeBean>(codes.size());
            for (GribTemplate code : codes) {
                dds.add(new CodeBean(code));
            }
            this.codeTable.setBeans(dds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void save() {
        this.codeTable.saveState(false);
        this.entryTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
        if (this.fileChooser != null) {
            this.fileChooser.save();
        }
    }

    public void setEntries(GribTemplate template) {
        ArrayList<EntryBean> beans = new ArrayList<EntryBean>(template.flds.size());
        for (GribTemplate.Field d : template.flds) {
            beans.add(new EntryBean(d));
        }
        this.entryTable.setBeans(beans);
    }

    public class EntryBean {
        GribTemplate.Field te;

        public EntryBean() {
        }

        public EntryBean(GribTemplate.Field te) {
            this.te = te;
        }

        public String getOctet() {
            return this.te.octet;
        }

        public String getContent() {
            return this.te.content;
        }

        public int getNbytes() {
            return this.te.nbytes;
        }

        public int getStart() {
            return this.te.start;
        }
    }

    public class CodeBean {
        GribTemplate code;

        public CodeBean() {
        }

        public CodeBean(GribTemplate code) {
            this.code = code;
        }

        public String getName() {
            return this.code.name;
        }

        public String getDescription() {
            return this.code.desc;
        }

        public int getM1() {
            return this.code.m1;
        }

        public int getM2() {
            return this.code.m2;
        }
    }
}

