/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.smsplugin.delegates;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis.encoding.Base64;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.importer.model.CreateInfoObjectCommand;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.importer.model.CreateReferenceCommand;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.importer.model.DeleteInfoObjectCommand;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.importer.model.SMSCommand;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.importer.model.UpdateInfoObjectCommand;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Edge;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.GDoc;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.InnerNode;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Leaf;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Node;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Nodes;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.PropertyTypes;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.CreateInfoObjectReferencesProperties;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.CreatePropertyDescription;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.CreateReferenceDescription;

public class GDocConversionUtil {
    protected static final GCUBELog logger = new GCUBELog(GDocConversionUtil.class);
    public static final String DEFAULT_DOCUMENT_NAME = "unknown";

    public static CreateInfoObjectCommand calculateGDocCreation(String collectionId, GDoc doc) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Starting calculating the GDoc CreateInfoObjectCommand");
        }
        CreateInfoObjectCommand createInfoObjectParams = GDocConversionUtil.calculateCreation("contentmanagement:document", (InnerNode)doc);
        CreateReferenceDescription ref = new CreateReferenceDescription();
        ref.setNewObjectSource(true);
        ref.setOtherObjectID(collectionId);
        ref.setRole("contentmanagement:is-member-of");
        ref.setSecondaryRole(null);
        ref.setPropagationRule("delete-source-if-single-apperance");
        ref.setPosition(Integer.valueOf(-1));
        CreateReferenceDescription[] initialRelationShips = new CreateReferenceDescription[]{ref};
        createInfoObjectParams.getParameters().setReferences(initialRelationShips);
        return createInfoObjectParams;
    }

    protected static CreateInfoObjectCommand calculateCreation(String documentType, InnerNode node) {
        logger.trace((Object)"starting processing single node");
        LinkedList<CreateReferenceCommand> references = new LinkedList<CreateReferenceCommand>();
        LinkedList<CreatePropertyDescription> properties = new LinkedList<CreatePropertyDescription>();
        String contentUrl = null;
        String content = null;
        String documentName = GDocConversionUtil.getDocumentName(node);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("document name: " + documentName));
            logger.trace((Object)"processing node edges:");
        }
        LinkedList<InnerNode> propertyNodes = new LinkedList<InnerNode>();
        for (Edge edge : node.edges()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Edge: " + edge));
            }
            if (InnerNode.class.isInstance(edge.target())) {
                InnerNode child = (InnerNode)edge.target();
                if (edge.label().toString().equals("property")) {
                    logger.trace((Object)"processing property node");
                    propertyNodes.add(child);
                } else {
                    logger.trace((Object)"processing internal node");
                    String childDocumentType = GDocConversionUtil.getDocumentType(edge.label().toString());
                    CreateInfoObjectCommand targetCreateInfoObjectCommand = GDocConversionUtil.calculateCreation(childDocumentType, child);
                    int position = GDocConversionUtil.calculateReferencePosition(edge.label(), child);
                    CreateReferenceCommand createReferenceCommand = GDocConversionUtil.buildCreateReference(edge.label().toString(), position, targetCreateInfoObjectCommand);
                    references.add(createReferenceCommand);
                }
            }
            if (!Leaf.class.isInstance(edge.target())) continue;
            if (edge.label().toString().equals("bytestream")) {
                Leaf leaf = (Leaf)edge.target();
                content = leaf.value();
                continue;
            }
            CreatePropertyDescription createPropertyDescription = GDocConversionUtil.buildCreatePropertyDescription(edge);
            properties.add(createPropertyDescription);
        }
        properties.addAll(GDocConversionUtil.buildCreateProperties(propertyNodes));
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Created " + references.size() + " references and " + properties.size() + " properties."));
        }
        CreateInfoObjectReferencesProperties createParameters = new CreateInfoObjectReferencesProperties();
        createParameters.setName(documentName);
        createParameters.setType(documentType);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("contentUrl " + contentUrl + " content " + content));
        }
        if (contentUrl != null) {
            createParameters.setFileLocation(contentUrl);
        }
        if (content != null) {
            createParameters.setRawContent(Base64.decode(content));
        }
        createParameters.setProperties(properties.toArray(new CreatePropertyDescription[properties.size()]));
        return new CreateInfoObjectCommand(createParameters, references);
    }

    protected static List<CreatePropertyDescription> buildCreateProperties(List<InnerNode> propertiesNode) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("processing properties node: " + propertiesNode));
        }
        LinkedList<CreatePropertyDescription> properties = new LinkedList<CreatePropertyDescription>();
        for (InnerNode propertyNode : propertiesNode) {
            properties.add(GDocConversionUtil.buildCreateProperty(propertyNode));
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("found " + properties.size() + " properties"));
        }
        return properties;
    }

    protected static CreatePropertyDescription buildCreateProperty(InnerNode propertyNode) {
        String propertyName = GDocConversionUtil.getNodeValue(propertyNode, "id");
        String propertyType = GDocConversionUtil.getNodeValue(propertyNode, "type");
        String propertyValue = GDocConversionUtil.getNodeValue(propertyNode, "value");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("CreatePropertyDescription name: " + propertyName + " type: " + propertyType + " value: " + propertyValue));
        }
        return new CreatePropertyDescription(propertyName, propertyType, propertyValue);
    }

    protected static String getNodeValue(InnerNode propertyNode, String label) {
        Edge e;
        if (propertyNode.hasEdge(label) && (e = propertyNode.edge(label)).target() instanceof Leaf) {
            return ((Leaf)e.target()).value();
        }
        return null;
    }

    protected static int calculateReferencePosition(QName label, InnerNode target) {
        int position = -1;
        if (label.toString().equals("isPartOf") && target.hasEdge("order")) {
            Edge orderEdge = target.edge("order");
            String orderValue = ((Leaf)orderEdge.target()).value();
            position = Integer.parseInt(orderValue);
        }
        return position;
    }

    protected static CreateReferenceCommand buildCreateReference(String edgeLabel, int position, CreateInfoObjectCommand targetInfoObjectCreationCommand) {
        String role = GDocConversionUtil.getPrimaryRole(edgeLabel);
        String secondaryRole = GDocConversionUtil.getSecondaryRole(edgeLabel);
        CreateReferenceDescription createReferenceDescription = new CreateReferenceDescription();
        createReferenceDescription.setPosition(Integer.valueOf(position));
        createReferenceDescription.setPropagationRule("delete-target-if-single-apperance");
        createReferenceDescription.setRole(role);
        createReferenceDescription.setSecondaryRole(secondaryRole);
        return new CreateReferenceCommand(createReferenceDescription, targetInfoObjectCreationCommand);
    }

    protected static String getPrimaryRole(String label) {
        String role = label;
        if (label.equals("isPartOf")) {
            role = "contentmanagement:has-part";
        }
        if (label.equals("hasAlternative")) {
            role = "contentmanagement:is-represented-by";
        }
        if (label.equals("isDescribedBy")) {
            role = "contentmanagement:is-described-by";
        }
        if (label.equals("isAnnotatedBy")) {
            role = "contentmanagement:is-described-by";
        }
        return role;
    }

    protected static String getSecondaryRole(String label) {
        String secondaryRole = null;
        if (label.equals("isDescribedBy")) {
            secondaryRole = "is-described-by";
        }
        if (label.equals("isAnnotatedBy")) {
            secondaryRole = "contentmanagement:is-annotated-by";
        }
        return secondaryRole;
    }

    protected static String getDocumentType(String label) {
        if (label.equals("isPartOf")) {
            return "contentmanagement:document";
        }
        if (label.equals("hasAlternative")) {
            return "contentmanagement:document";
        }
        if (label.equals("isDescribedBy")) {
            return "contentmanagement:metadata";
        }
        if (label.equals("isAnnotatedBy")) {
            return "contentmanagement:annotation";
        }
        return label;
    }

    protected static String getDocumentType(PropertyTypes.DocumentProperty label) {
        return GDocConversionUtil.getDocumentType(label.name().toString());
    }

    protected static String getDocumentName(InnerNode node) {
        logger.trace((Object)("getDocumentName node: " + node));
        if (node.hasEdge("name")) {
            Edge e = node.edge("name");
            logger.trace((Object)("found edge name " + e));
            if (e.target() instanceof Leaf) {
                String name = ((Leaf)e.target()).value();
                logger.trace((Object)("returning name: " + name));
                return name;
            }
        }
        logger.trace((Object)"no edge name found");
        if (node.id() != null) {
            logger.trace((Object)("returning the node id " + node.id()));
            return node.id();
        }
        logger.trace((Object)"returning default name unknown");
        return DEFAULT_DOCUMENT_NAME;
    }

    protected static CreatePropertyDescription buildCreatePropertyDescription(Edge edge) {
        Date date;
        String edgeLabel;
        Leaf leaf = (Leaf)edge.target();
        String propertyName = edgeLabel = edge.label().toString();
        String propertyType = "xsd:string";
        String propertyValue = leaf.value();
        if ("name".equals(edgeLabel)) {
            propertyName = "contentmanagement:ObjectName";
            propertyType = "xsd:string";
        }
        if ("creationTime".equals(edgeLabel)) {
            propertyName = "contentmanagement:ObjectCreatedMillis";
            propertyType = "contentmanagement:TimeInMilliseconds";
            if (propertyValue != null) {
                date = Nodes.toDate((String)propertyValue);
                propertyValue = String.valueOf(date.getTime());
            }
        }
        if ("lastUpdateTime".equals(edgeLabel)) {
            propertyName = "contentmanagement:ObjectLastModificationMillis";
            propertyType = "contentmanagement:TimeInMilliseconds";
            if (propertyValue != null) {
                date = Nodes.toDate((String)propertyValue);
                propertyValue = String.valueOf(date.getTime());
            }
        }
        if ("length".equals(edgeLabel)) {
            propertyName = "contentmanagement:LengthOfRawContent";
            propertyType = "contentmanagement:LengthInBytes";
        }
        if ("mimeType".equals(edgeLabel)) {
            propertyName = "contentmanagement:MimeType";
            propertyType = "MIME Media-Type";
        }
        if ("schemaURI".equals(edgeLabel)) {
            propertyName = "contentmanagement:metadata_schema";
            propertyType = "xsd:string";
        }
        if ("language".equals(edgeLabel)) {
            propertyName = "contentmanagement:metadata_language";
            propertyType = "xsd:string";
        }
        if ("schemaName".equals(edgeLabel)) {
            propertyName = "contentmanagement:metadata_name";
            propertyType = "xsd:string";
        }
        if ("type".equals(edgeLabel)) {
            propertyName = "contentmanagement:type";
            propertyType = "xsd:string";
        }
        if ("previous".equals(edgeLabel)) {
            propertyName = "contentmanagement:annotation_previous";
            propertyType = "xsd:string";
        }
        if ("url".equals(edgeLabel)) {
            propertyName = "bytestream_uri";
            propertyType = "xsd:string";
        }
        return new CreatePropertyDescription(propertyName, propertyType, propertyValue);
    }

    public static List<SMSCommand> buildUpdateCommands(InnerNode node) {
        logger.trace((Object)("buildUpdateCommands node: " + node));
        LinkedList<SMSCommand> smsCommands = new LinkedList<SMSCommand>();
        Node.State status = node.state();
        logger.trace((Object)("status: " + status));
        if (status == null) {
            throw new IllegalArgumentException("The node have a null state. Please use the delta document for the update operation.");
        }
        switch (status) {
            case NEW: {
                if (!node.getClass().isInstance(GDoc.class)) break;
                throw new IllegalArgumentException("A root node can't be set as NEW on update operation");
            }
            case MODIFIED: {
                smsCommands.addAll(GDocConversionUtil.buildNodeUpdate(node));
                break;
            }
            case DELETED: {
                smsCommands.add(new DeleteInfoObjectCommand(node.id()));
            }
        }
        logger.trace((Object)("produced " + smsCommands.size() + " commands"));
        return smsCommands;
    }

    public static List<SMSCommand> buildNodeUpdate(InnerNode node) {
        logger.trace((Object)("buildNodeUpdate node: " + node));
        LinkedList<SMSCommand> smsCommands = new LinkedList<SMSCommand>();
        LinkedList<String> propertiesToDelete = new LinkedList<String>();
        LinkedList<CreatePropertyDescription> propertiesToUpdateAdd = new LinkedList<CreatePropertyDescription>();
        String newContentUrl = null;
        String content = null;
        LinkedList<InnerNode> propertyNodes = new LinkedList<InnerNode>();
        logger.trace((Object)"starting processing edges");
        for (Edge edge : node.edges()) {
            logger.trace((Object)("Edge: " + edge));
            if (InnerNode.class.isInstance(edge.target())) {
                InnerNode targetNode = (InnerNode)edge.target();
                if (edge.label().toString().equals("property")) {
                    logger.trace((Object)"processing property node");
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("processing properties node: " + targetNode));
                    }
                    propertyNodes.add(targetNode);
                } else if (targetNode.state() == Node.State.NEW) {
                    String targetDocumentType = GDocConversionUtil.getDocumentType(edge.label().toString());
                    CreateInfoObjectCommand createInfoObjectParams = GDocConversionUtil.calculateCreation(targetDocumentType, targetNode);
                    int position = GDocConversionUtil.calculateReferencePosition(edge.label(), targetNode);
                    CreateReferenceCommand createReferenceParams = GDocConversionUtil.buildCreateReference(edge.label().toString(), position, createInfoObjectParams);
                    createReferenceParams.getCreateReferenceDescription().setOtherObjectID(node.id());
                    createInfoObjectParams.getReferences().add(createReferenceParams);
                    smsCommands.add(createInfoObjectParams);
                } else {
                    smsCommands.addAll(GDocConversionUtil.buildUpdateCommands(targetNode));
                }
            }
            if (!Leaf.class.isInstance(edge.target())) continue;
            Leaf leaf = (Leaf)edge.target();
            Node.State leafStatus = leaf.state();
            logger.trace((Object)("leaf with status " + leafStatus));
            switch (leafStatus) {
                case DELETED: {
                    propertiesToDelete.add(edge.label().toString());
                    break;
                }
                case NEW: 
                case MODIFIED: {
                    if (edge.label().toString().equals("bytestream")) {
                        content = leaf.value();
                        break;
                    }
                    CreatePropertyDescription createPropertyDescription = GDocConversionUtil.buildCreatePropertyDescription(edge);
                    propertiesToUpdateAdd.add(createPropertyDescription);
                }
            }
        }
        for (InnerNode propertyNode : propertyNodes) {
            Node.State propertyStatus = propertyNode.state();
            logger.trace((Object)("property with status " + propertyStatus));
            switch (propertyStatus) {
                case DELETED: {
                    String propertyName = GDocConversionUtil.getNodeValue(propertyNode, "id");
                    propertiesToDelete.add(propertyName);
                    break;
                }
                case NEW: 
                case MODIFIED: {
                    propertiesToUpdateAdd.add(GDocConversionUtil.buildCreateProperty(propertyNode));
                }
            }
        }
        logger.trace((Object)("propertiesToDelete: " + propertiesToDelete.size() + ", propertiesToUpdateAdd: " + propertiesToUpdateAdd.size() + ", newContentUrl: " + newContentUrl));
        if (propertiesToDelete.size() != 0 || propertiesToUpdateAdd.size() != 0 || newContentUrl != null || content != null) {
            UpdateInfoObjectCommand updateCommand = new UpdateInfoObjectCommand(node.id(), propertiesToDelete, propertiesToUpdateAdd, newContentUrl);
            if (content != null) {
                updateCommand.setContent(Base64.decode(content));
            }
            smsCommands.add(updateCommand);
        }
        return smsCommands;
    }
}

