/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.smsplugin.delegates;

import java.util.Arrays;
import java.util.List;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.plugin.delegates.Collection;
import org.gcube.contentmanagement.contentmanager.plugin.delegates.FactoryDelegate;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.SMSCollection;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.exception.CollectionNotFoundException;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.util.SMSInterface;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.util.SMSInterfaceImpl;
import org.gcube.contentmanagement.contentmanager.smsplugin.types.SMSCreateParameters;
import org.gcube.contentmanagement.contentmanager.smsplugin.types.SMSWrapCollection;
import org.gcube.contentmanagement.contentmanager.smsplugin.util.ConversionUtil;
import org.w3c.dom.Element;

public class SMSFactory
extends FactoryDelegate {
    protected GCUBELog logger = new GCUBELog(SMSFactory.class);

    public List<? extends Collection> create(Element parameters) throws Exception {
        this.logger.info((Object)"requested create");
        SMSCreateParameters params = ConversionUtil.fromElement(parameters, SMSCreateParameters.class);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("create type: " + params.getClass().getName()));
        }
        if (params instanceof SMSWrapCollection) {
            this.logger.trace((Object)"SMSWrapCollection");
            SMSWrapCollection wrapCollection = (SMSWrapCollection)params;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Wrap parameters: " + wrapCollection));
            }
            SMSCollection collection = this.initializeWrap(wrapCollection);
            this.logger.trace((Object)("create complete, returning " + (Object)((Object)collection)));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Wrapping complete, returning the collection: " + (Object)((Object)collection)));
            }
            return Arrays.asList(collection);
        }
        this.logger.error((Object)"Uknown parameters");
        throw new IllegalArgumentException("Unknow parameters");
    }

    protected SMSCollection initializeWrap(SMSWrapCollection wrapCollection) throws Exception {
        String collectionId = wrapCollection.getCollectionID();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("requested wrapping of collection ID: " + collectionId));
        }
        SMSInterface smsInterface = SMSInterfaceImpl.getInstance();
        boolean exists = smsInterface.existsInfoObject(collectionId);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Collection IO exists? " + exists));
        }
        if (!exists) {
            this.logger.error((Object)("The collection IO for id " + collectionId + " don't exists."));
            new CollectionNotFoundException("The collection with OID: " + collectionId + " don't exists");
        }
        SMSCollection collection = new SMSCollection(collectionId, wrapCollection);
        return collection;
    }
}

