/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.smsplugin.delegates;

import java.util.Arrays;
import java.util.List;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.plugin.delegates.WriteDelegate;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.GDocConversionUtil;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.SMSCollection;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.exception.SMSServiceErrorException;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.importer.model.CreateInfoObjectCommand;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.importer.model.CreateReferenceCommand;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.importer.model.DeleteInfoObjectCommand;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.importer.model.SMSCommand;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.importer.model.UpdateInfoObjectCommand;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.importer.model.WriteUtil;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.util.SMSInterface;
import org.gcube.contentmanagement.contentmanager.smsplugin.util.ModelPrintUtil;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.GDoc;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.InnerNode;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.CreateInfoObjectReferencesProperties;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.CreatePropertyDescription;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.CreateReferenceDescription;

public class WriteManager
extends WriteDelegate {
    private static final long serialVersionUID = -2055308588426698063L;
    protected static final GCUBELog logger = new GCUBELog(WriteManager.class);

    protected SMSInterface getSmsInterface() {
        return ((SMSCollection)this.getCollection()).getSmsInterface();
    }

    protected void updateDynamicProperties() {
        try {
            ((SMSCollection)this.getCollection()).updateDynamicProperties();
        }
        catch (Exception e) {
            logger.warn((Object)"An error occured updating dynamic properties", (Throwable)e);
        }
    }

    public String add(GDoc doc) throws Exception {
        logger.debug((Object)"add");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Document to add:");
            ModelPrintUtil.printAsTree(doc, logger);
        }
        String collectionId = this.getCollection().getID();
        CreateInfoObjectCommand createInfoObjectParams = GDocConversionUtil.calculateGDocCreation(collectionId, doc);
        String newId = this.write(createInfoObjectParams);
        this.updateDynamicProperties();
        logger.trace((Object)"add complete");
        return newId;
    }

    protected String write(CreateInfoObjectCommand createInfoObjectParams) throws SMSServiceErrorException {
        for (CreateReferenceCommand reference : createInfoObjectParams.getReferences()) {
            if (createInfoObjectParams.equals(reference.getTargetCreationCommand())) continue;
            String targetId = this.write(reference.getTargetCreationCommand());
            reference.setReferenceTargetOid(targetId);
        }
        CreateInfoObjectReferencesProperties createParam = createInfoObjectParams.getParameters();
        List<CreateReferenceDescription> references = createInfoObjectParams.getCreateReferenceDescriptions();
        if (createParam.getReferences() != null) {
            references.addAll(Arrays.asList(createParam.getReferences()));
        }
        createParam.setReferences(references.toArray(new CreateReferenceDescription[references.size()]));
        SMSInterface smsInterface = this.getSmsInterface();
        try {
            return smsInterface.storeInformationObject(createParam);
        }
        catch (Exception e) {
            logger.error((Object)"Error storing the new document", (Throwable)e);
            throw new SMSServiceErrorException("Error storing the new document", e);
        }
    }

    public void update(GDoc doc) throws Exception {
        logger.debug((Object)"update");
        if (logger.isTraceEnabled()) {
            ModelPrintUtil.printAsTree(doc, logger);
        }
        List<SMSCommand> commands = GDocConversionUtil.buildUpdateCommands((InnerNode)doc);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"produced commands:");
            for (SMSCommand command : commands) {
                logger.trace((Object)command);
            }
        }
        this.execute(commands);
        this.updateDynamicProperties();
        logger.trace((Object)"update complete");
    }

    protected void execute(List<SMSCommand> commands) throws Exception {
        logger.debug((Object)("execute #commands: " + commands.size()));
        for (SMSCommand command : commands) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("executing " + WriteUtil.toString(command)));
            }
            if (command instanceof CreateInfoObjectCommand) {
                try {
                    this.write((CreateInfoObjectCommand)command);
                }
                catch (Exception e) {
                    logger.error((Object)"Error creating the new IO", (Throwable)e);
                    throw new SMSServiceErrorException("Error creating the new IO", e);
                }
            }
            if (command instanceof DeleteInfoObjectCommand) {
                DeleteInfoObjectCommand deleteInfoObjectCommand = (DeleteInfoObjectCommand)command;
                SMSInterface smsInterface = this.getSmsInterface();
                try {
                    smsInterface.deleteInformationObject(deleteInfoObjectCommand.getOid());
                }
                catch (Exception e) {
                    logger.error((Object)("Error deleting IO " + deleteInfoObjectCommand.getOid()), (Throwable)e);
                    throw new SMSServiceErrorException("Error deleting IO " + deleteInfoObjectCommand.getOid(), e);
                }
            }
            if (!(command instanceof UpdateInfoObjectCommand)) continue;
            try {
                this.update((UpdateInfoObjectCommand)command);
            }
            catch (Exception e) {
                logger.error((Object)"Error updating the IO", (Throwable)e);
                throw new SMSServiceErrorException("Error creating the new IO", e);
            }
        }
    }

    protected void update(UpdateInfoObjectCommand command) throws Exception {
        SMSInterface smsInterface = this.getSmsInterface();
        for (String propertyToDelete : command.getPropertiesToDelete()) {
            try {
                smsInterface.deleteInformationObjectProperty(command.getOid(), propertyToDelete);
            }
            catch (Exception e) {
                logger.error((Object)("Error unsetting the property " + propertyToDelete), (Throwable)e);
                throw new SMSServiceErrorException("Error unsetting the property " + propertyToDelete, e);
            }
        }
        for (CreatePropertyDescription propertyDescription : command.getPropertiesToUpdateAdd()) {
            try {
                smsInterface.setInformationObjectProperty(command.getOid(), propertyDescription);
            }
            catch (Exception e) {
                logger.error((Object)"Error setting the property", (Throwable)e);
                throw new SMSServiceErrorException("Error setting the property", e);
            }
        }
        if (command.getNewRawContentUrl() != null) {
            try {
                smsInterface.updateInformationObjectRawContent(command.getOid(), command.getNewRawContentUrl());
            }
            catch (Exception e) {
                logger.error((Object)("Error updating the raw content location: " + command.getNewRawContentUrl()), (Throwable)e);
                throw new SMSServiceErrorException("Error updating the raw content location: " + command.getNewRawContentUrl(), e);
            }
        }
        if (command.isContentUpdated()) {
            try {
                smsInterface.updateInformationObjectRawContent(command.getOid(), command.getContent());
            }
            catch (Exception e) {
                logger.error((Object)("Error updating the raw content: " + command.getContent().length), (Throwable)e);
                throw new SMSServiceErrorException("Error updating the raw content: " + command.getContent().length, e);
            }
        }
    }
}

