/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.smsplugin.delegates.util;

import java.io.StringWriter;
import java.io.Writer;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.DocumentConversionUtil;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.util.NextIterator;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.RemoteIterator;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Predicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Bindings;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.GDoc;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Node;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.InfoObjectTree;

public class CollectionIterator
extends NextIterator<GDoc, InfoObjectTree> {
    protected String collectionId;
    protected Predicate projection;
    protected long deltaTime = System.currentTimeMillis();
    protected long counter = 0L;

    public CollectionIterator(GCUBELog logger, String collectionId, RemoteIterator<InfoObjectTree> inputIterator, Predicate projection) {
        super(logger, inputIterator);
        this.projection = projection;
        this.collectionId = collectionId;
    }

    @Override
    public GDoc generateNext(InfoObjectTree input) {
        StringWriter w;
        GDoc doc;
        this.logger.trace((Object)("converting the document to GDoc " + this.counter));
        ++this.counter;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("delta time " + (System.currentTimeMillis() - this.deltaTime)));
        }
        if (input == null) {
            this.logger.error((Object)"Retrieved InfoObjectTree null, skipping");
            return null;
        }
        long startTime = System.currentTimeMillis();
        try {
            doc = DocumentConversionUtil.convertToGDoc(this.collectionId, input);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error converting the IO", (Throwable)e);
            return null;
        }
        if (this.logger.isTraceEnabled()) {
            try {
                w = new StringWriter();
                Bindings.toXML((GDoc)doc, (Writer)w, (boolean[])new boolean[0]);
                this.logger.trace((Object)("Produced gdoc: " + doc));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.projection != null) {
            this.logger.trace((Object)"filtering.. ");
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("filter: " + this.projection.toString()));
            }
            this.logger.trace((Object)"pruning.. ");
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("projection: " + this.projection.toString()));
            }
            try {
                this.projection.prune((Node)doc);
            }
            catch (Exception e) {
                this.logger.error((Object)"error pruning the gdoc, skipping it", (Throwable)e);
                return null;
            }
            if (this.logger.isTraceEnabled()) {
                try {
                    w = new StringWriter();
                    Bindings.toXML((GDoc)doc, (Writer)w, (boolean[])new boolean[0]);
                    this.logger.trace((Object)("Pruned gdoc: " + w.toString()));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("document returned in " + (System.currentTimeMillis() - startTime)));
        }
        this.deltaTime = System.currentTimeMillis();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Returning " + doc));
        }
        return doc;
    }
}

