/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.smsplugin.delegates.util;

import java.util.TimerTask;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.SMSCollection;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.GCUBEUnrecoverableObjectNotFoundFault;

public class DynamicPropertyUpdateTask
extends TimerTask {
    protected GCUBELog logger = new GCUBELog(DynamicPropertyUpdateTask.class);
    protected SMSCollection collection;

    public DynamicPropertyUpdateTask(SMSCollection collection) {
        this.collection = collection;
    }

    @Override
    public void run() {
        try {
            this.logger.trace((Object)("Updating dynamic properties for collection " + this.collection.getID()));
            this.collection.updateDynamicProperties();
            this.logger.trace((Object)("Dynamic properties for collection " + this.collection.getID() + " updated."));
        }
        catch (GCUBEUnrecoverableObjectNotFoundFault e) {
            this.logger.error((Object)(this.collection.getID() + " no longer exists, notifying removal and stopping update thread for it"));
            this.collection.notifyDeletion();
            this.cancel();
        }
        catch (Exception e) {
            this.logger.error((Object)("An error occurred updating dynamic properties for collection " + this.collection.getID()), (Throwable)e);
        }
    }
}

