/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.transport.plugin;

import com.mongodb.MongoException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.gcube.contentmanagement.blobstorage.resource.MemoryType;
import org.gcube.contentmanagement.blobstorage.resource.RequestObject;
import org.gcube.contentmanagement.blobstorage.resource.StorageObject;
import org.gcube.contentmanagement.blobstorage.service.operation.Copy;
import org.gcube.contentmanagement.blobstorage.service.operation.CopyDir;
import org.gcube.contentmanagement.blobstorage.service.operation.Download;
import org.gcube.contentmanagement.blobstorage.service.operation.DuplicateFile;
import org.gcube.contentmanagement.blobstorage.service.operation.Link;
import org.gcube.contentmanagement.blobstorage.service.operation.Lock;
import org.gcube.contentmanagement.blobstorage.service.operation.Move;
import org.gcube.contentmanagement.blobstorage.service.operation.MoveDir;
import org.gcube.contentmanagement.blobstorage.service.operation.Unlock;
import org.gcube.contentmanagement.blobstorage.service.operation.Upload;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.contentmanagement.blobstorage.transport.plugin.BucketOperator;
import org.gcube.contentmanagement.blobstorage.transport.plugin.Utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

public class S3PluginManager
extends TransportManager {
    S3Client s3;
    private Logger logger = LoggerFactory.getLogger(S3PluginManager.class);
    private Region region;
    private String token;

    public String getName() {
        return "S3";
    }

    public S3PluginManager() {
        this.logger.info("S3");
    }

    public S3PluginManager(String[] server, String user, String pass, MemoryType memoryType, String[] dbNames, String writeConcern, String readConcern, String token, String region) {
        this.initBackend(server, user, pass, memoryType, dbNames, writeConcern, readConcern, token, region);
    }

    public void initBackend(String[] server, String accessKey, String secretAccessKey, MemoryType memoryType, String[] dbNames, String writeConcern, String readConcern, String token, String region) {
        this.memoryType = memoryType;
        AwsSessionCredentials awsCreds = null;
        awsCreds = !Objects.isNull(this.getToken()) ? AwsSessionCredentials.create((String)accessKey, (String)secretAccessKey, (String)token) : AwsSessionCredentials.create((String)accessKey, (String)secretAccessKey, (String)"");
        this.region = Region.of((String)region);
        this.s3 = (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)awsCreds))).endpointOverride(URI.create(server[0]))).region(this.region)).build();
    }

    public Object get(Download download) throws FileNotFoundException, IOException {
        String bucketName = Utils.convertToS3Format(download.getResource().getRootPath());
        BucketOperator.getInstance(this.s3);
        return BucketOperator.getObject(bucketName, Utils.convertToS3Format(download.getResource().getRemotePath()), download.getLocalPath());
    }

    public String put(Upload upload) throws FileNotFoundException, IOException {
        this.logger.trace("put method invoked ");
        String bucketName = Utils.convertToS3Format(upload.getResource().getRootPath());
        if (!BucketOperator.isBucket(this.s3, bucketName)) {
            BucketOperator.createBucketWaiter(this.s3, bucketName, this.region);
        }
        File file = new File(upload.getResource().getLocalPath());
        BucketOperator.getInstance(this.s3);
        return BucketOperator.putObject(bucketName, Utils.convertToS3Format(upload.getResource().getRemotePath()), file, upload.isReplaceOption());
    }

    public Map<String, StorageObject> getValues(RequestObject resource, String bucket, Class<? extends Object> type) {
        throw new RemoteBackendException("method not implemented yet on s3 plugin");
    }

    public void removeRemoteFile(String bucket, RequestObject resource) throws UnknownHostException {
        BucketOperator.getInstance(this.s3);
        BucketOperator.deleteObject(Utils.convertToS3Format(resource.getRootPath()), Utils.convertToS3Format(resource.getRemotePath()));
    }

    public void removeDir(String remoteDir, RequestObject myFile) throws UnknownHostException {
        throw new RemoteBackendException("method not implemented yet on s3 plugin");
    }

    public long getSize(String key, RequestObject file) {
        this.logger.info("remoteObject identifier " + key);
        try {
            return BucketOperator.getObjectSize(Utils.convertToS3Format(file.getRootPath()), Utils.convertToS3Format(file.getRemotePath()));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RemoteBackendException("Problem during getSize Operation on s3 cloud storage");
        }
    }

    public String lock(Lock lock) throws Exception {
        throw new RemoteBackendException("method not implemented yet on s3 plugin");
    }

    public String unlock(Unlock unlock) throws FileNotFoundException, UnknownHostException, MongoException, Exception {
        throw new RemoteBackendException("method not implemented yet on s3 plugin");
    }

    public long getTTL(String pathServer) throws UnknownHostException {
        throw new RemoteBackendException("method not implemented yet on s3 plugin");
    }

    public long renewTTL(RequestObject resource) throws UnknownHostException, IllegalAccessException {
        throw new RemoteBackendException("method not implemented yet on s3 plugin");
    }

    public String link(Link link) throws UnknownHostException {
        throw new RemoteBackendException("method not implemented yet on s3 plugin");
    }

    public String copy(Copy copy) throws UnknownHostException {
        throw new RemoteBackendException("method not implemented yet on s3 plugin");
    }

    public String move(Move move) throws UnknownHostException {
        throw new RemoteBackendException("method not implemented yet on s3 plugin");
    }

    public List<String> copyDir(CopyDir copy) throws UnknownHostException {
        throw new RemoteBackendException("method not implemented yet on s3 plugin");
    }

    public List<String> moveDir(MoveDir move) throws UnknownHostException {
        throw new RemoteBackendException("method not implemented yet on s3 plugin");
    }

    public String getFileProperty(String remotePath, String property) {
        throw new RemoteBackendException("method not implemented yet on s3 plugin");
    }

    public long getFolderTotalItems(String folderPath) {
        throw new RemoteBackendException("method not implemented yet on s3 plugin");
    }

    public long getFolderTotalVolume(String folderPath) {
        throw new RemoteBackendException("method not implemented yet on s3 plugin");
    }

    public String getUserTotalVolume(String user) {
        throw new RemoteBackendException("method not implemented yet on s3 plugin");
    }

    public String getUserTotalItems(String user) {
        throw new RemoteBackendException("method not implemented yet on s3 plugin");
    }

    public boolean isValidId(String id) {
        throw new RemoteBackendException("method not implemented yet on s3 plugin");
    }

    public String getId(String remoteIdentifier, boolean forceCreation) {
        throw new RemoteBackendException("method not implemented yet on s3 plugin");
    }

    public String getField(String remoteIdentifier, String fieldName) throws UnknownHostException {
        throw new RemoteBackendException("method not implemented yet on s3 plugin");
    }

    public void close() {
        this.s3.close();
    }

    public void forceClose() {
        this.s3.close();
    }

    public void setFileProperty(String remotePath, String propertyField, String propertyValue) {
        throw new RemoteBackendException("method not implemented yet on s3 plugin");
    }

    public String getRemotePath(String bucket) throws UnknownHostException {
        throw new RemoteBackendException("method not implemented yet on s3 plugin");
    }

    public boolean exist(String bucket) {
        throw new RemoteBackendException("method not implemented yet on s3 plugin");
    }

    public String duplicateFile(DuplicateFile duplicate) {
        throw new RemoteBackendException("method not implemented yet on s3 plugin");
    }

    protected String getToken() {
        return this.token;
    }

    protected void setToken(String token) {
        this.token = token;
    }
}

