package org.gcube.contentmanager.storageserver.accounting;

public interface Report {	
	/**
	 * Set generic properties of report
	 * @param resourceType
	 * @param consumerId
	 * @param resourceOwner
	 * @param resourceScope
	 * @return
	 */
	public void init(String consumerId, String resourceScope, String creationTime);
	/**
	 * set start time of the operation
	 * @return
	 */
	public void timeUpdate();
	
	/**
	 * Set end time of operation and other specific properties
	 * @return
	 */
	public void ultimate(String owner, String operation, String size, String filePath, String id, String callerIP, String lastAccess);
	
	/**
	 * send report
	 * @return
	 */
	public void send();

}
