package org.gcube.contentmanager.storageserver.accounting;


import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

import org.gcube.accounting.datamodel.RawUsageRecord;
import org.gcube.accounting.exception.InvalidValueException;
import org.gcube.accounting.messaging.ResourceAccounting;
import org.gcube.accounting.messaging.ResourceAccountingFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

	public class ReportAccountingImpl implements Report {
	final Logger logger = LoggerFactory.getLogger(ReportAccountingImpl.class);
	public RawUsageRecord ur;
	public ResourceAccounting raFactory;

	
	@Override
	public void init(){
		  raFactory = null;
		  try {
			  raFactory = ResourceAccountingFactory.getResourceAccountingInstance();
		  } 
		  catch (IOException e) {
			  e.printStackTrace();
		  }
		  catch (Exception e) {
			  e.printStackTrace();
		  }  
	}
	
	@Override
	public void start(String consumerId, String resourceScope, String creationTime) {
		  logger.info("set accounting properties: consumerId "+consumerId+" scope: "+resourceScope+ " creationTime "+creationTime);
		  if(raFactory==null) init();
		  this.ur = new RawUsageRecord();
		  //	generic properties
		   ur.setResourceType("storage-usage");	
		   if(consumerId!=null)  ur.setConsumerId(consumerId);
		   //   ur.setResourceOwner("paolo.fabriani");
		   if(resourceScope !=null) ur.setResourceScope(resourceScope);
		   //set creation time	   
		   if(creationTime!=null){
			   SimpleDateFormat formatter = new SimpleDateFormat("dd MM yyyy 'at' hh:mm:ss z");
			   Date date=null;
			   try {
				   date = formatter.parse(creationTime);
			   } catch (ParseException e) {
				   logger.error("Error in parsing date: "+creationTime+" exc msg: "+e.getMessage());
			   }
			   ur.setCreateTime(date);
		   }
	}

	@Override
	public void timeUpdate() {
		setStartTime();
	}
	
	@Override
	public void ultimate(String owner, String operation, String size, String filePath, String id, String callerIP, String lastAccess) {
		logger.info("set accounting properties: owner "+owner+" operation: "+operation+" size: "+size+ " remotePath: "+filePath+" id: "+id+"callerIP "+callerIP+" lastAccess"+lastAccess);
		if(ur==null) this.ur = new RawUsageRecord();
	//specific properties
	   if(owner != null) ur.setResourceOwner(owner);
	   if (operation!=null) ur.setResourceSpecificProperty("operationType",operation);
	   if(size!= null) ur.setResourceSpecificProperty("dataVolume", size);
	   if(filePath != null) ur.setResourceSpecificProperty("remotePath", filePath);
	   if(id!= null) ur.setResourceSpecificProperty("id", id);
	   if(callerIP!=null) ur.setResourceSpecificProperty("callerIP", "etics.eng.it");
	   if(lastAccess!=null)ur.setResourceSpecificProperty("lastAccess", lastAccess);
   // set static properties
	   ur.setResourceSpecificProperty("dataType","STORAGE");
	   ur.setResourceSpecificProperty("dataCount", "1");
	}
	@Override
	public void send() {
		logger.info("report sending...");
		if(raFactory!=null)
			raFactory.sendAccountingMessage(ur);
		else
			logger.error("Problem on building accounting record: Factory Object is null ");
	}

	@Deprecated
	private void setIpAddress() {
		String address=null;
		try {
			address=InetAddress.getLocalHost().toString();
		} catch (UnknownHostException e) {
			
		}
		logger.info("caller ip: "+address);
		if (address!=null)	ur.setResourceSpecificProperty("callerIP", address);;
	}
	
	private void setStartTime() {
		//set start time	
			Calendar startTime = new GregorianCalendar();
			Date time=startTime.getTime();
			logger.info("set start time: "+time);
			   try {
				   ur.setStartTime(time);
			   }
			   catch (InvalidValueException e) {
			   	e.printStackTrace();
			   }
	}
	private void setEndTime() {
		// set end time	
		Calendar endTime = new GregorianCalendar();
		Date time=endTime.getTime();
		SimpleDateFormat sdf=new SimpleDateFormat();
		sdf.applyPattern("dd MM yyyy 'at' hh:mm:ss z");
		sdf.format(time);
		logger.info("set end time: "+time);
		try {
			   ur.setEndTime(time);
	    }
	    catch (InvalidValueException e) {
	    	e.printStackTrace();
	    }
	}
}
