package org.gcube.contentmanager.storageserver.data;


import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import com.mongodb.BasicDBObject;
import com.mongodb.Bytes;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.ServerAddress;
import org.bson.types.BSONTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadingMongoOplog extends Thread{
	
	final static Logger logger=LoggerFactory.getLogger(ReadingMongoOplog.class);
	public String DBNAME="remotefs";
	private ServerAddress[] server;
	private Mongo mongoClient;
	private DB local;
	private DBCollection oplog;
	private CubbyHole c;
	private String user;
	private String password;
	private int number;
	
	public ReadingMongoOplog(List<String> srvs, CubbyHole c, int numberT){
		this.c=c;
		this.number=numberT;
		setupServerAddress(srvs);
        initBackend();
	}


    public ReadingMongoOplog(List<String> srvs, String user,
			String password, CubbyHole c, int numberT) {
    	this.c=c;
		this.number=numberT;
		this.user=user;
		this.password=password;
		setupServerAddress(srvs);
        initBackend();
	}

	public void run() {
        DBCursor lastCursor = oplog.find().sort(new BasicDBObject("$natural", -1)).limit(1);
        if (!lastCursor.hasNext()) {
            logger.error("no oplog!");
            return;
        }
        DBObject last = lastCursor.next();
        BSONTimestamp ts = (BSONTimestamp) last.get("ts");
        while (true) {
            logger.debug("starting at ts: " + ts);
            DBCursor cursor = oplog.find(new BasicDBObject("ts", new BasicDBObject("$gt", ts)));
            cursor.addOption(Bytes.QUERYOPTION_TAILABLE);
            cursor.addOption(Bytes.QUERYOPTION_AWAITDATA);
            while (cursor.hasNext()) {
                DBObject x = cursor.next();
                logger.info("oplog current object: "+x);
                ts = (BSONTimestamp) x.get("ts");
                String ns=(String)x.get("ns");
         // check if discard or process the current DB record       
                if((x.get("o2")!=null) || (ns.equalsIgnoreCase(DBNAME+".fs.files"))){
        		    if(x.containsField("o")){
//      	parser.jsonRecordParser(x);
        		    	c.put(x);
        		    	logger.info("Producer #" + this.number + " put: " + x);
        		    }else{
   		        	 	logger.info("operation is not accounted");
	   		        }
	   		    }else{
	   		    	logger.debug("record discarded: \t"+x);
	   		    }
                
            }
            try {
				Thread.sleep(1000);
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
        }
    }

	@SuppressWarnings("deprecation")
	private void initBackend() {
		mongoClient = new Mongo(Arrays.asList(server));//"146.48.123.71"
        local = mongoClient.getDB("local");
        try {
			Thread.sleep(1000);
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		boolean auth =false;
		if(user!=null && password !=null)
			auth=local.authenticate(user.trim(), password.trim().toCharArray());
        if(auth) logger.info("mongo is in authenticate mode");
		else logger.info("mongo is not in authenticate mode");
        oplog = local.getCollection("oplog.rs");
	}

	private void setupServerAddress(List<String> srvs) {
		try {
			if(srvs.size() > 0){
				server=new ServerAddress[srvs.size()];
				int i=0;
				for(String s : srvs){
					server[i]=new ServerAddress(s);
					i++;
				}
			}else{
				logger.error("MongoDB server not Setted. Please set one or more servers");
				throw new RuntimeException("MongoDB server not Setted. Please set one or more servers");
			}
		} catch (UnknownHostException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}



}
 
