/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageserver.store;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoOptions;
import org.gcube.contentmanager.storageserver.store.StorageStatusRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDB {
    private Mongo mongo;
    private DB db;
    private String[] server;
    private String collection;
    private int port;
    private String pwd;
    private String user;
    private DBCollection ssCollection;
    Logger logger = LoggerFactory.getLogger(MongoDB.class);
    private static final String ACCOUNTING_DB = "accounting";
    private static final String DEFAULT_COLLECTION = "storageStatus";

    public MongoDB(String[] server, int port, String user, String password, String collectionName) {
        this.server = server;
        this.port = port;
        this.pwd = password;
        this.user = user;
        this.collection = collectionName;
        this.db = this.getDB();
        this.ssCollection = this.db.getCollection(collectionName);
    }

    public MongoDB(String[] server, String user, String password, String collectionName) {
        this.server = server;
        this.pwd = password;
        this.user = user;
        this.collection = collectionName;
        this.db = this.getDB();
        this.ssCollection = this.db.getCollection(collectionName);
    }

    public MongoDB(String[] server, String user, String password) {
        this.server = server;
        this.pwd = password;
        this.user = user;
        this.collection = DEFAULT_COLLECTION;
    }

    public void put(String consumer, long volume, int count) {
        BasicDBObject doc = new BasicDBObject("consumer", consumer).append("volume", volume).append("count", count);
        this.getCollection().insert(doc);
        this.close();
    }

    public StorageStatusRecord update(String consumer, long volume, int count, String operation) {
        StorageStatusRecord ssr = this.get(consumer);
        if (ssr != null) {
            int currentCount = ssr.getCount();
            count = this.setCount(count, currentCount, operation);
            ssr.setCount(count);
            long currentVolume = ssr.getVolume();
            volume = this.setVolume(volume, currentVolume, operation);
            BasicDBObject query = new BasicDBObject("consumer", consumer);
            DBObject documentBuilder = BasicDBObjectBuilder.start().add("volume", volume).add("count", count).get();
            this.getCollection().update(query, new BasicDBObject("$set", documentBuilder), true, false);
            this.close();
        } else {
            this.put(consumer, volume, count);
        }
        return new StorageStatusRecord(consumer, volume, count);
    }

    public StorageStatusRecord get(String consumer) {
        BasicDBObject query = new BasicDBObject("consumer", consumer);
        DBObject obj = null;
        try (DBCursor cursor = this.getCollection().find(query);){
            if (cursor.hasNext()) {
                obj = cursor.next();
            }
        }
        if (obj != null) {
            String cons = null;
            if (obj.containsField("consumer")) {
                cons = (String)obj.get("consumer");
            } else {
                this.logger.error("incomplete record found. consumer field is missing");
            }
            long vol = 0L;
            if (obj.containsField("volume")) {
                vol = (Long)obj.get("volume");
            } else {
                this.logger.error("incomplete record found. volume field is missing");
            }
            int count = 0;
            if (obj.containsField("count")) {
                count = (Integer)obj.get("count");
            } else {
                this.logger.error("incomplete record found. count field is missing");
            }
            String id = (String)obj.get("id");
            return new StorageStatusRecord(id, cons, vol, count, obj);
        }
        return null;
    }

    public void close() {
        if (this.mongo != null) {
            this.mongo.close();
        }
    }

    private long setVolume(long volume, long currentVolume, String operation) {
        this.logger.info("accounting: operation " + operation + " total Volume " + currentVolume + " current volume " + volume);
        if (operation.equalsIgnoreCase("UPLOAD") || operation.equalsIgnoreCase("COPY")) {
            currentVolume += volume;
        } else if (operation.equalsIgnoreCase("DELETE")) {
            currentVolume -= volume;
        }
        this.logger.info("new current volume " + currentVolume);
        return currentVolume;
    }

    private int setCount(int count, int currentCount, String operation) {
        this.logger.info("accounting: operation " + operation + " total count " + currentCount + " current count" + count);
        if (operation.equalsIgnoreCase("UPLOAD")) {
            currentCount += count;
        } else if (operation.equalsIgnoreCase("DELETE")) {
            currentCount -= count;
        }
        this.logger.info("new count calculated: " + currentCount);
        return currentCount;
    }

    private DB getDB() {
        if (this.db != null) {
            try {
                DB db = this.mongo.getDB(ACCOUNTING_DB);
            }
            catch (Exception e) {
                this.logger.warn("the server now is not a primary ");
                this.db = null;
            }
        }
        if (this.db == null) {
            int i = -1;
            String[] stringArray = this.server;
            int n = this.server.length;
            int n2 = 0;
            while (n2 < n) {
                String srv = stringArray[n2];
                try {
                    boolean auth;
                    ++i;
                    this.ssCollection = null;
                    if (this.mongo != null) {
                        this.mongo.close();
                    }
                    MongoOptions options = new MongoOptions();
                    options.autoConnectRetry = true;
                    options.socketKeepAlive = true;
                    options.maxWaitTime = 240000;
                    options.connectionsPerHost = 35;
                    this.mongo = new Mongo(srv, options);
                    this.logger.debug("Istantiate MongoDB with options: " + this.mongo.getMongoOptions());
                    this.db = this.mongo.getDB(ACCOUNTING_DB);
                    if (this.user == null) {
                        this.user = "";
                    }
                    if (this.pwd == null) {
                        this.pwd = "";
                    }
                    if (auth = this.db.authenticate(this.user, this.pwd.toCharArray())) {
                        this.logger.info("mongo is in authenticate mode");
                    } else {
                        this.logger.info("mongo is not in authenticate mode");
                    }
                    if (this.ssCollection == null) {
                        this.ssCollection = this.db.getCollection(this.collection);
                    }
                    this.ssCollection.findOne();
                    String firstServer = this.server[0];
                    this.server[0] = srv;
                    this.server[i] = firstServer;
                    break;
                }
                catch (Exception e) {
                    this.logger.warn("server " + srv + " is not a primary retry ");
                    ++n2;
                }
            }
        }
        return this.db;
    }

    private DBCollection getCollection() {
        if (this.ssCollection == null) {
            return this.getDB().getCollection(this.collection);
        }
        return this.ssCollection;
    }
}

