/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.security.authn.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.gcube.accounting.security.SecurityManager;

public class HTTPBasicFilter
implements Filter {
    private static Logger logger = Logger.getLogger(HTTPBasicFilter.class);

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (!SecurityManager.isAuthnEnabled()) {
            chain.doFilter(req, res);
            return;
        }
        if (!"basic".equals(SecurityManager.getAuthnType())) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String header = request.getHeader("Authorization");
        if (header != null && header.startsWith("Basic ")) {
            Boolean authenticationState;
            String base64Token = header.substring(6);
            String token = new String(Base64.decodeBase64(base64Token.getBytes()));
            String username = "";
            String password = "";
            int delim = token.indexOf(":");
            if (delim != -1 && (authenticationState = Boolean.valueOf(SecurityManager.authenticate(username = token.substring(0, delim), password = token.substring(delim + 1)))).booleanValue()) {
                logger.debug("authenticated. Going ahead with request");
                req.setAttribute("userId", (Object)username);
                chain.doFilter(req, res);
                return;
            }
        }
        String realm = SecurityManager.getAuthenticationManager().getRealm();
        response.setHeader("WWW-Authenticate", "Basic realm=\"" + realm + "\"");
        response.sendError(401);
    }

    public void init(FilterConfig arg0) throws ServletException {
    }
}

