/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.ut;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import java.net.URI;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.Vector;
import javax.ws.rs.core.UriBuilder;
import org.apache.log4j.Logger;
import org.gcube.accounting.datamodel.AbstractDelegateUsageRecord;
import org.gcube.accounting.datamodel.Consumer;
import org.gcube.accounting.datamodel.RawUsageRecord;
import org.gcube.accounting.datamodel.ResourceScope;
import org.gcube.accounting.datamodel.ResourceType;
import org.gcube.accounting.datamodel.ResourceTypes;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.User;
import org.gcube.accounting.datamodel.reports.Report;
import org.gcube.accounting.datamodel.reports.aggregation.AggregatedResult;
import org.gcube.accounting.datamodel.reports.aggregation.FilterRating;
import org.gcube.accounting.exception.InvalidValueException;
import org.gcube.accounting.security.authn.HTTPBasicAuthentication;
import org.gcube.accounting.ut.UpdateInfo;

public class UsageTrackerRestAPI {
    private static Logger logger = Logger.getLogger(UsageTrackerRestAPI.class);
    private WebResource service;
    private Client client;
    private String uri;
    private static final Random random = new Random();

    public UsageTrackerRestAPI(String uri) {
        DefaultClientConfig config = new DefaultClientConfig();
        this.client = Client.create(config);
        this.uri = uri;
        this.service = this.client.resource(UsageTrackerRestAPI.getBaseURI(this.uri));
    }

    private static URI getBaseURI(String uri) {
        return UriBuilder.fromUri(uri).build(new Object[0]);
    }

    public void insertUsageRecords(Collection<UsageRecord> records) {
        this.service = this.client.resource(this.uri);
        logger.debug("bulk upload of " + records.size() + " usage records...");
        for (UsageRecord ur : records) {
            this.insertUsageRecord(ur);
        }
        logger.debug("bulk upload completed");
    }

    public void insertUsageRecord(UsageRecord ur) {
        this.service = this.client.resource(this.uri);
        logger.debug("uploading usage record " + ur.getId() + "...");
        ((WebResource.Builder)this.service.path("usagerecords").accept("text/plain").type("application/xml")).post(ur);
        logger.debug("uploaded");
    }

    public void insertUsageRecord(AbstractDelegateUsageRecord ur) {
        this.insertUsageRecord(ur.getDelegateUR());
    }

    public void insertUsageRecord(RawUsageRecord ur) {
        this.service = this.client.resource(this.uri);
        logger.debug("uploading usage record " + ur.getId() + "...");
        ((WebResource.Builder)this.service.path("usagerecords").accept("text/plain").type("application/xml")).post(ur);
        logger.debug("uploaded");
    }

    public Collection<UsageRecord> getUsageRecords(String query) {
        this.service = this.client.resource(this.uri);
        RawUsageRecord[] records = null;
        records = query == null || query.equals("") ? this.service.path("usagerecords").get(RawUsageRecord[].class) : this.service.path("usagerecords").queryParam("query", query).get(RawUsageRecord[].class);
        logger.debug("retrieved " + records.length + " usage records");
        Vector<UsageRecord> out = new Vector<UsageRecord>();
        for (RawUsageRecord r : records) {
            out.add(r);
        }
        return out;
    }

    public Collection<UpdateInfo> getUpdateInfo() {
        logger.debug("querying the Usage Tracker for update information...");
        this.service = this.client.resource(this.uri);
        UpdateInfo[] infos = this.service.path("meta").path("update_info").get(UpdateInfo[].class);
        logger.debug("done");
        Vector<UpdateInfo> out = new Vector<UpdateInfo>();
        for (UpdateInfo info : infos) {
            out.add(info);
        }
        return out;
    }

    public Collection<User> getUsers() {
        logger.debug("retrieving tracked users...");
        this.service = this.client.resource(this.uri);
        User[] users = this.service.path("meta").path("users").get(User[].class);
        logger.debug("retrieved " + users.length + " users");
        Vector<User> out = new Vector<User>();
        for (User user : users) {
            out.add(user);
        }
        return out;
    }

    public Collection<Consumer> getTrackedConsumers() {
        this.service = this.client.resource(this.uri);
        Consumer[] consumers = this.service.path("meta").path("consumers").get(Consumer[].class);
        Vector<Consumer> out = new Vector<Consumer>();
        for (Consumer c : consumers) {
            out.add(c);
        }
        return out;
    }

    public Collection<ResourceType> getTrackedResourceTypes() {
        this.service = this.client.resource(this.uri);
        ResourceType[] resouceTypes = this.service.path("meta").path("resource_types").get(ResourceType[].class);
        Vector<ResourceType> out = new Vector<ResourceType>();
        for (ResourceType c : resouceTypes) {
            out.add(c);
        }
        return out;
    }

    public Collection<ResourceScope> getTrackedResourceScopes() {
        this.service = this.client.resource(this.uri);
        ResourceScope[] resourceScopes = this.service.path("meta").path("resource_scopes").get(ResourceScope[].class);
        Vector<ResourceScope> out = new Vector<ResourceScope>();
        for (ResourceScope c : resourceScopes) {
            out.add(c);
        }
        return out;
    }

    public long getNumberOfRecords(String query) {
        this.service = this.client.resource(this.uri);
        String numberOfRecords = "";
        numberOfRecords = query == null || query.equals("") ? this.service.path("usagerecords").path("records_size").get(String.class) : this.service.path("usagerecords").path("records_size").queryParam("query", query).get(String.class);
        logger.debug(numberOfRecords + " usage records");
        return Long.valueOf(numberOfRecords);
    }

    public void clear() {
        logger.debug("clearing the usage tracker...");
        this.service = this.client.resource(this.uri);
        this.service.path("usagerecords").delete();
        logger.debug("done");
    }

    public void deleteUsageRecord(UsageRecord record) {
        this.service = this.client.resource(this.uri);
        logger.info("deleting usage record " + record.getId() + "...");
        this.service.path("usagerecords/" + record.getId()).delete();
        logger.info("deleted");
    }

    public void setUserToken(String username, String password) {
        this.client.addFilter(new HTTPBasicAuthentication(username, password));
    }

    public void setUserToken(String username, String password, String delegator) {
        this.client.addFilter(new HTTPBasicAuthentication(username, password, delegator));
    }

    private static void generateJobRecords(UsageTrackerRestAPI ut, int n) {
        List<String> resourceScopes = Arrays.asList("/d4science.org", "/d4science.org/vo1", "/d4science.org/vo2", "/d4science.org/vo1/vre1", "/d4science.org/vo1/vre2");
        List<String> dataTypes = Arrays.asList("STORAGE", "DATABASE", "TREE", "GEO");
        List<String> consumerIds = Arrays.asList("luigi.fortunati", "antonio.savini", "ermanno.travaglino", "pasquale.pagano", "andrea.manzi", "fabio.simeoni", "john.gerbesiotis");
        List<String> resourceOwners = Arrays.asList("luigi.fortunati", "antonio.savini", "ermanno.travaglino", "pasquale.pagano", "andrea.manzi", "fabio.simeoni", "john.gerbesiotis");
        List<String> providerIds = Arrays.asList("cloud.eng.it", "cnr.research-infrastructures.eu", "fao.org", "cern.ch");
        List<String> qualifiers = Arrays.asList("data-transformation", "search", "map-reduce");
        List<String> names = Arrays.asList("abc", "acd", "bca", "bac");
        for (int i = 0; i < n; ++i) {
            RawUsageRecord t = new RawUsageRecord();
            t.setResourceType(ResourceTypes.JOB.toString());
            Collections.shuffle(consumerIds);
            t.setConsumerId("test");
            Collections.shuffle(resourceOwners);
            t.setCreatorId(resourceOwners.get(0));
            Collections.shuffle(resourceOwners);
            t.setResourceOwner(resourceOwners.get(0));
            Collections.shuffle(resourceScopes);
            t.setResourceScope("/testing/vo1");
            t.setResourceSpecificProperty("jobId", UUID.randomUUID().toString());
            Collections.shuffle(qualifiers);
            t.setResourceSpecificProperty("jobQualifier", qualifiers.get(0));
            Collections.shuffle(names);
            t.setResourceSpecificProperty("jobName", names.get(0));
            t.setResourceSpecificProperty("jobStatus", "completed");
            t.setResourceSpecificProperty("vmsUsed", String.valueOf(i));
            long start2013 = 0L;
            try {
                start2013 = new SimpleDateFormat("yyyy").parse("2012").getTime();
            }
            catch (ParseException e1) {
                e1.printStackTrace();
            }
            long millisInYear2012 = 1471229928L;
            long millis = Math.round(1.471229928E9 * Math.random());
            Timestamp timeStamp = new Timestamp(start2013 + millis);
            GregorianCalendar startTime = UsageTrackerRestAPI.randomDate();
            GregorianCalendar endTime = UsageTrackerRestAPI.randomDate();
            while (endTime.before(startTime)) {
                startTime = UsageTrackerRestAPI.randomDate();
                endTime = UsageTrackerRestAPI.randomDate();
            }
            try {
                t.setStartTime(startTime.getTime());
                t.setEndTime(endTime.getTime());
                t.setResourceSpecificProperty("jobStart", String.valueOf(startTime.getTimeInMillis()));
                t.setResourceSpecificProperty("jobEnd", String.valueOf(endTime.getTimeInMillis()));
                long wallDuration = endTime.getTimeInMillis() - startTime.getTimeInMillis();
                t.setResourceSpecificProperty("wallDuration", String.valueOf(wallDuration));
            }
            catch (InvalidValueException e) {
                e.printStackTrace();
            }
            t.setCreateTime(UsageTrackerRestAPI.randomDate().getTime());
            ut.insertUsageRecord(t);
        }
    }

    private static void generateTaskRecords(UsageTrackerRestAPI ut, int n) {
        List<String> resourceScopes = Arrays.asList("/d4science.org", "/d4science.org/vo1", "/d4science.org/vo2", "/d4science.org/vo1/vre1", "/d4science.org/vo1/vre2");
        List<String> dataTypes = Arrays.asList("STORAGE", "DATABASE", "TREE", "GEO");
        List<String> consumerIds = Arrays.asList("luigi.fortunati", "antonio.savini", "ermanno.travaglino", "pasquale.pagano", "andrea.manzi", "fabio.simeoni", "john.gerbesiotis");
        List<String> resourceOwners = Arrays.asList("luigi.fortunati", "antonio.savini", "ermanno.travaglino", "pasquale.pagano", "andrea.manzi", "fabio.simeoni", "john.gerbesiotis");
        List<String> refHosts = Arrays.asList("cloud.eng.it", "cnr.research-infrastructures.eu", "fao.org", "cern.ch");
        List<String> refVMs = Arrays.asList("vm1", "vm2", "vm3", "vm4");
        List<String> qualifiers = Arrays.asList("data-transformation", "search", "map-reduce");
        List<String> names = Arrays.asList("abc", "acd", "bca", "bac");
        for (int i = 0; i < n; ++i) {
            RawUsageRecord t = new RawUsageRecord();
            t.setResourceType(ResourceTypes.TASK.toString());
            Collections.shuffle(consumerIds);
            t.setConsumerId("test");
            Collections.shuffle(resourceOwners);
            t.setCreatorId(resourceOwners.get(0));
            Collections.shuffle(resourceOwners);
            t.setResourceOwner(resourceOwners.get(0));
            Collections.shuffle(resourceScopes);
            t.setResourceScope("/testing/vo1");
            t.setResourceSpecificProperty("jobId", UUID.randomUUID().toString());
            Collections.shuffle(refHosts);
            t.setResourceSpecificProperty("refHost", refHosts.get(0));
            t.setResourceSpecificProperty("domain", refHosts.get(0));
            Collections.shuffle(refVMs);
            t.setResourceSpecificProperty("refVM", refVMs.get(0));
            Collections.shuffle(names);
            t.setResourceSpecificProperty("jobName", names.get(0));
            t.setResourceSpecificProperty("usagePhase", "completed");
            t.setResourceSpecificProperty("overallNetworkIn", String.valueOf(new Long(i * 1110)));
            t.setResourceSpecificProperty("overallNetworkOut", String.valueOf(new Long(i * 200)));
            t.setResourceSpecificProperty("cores", String.valueOf(new Integer(i * 8)));
            t.setResourceSpecificProperty("processors", String.valueOf(new Integer(i)));
            long start2013 = 0L;
            try {
                start2013 = new SimpleDateFormat("yyyy").parse("2012").getTime();
            }
            catch (ParseException e1) {
                e1.printStackTrace();
            }
            long millisInYear2012 = 1471229928L;
            long millis = Math.round(1.471229928E9 * Math.random());
            Timestamp timeStamp = new Timestamp(start2013 + millis);
            GregorianCalendar startTime = UsageTrackerRestAPI.randomDate();
            GregorianCalendar endTime = UsageTrackerRestAPI.randomDate();
            while (endTime.before(startTime)) {
                startTime = UsageTrackerRestAPI.randomDate();
                endTime = UsageTrackerRestAPI.randomDate();
            }
            try {
                t.setStartTime(startTime.getTime());
                t.setEndTime(endTime.getTime());
                t.setResourceSpecificProperty("usageStart", String.valueOf(startTime.getTimeInMillis()));
                t.setResourceSpecificProperty("usageEnd", String.valueOf(endTime.getTimeInMillis()));
                long wallDuration = endTime.getTimeInMillis() - startTime.getTimeInMillis();
                t.setResourceSpecificProperty("wallDuration", String.valueOf(wallDuration));
            }
            catch (InvalidValueException e) {
                e.printStackTrace();
            }
            t.setCreateTime(UsageTrackerRestAPI.randomDate().getTime());
            System.out.println(t);
            ut.insertUsageRecord(t);
        }
    }

    private static void generateStorageUsageRecords(UsageTrackerRestAPI ut, int n) {
        List<String> operationTypes = Arrays.asList("GET", "DELETE", "UPDATE", "PUT");
        List<String> resourceScopes = Arrays.asList("/d4science.org", "/d4science.org/vo1", "/d4science.org/vo2", "/d4science.org/vo1/vre1", "/d4science.org/vo1/vre2");
        List<String> dataTypes = Arrays.asList("STORAGE", "DATABASE", "TREE", "GEO");
        List<String> consumerIds = Arrays.asList("luigi.fortunati", "antonio.savini", "ermanno.travaglino", "pasquale.pagano", "andrea.manzi", "fabio.simeoni", "john.gerbesiotis");
        List<String> resourceOwners = Arrays.asList("luigi.fortunati", "antonio.savini", "ermanno.travaglino", "pasquale.pagano", "andrea.manzi", "fabio.simeoni", "john.gerbesiotis");
        List<String> providerIds = Arrays.asList("cloud.eng.it", "cnr.research-infrastructures.eu", "fao.org", "cern.ch");
        List<String> qualifiers = Arrays.asList("application/xml", "application/zip", "image/jpeg", "text/xml");
        List<String> callerIPs = Arrays.asList("etics.eng.it", "statistical-manager.cnr.research-infrastructures.eu", "sdmx.fao.org", "data-transfer.cern.ch");
        List<String> objectURIs = Arrays.asList("http://example.org/absolute/URI/with/absolute/path/to/resource.txt");
        for (int i = 0; i < n; ++i) {
            RawUsageRecord t = new RawUsageRecord();
            t.setResourceType(ResourceTypes.STORAGE_USAGE.toString());
            Collections.shuffle(consumerIds);
            t.setConsumerId(consumerIds.get(0));
            Collections.shuffle(resourceOwners);
            t.setResourceOwner(resourceOwners.get(0));
            Collections.shuffle(resourceScopes);
            t.setResourceScope("/testing/vo1");
            Collections.shuffle(providerIds);
            t.setResourceSpecificProperty("providerId", providerIds.get(0));
            t.setResourceSpecificProperty("objectURI", "http://example.org/absolute/URI/with/absolute/path/to/object" + i * 2 + ".bulk");
            Collections.shuffle(operationTypes);
            t.setResourceSpecificProperty("operationType", operationTypes.get(0));
            Collections.shuffle(qualifiers);
            t.setResourceSpecificProperty("qualifier", qualifiers.get(0));
            Collections.shuffle(dataTypes);
            t.setResourceSpecificProperty("dataType", dataTypes.get(0));
            t.setResourceSpecificProperty("dataVolume", String.valueOf(10231089 - i * 2));
            t.setResourceSpecificProperty("dataCount", String.valueOf(1000 - i * 2));
            Collections.shuffle(callerIPs);
            t.setResourceSpecificProperty("callerIP", callerIPs.get(0));
            long start2013 = 0L;
            try {
                start2013 = new SimpleDateFormat("yyyy").parse("2013").getTime();
            }
            catch (ParseException e1) {
                e1.printStackTrace();
            }
            long millisInYear2012 = 1471229928L;
            long millis = Math.round(1.471229928E9 * Math.random());
            Timestamp timeStamp = new Timestamp(start2013 + millis);
            GregorianCalendar startTime = UsageTrackerRestAPI.randomDate();
            GregorianCalendar endTime = UsageTrackerRestAPI.randomDate();
            while (endTime.before(startTime)) {
                startTime = UsageTrackerRestAPI.randomDate();
                endTime = UsageTrackerRestAPI.randomDate();
            }
            try {
                t.setStartTime(startTime.getTime());
                t.setEndTime(endTime.getTime());
            }
            catch (InvalidValueException e) {
                e.printStackTrace();
            }
            t.setCreateTime(UsageTrackerRestAPI.randomDate().getTime());
            ut.insertUsageRecord(t);
        }
    }

    private static void generateStorageStatusRecords(UsageTrackerRestAPI ut, int n) {
        List<String> resourceScopes = Arrays.asList("/d4science.org", "/d4science.org/vo1", "/d4science.org/vo2", "/d4science.org/vo1/vre1", "/d4science.org/vo1/vre2");
        List<String> dataTypes = Arrays.asList("STORAGE", "DATABASE", "TREE", "GEO");
        List<String> consumerIds = Arrays.asList("luigi.fortunati", "antonio.savini", "ermanno.travaglino", "pasquale.pagano", "andrea.manzi", "fabio.simeoni", "john.gerbesiotis");
        List<String> resourceOwners = Arrays.asList("luigi.fortunati", "antonio.savini", "ermanno.travaglino", "pasquale.pagano", "andrea.manzi", "fabio.simeoni", "john.gerbesiotis");
        List<String> providerIds = Arrays.asList("cloud.eng.it", "cnr.research-infrastructures.eu", "fao.org", "cern.ch");
        List<String> qualifiers = Arrays.asList("application/xml", "application/zip", "image/jpeg", "text/xml");
        for (int i = 0; i < n; ++i) {
            RawUsageRecord t = new RawUsageRecord();
            t.setResourceType(ResourceTypes.STORAGE_STATUS.toString());
            Collections.shuffle(consumerIds);
            t.setConsumerId(consumerIds.get(0));
            Collections.shuffle(resourceOwners);
            t.setCreatorId(resourceOwners.get(0));
            Collections.shuffle(resourceOwners);
            t.setResourceOwner(resourceOwners.get(0));
            Collections.shuffle(resourceScopes);
            t.setResourceScope("/testing/vo1");
            Collections.shuffle(providerIds);
            t.setResourceSpecificProperty("providerId", providerIds.get(0));
            Collections.shuffle(qualifiers);
            t.setResourceSpecificProperty("qualifier", qualifiers.get(0));
            Collections.shuffle(dataTypes);
            t.setResourceSpecificProperty("dataType", dataTypes.get(0));
            int max = 10000;
            int min = 1;
            Random r = new Random();
            int random = r.nextInt(max - min + 1) + min;
            while (random < 0) {
                random = r.nextInt(max - min + 1) + min;
            }
            t.setResourceSpecificProperty("dataVolume", String.valueOf(random));
            t.setResourceSpecificProperty("dataCount", String.valueOf(10100 - i * 2));
            long start2013 = 0L;
            try {
                start2013 = new SimpleDateFormat("yyyy").parse("2012").getTime();
            }
            catch (ParseException e1) {
                e1.printStackTrace();
            }
            long millisInYear2012 = 1471229928L;
            long millis = Math.round(1.471229928E9 * Math.random());
            Timestamp timeStamp = new Timestamp(start2013 + millis);
            GregorianCalendar startTime = UsageTrackerRestAPI.randomDate();
            GregorianCalendar endTime = UsageTrackerRestAPI.randomDate();
            while (endTime.before(startTime)) {
                startTime = UsageTrackerRestAPI.randomDate();
                endTime = UsageTrackerRestAPI.randomDate();
            }
            t.setCreateTime(UsageTrackerRestAPI.randomDate().getTime());
            try {
                t.setStartTime(UsageTrackerRestAPI.randomDate().getTime());
                t.setEndTime(UsageTrackerRestAPI.randomDate().getTime());
            }
            catch (InvalidValueException e) {
                e.printStackTrace();
            }
            System.out.println("record = " + t);
            ut.insertUsageRecord(t);
        }
    }

    private static void generateServiceRecords(UsageTrackerRestAPI ut, int n) {
        List<String> resourceScopes = Arrays.asList("/d4science.org", "/d4science.org/vo1", "/d4science.org/vo2", "/d4science.org/vo1/vre1", "/d4science.org/vo1/vre2");
        List<String> consumerIds = Arrays.asList("luigi.fortunati", "antonio.savini", "ermanno.travaglino", "pasquale.pagano", "andrea.manzi", "fabio.simeoni", "john.gerbesiotis");
        List<String> resourceOwners = Arrays.asList("luigi.fortunati", "antonio.savini", "ermanno.travaglino", "pasquale.pagano", "andrea.manzi", "fabio.simeoni", "john.gerbesiotis");
        List<String> callerIPs = Arrays.asList("etics.eng.it", "statistical-manager.cnr.research-infrastructures.eu", "sdmx.fao.org", "data-transfer.cern.ch");
        List<String> domains = Arrays.asList("cern.ch", "fao.org", "eng.it", "cnr.it");
        List<String> serviceClasses = Arrays.asList("Personalisation", "ContentManagement", "ContentManagement", "ContentManagement");
        List<String> serviceNames = Arrays.asList("GCubeModelLibrary", "GCubeModelLibrary", "StorageManagementService", "ContentManager");
        List<String> refHosts = Arrays.asList("etics.eng.it", "statistical-manager.cnr.research-infrastructures.eu", "sdmx.fao.org", "data-transfer.cern.ch");
        List<String> refVMs = Arrays.asList("etics.eng.it", "statistical-manager.cnr.research-infrastructures.eu", "sdmx.fao.org", "data-transfer.cern.ch");
        for (int i = 0; i < n; ++i) {
            RawUsageRecord t = new RawUsageRecord();
            t.setResourceType("service");
            Collections.shuffle(consumerIds);
            t.setConsumerId(consumerIds.get(0));
            Collections.shuffle(resourceOwners);
            t.setResourceOwner(resourceOwners.get(0));
            Collections.shuffle(resourceScopes);
            t.setResourceScope("/testing/vo1");
            Collections.shuffle(refHosts);
            t.setResourceSpecificProperty("refHost", refHosts.get(0));
            Collections.shuffle(refVMs);
            t.setResourceSpecificProperty("refVM", refVMs.get(0));
            Collections.shuffle(serviceClasses);
            t.setResourceSpecificProperty("serviceClass", serviceClasses.get(0));
            Collections.shuffle(serviceNames);
            t.setResourceSpecificProperty("serviceName", serviceNames.get(0));
            Collections.shuffle(domains);
            t.setResourceSpecificProperty("domain", domains.get(0));
            t.setResourceSpecificProperty("averageInvocationTime", String.valueOf(120 - i * i));
            t.setResourceSpecificProperty("invocationCount", String.valueOf(120 - i * 2));
            Collections.shuffle(callerIPs);
            t.setResourceSpecificProperty("callerIP", callerIPs.get(0));
            long start2013 = 0L;
            try {
                start2013 = new SimpleDateFormat("yyyy").parse("2013").getTime();
            }
            catch (ParseException e1) {
                e1.printStackTrace();
            }
            long millisInYear2012 = 1471229928L;
            long millis = Math.round(1.471229928E9 * Math.random());
            Timestamp timeStamp = new Timestamp(start2013 + millis);
            GregorianCalendar startTime = UsageTrackerRestAPI.randomDate();
            GregorianCalendar endTime = UsageTrackerRestAPI.randomDate();
            while (endTime.before(startTime)) {
                startTime = UsageTrackerRestAPI.randomDate();
                endTime = UsageTrackerRestAPI.randomDate();
            }
            try {
                t.setStartTime(startTime.getTime());
                t.setEndTime(endTime.getTime());
            }
            catch (InvalidValueException e) {
                e.printStackTrace();
            }
            t.setCreateTime(UsageTrackerRestAPI.randomDate().getTime());
            ut.insertUsageRecord(t);
        }
    }

    public Collection<AggregatedResult> getReport(Report r) {
        this.service = this.client.resource(this.uri);
        AggregatedResult[] results = this.service.path("reports").path(r.getResourceType()).path(r.getReportType()).post(AggregatedResult[].class, (Object)r);
        ArrayList<AggregatedResult> out = new ArrayList<AggregatedResult>();
        for (AggregatedResult c : results) {
            out.add(c);
        }
        return out;
    }

    public FilterRating getFilterRating(Report r) {
        this.service = this.client.resource(this.uri);
        FilterRating filterRating = this.service.path("filters").path(r.getResourceType()).path(r.getReportType()).post(FilterRating.class, (Object)r);
        return filterRating;
    }

    public static void main(String[] args) {
        UsageTrackerRestAPI ut = new UsageTrackerRestAPI("http://node57.p.d4science.research-infrastructures.eu:8080/usagetracker/rest");
        Report r = new Report();
        r.setResourceType("storage-status");
        r.setReportType("volume");
        r.setAggregationGranule("day");
        r.setDimension("resourceScope");
        HashMap<String, List<String>> genericFilters = new HashMap<String, List<String>>();
        ArrayList<String> genericValues = new ArrayList<String>();
        genericValues.add("/d4science.research-infrastructures.eu/Ecosystem");
        genericFilters.put("resourceScope", genericValues);
        r.setFilters(genericFilters);
        Calendar cal = Calendar.getInstance();
        cal.set(2010, 4, 1, 0, 0, 0);
        r.setStartPeriod(cal.getTime());
        cal.set(2015, 4, 31, 23, 59, 59);
        r.setEndPeriod(cal.getTime());
        System.out.println(r);
        Collection<AggregatedResult> results = ut.getReport(r);
        for (AggregatedResult aggregatedResult : results) {
            System.out.println(aggregatedResult.toString());
        }
    }

    public static GregorianCalendar randomDate() {
        GregorianCalendar calendar = new GregorianCalendar();
        int currentYear = 2013;
        int max = 365;
        int min = 1;
        int randomNum = random.nextInt(max - min + 1) + min;
        calendar.set(5, randomNum);
        calendar.set(1, currentYear - random.nextInt(2));
        return calendar;
    }
}

