/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageserver.startup;

import java.util.Arrays;
import java.util.List;
import org.gcube.contentmanager.storageserver.consumer.FolderAccountingConsumer;
import org.gcube.contentmanager.storageserver.consumer.UserAccountingConsumer;
import org.gcube.contentmanager.storageserver.data.CubbyHole;
import org.gcube.contentmanager.storageserver.data.ReadingMongoOplog;
import org.gcube.contentmanager.storageserver.startup.Configuration;

public class Startup {
    private static String user;
    private static String password;
    private static String scope;

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            System.out.println("param N." + i + ": " + args[i]);
        }
        if (args.length != 2 && args.length != 4) {
            System.out.println("Usage:");
            System.out.println("\tjava  Startup scope ip user password\n\n");
            System.out.println("Example:");
            System.out.println("\tjava  Startup /gcube/devsec localhost pippo pluT0\n");
            System.out.println("or ");
            System.out.println("Usage:");
            System.out.println("\tjava  Startup scope ip\n\n");
            System.out.println("Example:");
            System.out.println("\tjava  Startup /gcube  localhost\n\n");
            return;
        }
        scope = args[0];
        String oplogServer = args[1];
        if (args.length == 4) {
            user = args[2];
            password = args[3];
        }
        Configuration cfg = new Configuration(scope, user, password, true);
        String[] server = Startup.retrieveServerConfiguration(cfg);
        List<String> dtsHosts = Startup.retrieveDTSConfiguration(cfg);
        CubbyHole c1 = new CubbyHole();
        CubbyHole c2 = new CubbyHole();
        ReadingMongoOplog producer = null;
        producer = args.length == 3 ? new ReadingMongoOplog(Arrays.asList(oplogServer), args[1], args[2], c1, c2, 1) : new ReadingMongoOplog(Arrays.asList(server), c1, c2, 1);
        UserAccountingConsumer ssConsumer = null;
        ssConsumer = args.length == 3 ? new UserAccountingConsumer(server, c1, 1, dtsHosts) : new UserAccountingConsumer(server, args[1], args[2], c1, 1, dtsHosts);
        FolderAccountingConsumer fsConsumer = null;
        fsConsumer = args.length == 3 ? new FolderAccountingConsumer(server, c2, 1) : new FolderAccountingConsumer(server, args[1], args[2], c2, 1);
        producer.start();
        ssConsumer.start();
        fsConsumer.start();
    }

    private static String[] retrieveServerConfiguration(Configuration c) {
        return c.getServerAccess();
    }

    private static List<String> retrieveDTSConfiguration(Configuration c) {
        return c.retrieveDTSHosts();
    }
}

