/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageserver.store;

import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.Mongo;
import com.mongodb.MongoOptions;
import org.gcube.contentmanager.storageserver.store.FolderStatusObject;
import org.gcube.contentmanager.storageserver.store.FolderStatusOperationManager;
import org.gcube.contentmanager.storageserver.store.StorageStatusObject;
import org.gcube.contentmanager.storageserver.store.StorageStatusOperationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDB {
    private Mongo mongo;
    private DB db;
    private String[] server;
    private String collectionSSName;
    private String collectionFSName;
    private int port;
    private String pwd;
    private String user;
    private DBCollection ssCollection;
    private DBCollection fsCollection;
    Logger logger = LoggerFactory.getLogger(MongoDB.class);
    private static final String ACCOUNTING_DB = "accounting";
    private static final String DEFAULT_SS_COLLECTION = "storageStatus";
    private static final String DEFAULT_FS_COLLECTION = "folderStatus";
    private FolderStatusOperationManager folderOperationManager;
    private StorageStatusOperationManager ssOperationManager;

    public MongoDB(String[] server, int port, String user, String password) {
        this.server = server;
        this.port = port;
        this.pwd = password;
        this.user = user;
        this.collectionSSName = DEFAULT_SS_COLLECTION;
        this.collectionFSName = DEFAULT_FS_COLLECTION;
        this.folderOperationManager = new FolderStatusOperationManager(this.getFolderStatusCollection());
        this.ssOperationManager = new StorageStatusOperationManager(this.getStorageStatusCollection());
    }

    public MongoDB(String[] server, String user, String password) {
        this.server = server;
        this.pwd = password;
        this.user = user;
        this.collectionSSName = DEFAULT_SS_COLLECTION;
        this.collectionFSName = DEFAULT_FS_COLLECTION;
        this.folderOperationManager = new FolderStatusOperationManager(this.getFolderStatusCollection());
        this.ssOperationManager = new StorageStatusOperationManager(this.getStorageStatusCollection());
    }

    public MongoDB(String[] server, String user, String password, String ssCollection, String fsCollection) {
        this.server = server;
        this.pwd = password;
        this.user = user;
        this.collectionSSName = ssCollection != null ? ssCollection : DEFAULT_SS_COLLECTION;
        this.collectionFSName = fsCollection != null ? fsCollection : DEFAULT_FS_COLLECTION;
        this.folderOperationManager = new FolderStatusOperationManager(this.getFolderStatusCollection());
        this.ssOperationManager = new StorageStatusOperationManager(this.getStorageStatusCollection());
    }

    public StorageStatusObject updateUserVolume(StorageStatusObject ssRecord, String operation) {
        ssRecord = this.ssOperationManager.updateUser(ssRecord, operation);
        this.close();
        return ssRecord;
    }

    public FolderStatusObject updateFolderVolume(FolderStatusObject fsRecord, String operation) {
        this.logger.debug("update folder recursively");
        fsRecord = this.folderOperationManager.updateFolder(fsRecord, operation);
        this.logger.debug("end update folder edge ");
        this.close();
        return fsRecord;
    }

    public StorageStatusObject getSSRecord(String consumer) {
        StorageStatusObject record = this.ssOperationManager.getSSRecord(consumer);
        this.close();
        return record;
    }

    public FolderStatusObject getFSRecord(String folder) {
        FolderStatusObject record = this.folderOperationManager.getFSRecord(folder);
        this.close();
        return record;
    }

    private DB getDB() {
        if (this.db != null) {
            try {
                DB db = this.mongo.getDB(ACCOUNTING_DB);
            }
            catch (Exception e) {
                this.logger.warn("the server now is not a primary ");
                this.db = null;
            }
        }
        if (this.db == null) {
            int i = -1;
            for (String srv : this.server) {
                try {
                    boolean auth;
                    ++i;
                    this.ssCollection = null;
                    if (this.mongo != null) {
                        this.mongo.close();
                    }
                    MongoOptions options = new MongoOptions();
                    options.autoConnectRetry = true;
                    options.socketKeepAlive = true;
                    options.maxWaitTime = 240000;
                    options.connectionsPerHost = 35;
                    this.mongo = new Mongo(srv, options);
                    this.logger.debug("Istantiate MongoDB with options: " + this.mongo.getMongoOptions());
                    this.db = this.mongo.getDB(ACCOUNTING_DB);
                    if (this.user == null) {
                        this.user = "";
                    }
                    if (this.pwd == null) {
                        this.pwd = "";
                    }
                    if (auth = this.db.authenticate(this.user, this.pwd.toCharArray())) {
                        this.logger.debug("mongo is in authenticate mode");
                    } else {
                        this.logger.debug("mongo is not in authenticate mode");
                    }
                    if (this.ssCollection == null) {
                        this.ssCollection = this.db.getCollection(this.collectionSSName);
                    }
                    this.ssCollection.findOne();
                    String firstServer = this.server[0];
                    this.server[0] = srv;
                    this.server[i] = firstServer;
                    break;
                }
                catch (Exception e) {
                    this.logger.warn("server " + srv + " is not a primary retry ");
                }
            }
        }
        return this.db;
    }

    public DBCollection getStorageStatusCollection() {
        if (this.ssCollection == null) {
            return this.getDB().getCollection(this.collectionSSName);
        }
        return this.ssCollection;
    }

    public DBCollection getFolderStatusCollection() {
        if (this.fsCollection == null) {
            return this.getDB().getCollection(this.collectionFSName);
        }
        return this.fsCollection;
    }

    public void close() {
        if (this.mongo != null) {
            this.mongo.close();
        }
    }
}

