/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.persistence;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.gcube.accounting.datamodel.BasicUsageRecord;
import org.gcube.accounting.datamodel.aggregation.AggregatedServiceUsageRecord;
import org.gcube.accounting.datamodel.usagerecords.ServiceUsageRecord;
import org.gcube.accounting.persistence.AccountingPersistence;
import org.gcube.documentstore.persistence.PersistenceBackendFactory;

public class AccountingPersistenceFactory {
    protected static final Map<String, AccountingPersistence> persistences = new HashMap<String, AccountingPersistence>();

    private AccountingPersistenceFactory() {
    }

    public static void initAccountingPackages() {
        PersistenceBackendFactory.addRecordPackage(ServiceUsageRecord.class.getPackage());
        PersistenceBackendFactory.addRecordPackage(AggregatedServiceUsageRecord.class.getPackage());
    }

    public static void setFallbackLocation(String path) {
        PersistenceBackendFactory.setFallbackLocation(path);
    }

    public static synchronized AccountingPersistence getPersistence() {
        String context = BasicUsageRecord.getContextFromToken();
        AccountingPersistence accountingPersistence = persistences.get(context);
        if (accountingPersistence == null) {
            accountingPersistence = new AccountingPersistence(context);
            persistences.put(context, accountingPersistence);
        }
        return accountingPersistence;
    }

    public static void flushAll() {
        PersistenceBackendFactory.flushAll();
    }

    @Deprecated
    public static void flushAll(long timeout, TimeUnit timeUnit) {
        AccountingPersistenceFactory.flushAll();
    }

    public static void shutDown() {
        PersistenceBackendFactory.flushAll();
        PersistenceBackendFactory.shutdown();
    }

    @Deprecated
    public static void shutDown(long timeout, TimeUnit timeUnit) {
        AccountingPersistenceFactory.shutDown();
    }

    static {
        AccountingPersistenceFactory.initAccountingPackages();
    }
}

