/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.security.authz;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.gcube.accounting.common.file.FileChangedListener;
import org.gcube.accounting.exception.NotFoundException;
import org.gcube.accounting.security.authz.Action;
import org.gcube.accounting.security.authz.AuthorizationManager;
import org.gcube.accounting.security.authz.Permission;
import org.gcube.accounting.security.authz.Role;

public class FileAuthorizationManager
implements AuthorizationManager,
FileChangedListener {
    private static Logger logger = Logger.getLogger(FileAuthorizationManager.class);
    private static final String ALL = "all";
    private static final String ANONYMOUS = "anonymous";
    private Map<String, Collection<Permission>> permissions;
    private Map<String, Role> roles;
    private File file;

    public FileAuthorizationManager(String file) {
        this(new File(file));
    }

    public FileAuthorizationManager(File file) {
        this.file = file;
        this.permissions = new HashMap<String, Collection<Permission>>();
        this.roles = new HashMap<String, Role>();
        this.parseAuthorizationFile();
    }

    @Override
    public void fileChanged(File file) {
        logger.info("Authorization file has changed. Refreshing rules.");
        this.parseAuthorizationFile();
    }

    private Role parseRoleLine(String line) throws Exception {
        line = " " + line + " ";
        Pattern rolePattern = Pattern.compile("^\\s*([0-9a-z_-]+)\\s*:\\s*(([0-9a-z_-]+\\s*,?\\s*)*)\\s*$", 2);
        Matcher m = rolePattern.matcher(line);
        if (m.matches()) {
            String[] actions;
            Role r = new Role(m.group(1));
            for (String a : actions = m.group(2).split(",")) {
                try {
                    a = a.trim();
                    String msg = String.format("Adding action '%s' to role '%s'", a, r.getName());
                    logger.info(msg);
                    Action act = Action.getAction(a);
                    r.addAction(act);
                }
                catch (NotFoundException e) {
                    String msg = String.format("Undefined action '%s' for role '%s'. Ignoring.", a, r.getName());
                    logger.warn(msg);
                }
            }
            return r;
        }
        String msg = "Malformed role definition: " + line;
        logger.warn(msg);
        throw new Exception(msg);
    }

    private Collection<Permission> parsePermissionLine(String line) throws Exception {
        line = " " + line + " ";
        String[] parts = line.split(":");
        if (parts.length != 3) {
            String msg = "Malformed permission definition: " + line;
            throw new Exception(msg);
        }
        String[] users = parts[0].split(",");
        String[] roles = parts[1].split(",");
        String target = parts[2];
        Vector<Permission> out = new Vector<Permission>();
        for (String u : users) {
            u = u.trim();
            for (String r : roles) {
                String msg;
                Role role = this.roles.get(r = r.trim());
                if (role != null) {
                    target = target.trim();
                    msg = String.format("Granting role '%s' to user '%s' over '%s'.", r, u, target);
                    logger.info(msg);
                    Permission p = new Permission(u, target, role);
                    out.add(p);
                    continue;
                }
                msg = String.format("Undefined role '%s'. Ignoring", r);
                logger.warn(msg);
            }
        }
        return out;
    }

    private void parseAuthorizationFile() {
        this.permissions.clear();
        this.roles.clear();
        this.parseAuthorizationFile(Section.ROLE);
        this.parseAuthorizationFile(Section.PERMISSION);
    }

    private void parseAuthorizationFile(Section section) {
        Pattern rolePattern = Pattern.compile("\\s*\\[\\s*role\\s*\\]\\s*", 2);
        Pattern permissionPattern = Pattern.compile("\\s*\\[\\s*permission\\s*\\]\\s*", 2);
        try {
            String line;
            FileInputStream fstream = new FileInputStream(this.file);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            Section currentSection = null;
            while ((line = br.readLine()) != null) {
                if (line.trim().startsWith("#") || line.trim().equals("")) continue;
                Matcher m1 = rolePattern.matcher(line);
                if (m1.matches()) {
                    logger.debug("entering 'role' section");
                    currentSection = Section.ROLE;
                    continue;
                }
                Matcher m2 = permissionPattern.matcher(line);
                if (m2.matches()) {
                    logger.debug("entering 'permission' section");
                    currentSection = Section.PERMISSION;
                    continue;
                }
                if (section != currentSection) continue;
                if (section == Section.ROLE) {
                    try {
                        this.addRole(this.parseRoleLine(line));
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                }
                if (section != Section.PERMISSION) continue;
                try {
                    this.addPermissions(this.parsePermissionLine(line));
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
            in.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    private void addRole(Role r) throws Exception {
        if (r == null) {
            return;
        }
        if (r.getName() == null) {
            return;
        }
        if (this.roles.containsKey(r.getName())) {
            String msg = String.format("Duplicate role '%s'", r.getName());
            logger.debug(msg);
            throw new Exception(msg);
        }
        logger.debug("Adding role " + r.getName());
        this.roles.put(r.getName(), r);
    }

    private void addPermissions(Collection<Permission> perms) {
        for (Permission p : perms) {
            this.addPermission(p);
        }
    }

    private Collection<Permission> retrieveUserPermission(String userId) {
        Collection<Permission> userAuthz = this.permissions.get(userId);
        if (userAuthz == null) {
            userAuthz = new Vector<Permission>();
            this.permissions.put(userId, userAuthz);
        }
        return userAuthz;
    }

    private void addPermission(Permission p) {
        if (p == null) {
            return;
        }
        logger.debug(String.format("Adding permission '%s'", p.toString()));
        Collection<Permission> userAuthz = this.retrieveUserPermission(p.getUserId());
        userAuthz.add(p);
    }

    private Collection<Permission> computeUserPermissions(String userId) {
        if (userId == null) {
            return this.retrieveUserPermission(ANONYMOUS);
        }
        ArrayList<Permission> out = new ArrayList<Permission>();
        out.addAll(this.retrieveUserPermission(userId));
        out.addAll(this.retrieveUserPermission(ALL));
        return out;
    }

    @Override
    public boolean isAllowed(String userId, Action action) {
        for (Permission p : this.computeUserPermissions(userId)) {
            if (!p.isAllowed(action)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAllowed(String userId, Action action, String object) {
        for (Permission p : this.computeUserPermissions(userId)) {
            if (!p.isAllowed(action, object)) continue;
            return true;
        }
        return false;
    }

    private static enum Section {
        ROLE,
        PERMISSION;

    }
}

