/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.resources.gcore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.Software;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class Resources {
    private static SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    private static Map<Class<?>, String> schemaResources = new HashMap();
    private static Map<Class<?>, Schema> schemas = new HashMap();
    private static Map<Class<?>, JAXBContext> contexts = new HashMap();

    public static void validate(Resource resource) throws IllegalArgumentException, Exception {
        Schema schema = Resources.schema(resource.getClass());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(Resources.marshal(resource, out).toByteArray());
        schema.newValidator().validate(new StreamSource(in));
    }

    private static synchronized Schema schema(Class<?> resourceClass) throws Exception {
        String schemaResource = schemaResources.get(resourceClass);
        if (schemaResource == null) {
            throw new IllegalArgumentException("no known schema for:\n " + resourceClass);
        }
        Schema schema = schemas.get(resourceClass);
        if (schema == null) {
            InputStream stream = Resources.class.getClassLoader().getResourceAsStream(schemaResource);
            schema = schemaFactory.newSchema(new StreamSource(stream));
            schemas.put(resourceClass, schema);
        }
        return schema;
    }

    public static <T extends OutputStream> T marshal(Object resource, T stream) {
        Resources.marshal(resource, new StreamResult(stream));
        return stream;
    }

    public static <T extends Writer> T marshal(Object resource, T stream) {
        Resources.marshal(resource, new StreamResult(stream));
        return stream;
    }

    public static <T extends Result> T marshal(Object resource, T result) {
        if (resource instanceof Resource) {
            ((Resource)resource).lock.lock();
        }
        try {
            JAXBContext context = Resources.context(resource.getClass());
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", Boolean.TRUE);
            m.marshal(resource, result);
            T t = result;
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException("serialisation error", e);
        }
        finally {
            if (resource instanceof Resource) {
                ((Resource)resource).lock.unlock();
            }
        }
    }

    public static void print(Object resource) {
        Resources.marshal(resource, new OutputStreamWriter(System.out));
    }

    public static <T> T unmarshal(Class<T> resourceClass, Reader reader) {
        return Resources.unmarshal(resourceClass, new StreamSource(reader));
    }

    public static <T> T unmarshal(Class<T> resourceClass, InputStream stream) {
        return Resources.unmarshal(resourceClass, new StreamSource(stream));
    }

    public static <T> T unmarshal(Class<T> resourceClass, Source source) {
        try {
            JAXBContext ctx = Resources.context(resourceClass);
            Unmarshaller um = ctx.createUnmarshaller();
            return resourceClass.cast(um.unmarshal(source));
        }
        catch (Exception e) {
            throw new RuntimeException("deserialisation error", e);
        }
    }

    private static synchronized JAXBContext context(Class<?> resourceClass) throws Exception {
        JAXBContext ctx = contexts.get(resourceClass);
        if (ctx == null) {
            ctx = JAXBContext.newInstance(resourceClass);
            contexts.put(resourceClass, ctx);
        }
        return ctx;
    }

    static {
        schemaFactory.setResourceResolver(new SchemaResolver());
        schemaResources.put(GenericResource.class, "schema/generic.xsd");
        schemaResources.put(ServiceEndpoint.class, "schema/endpoint.xsd");
        schemaResources.put(Software.class, "schema/service.xsd");
        schemaResources.put(GCoreEndpoint.class, "schema/gcoreendpoint.xsd");
        schemaResources.put(HostingNode.class, "schema/node.xsd");
    }

    private static class SchemaResolver
    implements LSResourceResolver {
        private static LSInput input;

        private SchemaResolver() {
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            if (systemId.equals("CommonTypeDefinitions.xsd")) {
                input.setByteStream(Resources.class.getResourceAsStream("/schema/CommonTypeDefinitions.xsd"));
            }
            return input;
        }

        static {
            try {
                input = ((DOMImplementationLS)((Object)DOMImplementationRegistry.newInstance().getDOMImplementation("LS"))).createLSInput();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

