/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.service.strategies;

import com.couchbase.client.core.endpoint.Endpoint;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.service.strategies.SelectionStrategy;
import com.couchbase.client.core.state.LifecycleState;
import java.util.Random;

public class RandomSelectionStrategy
implements SelectionStrategy {
    private static final Random RANDOM = new Random();
    private static final int MAX_TRIES = 100;

    @Override
    public Endpoint select(CouchbaseRequest request, Endpoint[] endpoints) {
        int numEndpoints = endpoints.length;
        if (numEndpoints == 0) {
            return null;
        }
        for (int i = 0; i < 100; ++i) {
            int rand = RANDOM.nextInt(endpoints.length);
            Endpoint endpoint = endpoints[rand];
            if (!endpoint.isState(LifecycleState.CONNECTED)) continue;
            return endpoint;
        }
        return null;
    }
}

