/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transcoder;

import com.couchbase.client.core.lang.Tuple;
import com.couchbase.client.core.lang.Tuple2;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.kv.MutationToken;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import com.couchbase.client.java.document.JsonDoubleDocument;
import com.couchbase.client.java.error.TranscodingException;
import com.couchbase.client.java.transcoder.AbstractTranscoder;
import com.couchbase.client.java.transcoder.JacksonTransformers;
import com.couchbase.client.java.transcoder.TranscoderUtils;

public class JsonDoubleTranscoder
extends AbstractTranscoder<JsonDoubleDocument, Double> {
    @Override
    protected JsonDoubleDocument doDecode(String id, ByteBuf content, long cas, int expiry, int flags, ResponseStatus status) throws Exception {
        double decoded;
        if (TranscoderUtils.hasCommonFlags(flags) && flags == TranscoderUtils.JSON_COMMON_FLAGS) {
            String val = content.toString(CharsetUtil.UTF_8);
            decoded = JacksonTransformers.MAPPER.readValue(val, Double.class);
        } else if (flags == 1536 || flags == 1792) {
            long rv = 0L;
            int readable = content.readableBytes();
            for (int i = 0; i < readable; ++i) {
                int b = content.readByte();
                rv = rv << 8 | (long)(b < 0 ? 256 + b : b);
            }
            decoded = flags == 1536 ? (double)Float.intBitsToFloat((int)rv) : Double.longBitsToDouble(rv);
        } else {
            throw new TranscodingException("Flags (0x" + Integer.toHexString(flags) + ") indicate non " + "JsonDoubleDocument id " + id + ", could not decode.");
        }
        return this.newDocument(id, expiry, decoded, cas);
    }

    @Override
    protected Tuple2<ByteBuf, Integer> doEncode(JsonDoubleDocument document) throws Exception {
        return Tuple.create(TranscoderUtils.encodeStringAsUtf8(JacksonTransformers.MAPPER.writeValueAsString(document.content())), TranscoderUtils.DOUBLE_COMPAT_FLAGS);
    }

    @Override
    public JsonDoubleDocument newDocument(String id, int expiry, Double content, long cas) {
        return JsonDoubleDocument.create(id, expiry, content, cas);
    }

    @Override
    public JsonDoubleDocument newDocument(String id, int expiry, Double content, long cas, MutationToken mutationToken) {
        return JsonDoubleDocument.create(id, expiry, content, cas, mutationToken);
    }

    @Override
    public Class<JsonDoubleDocument> documentType() {
        return JsonDoubleDocument.class;
    }
}

