/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.query;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.search.SearchControl;

@InterfaceAudience.Public
@InterfaceStability.Experimental
public abstract class SearchQuery {
    public static final int SIZE = 10;
    public static final int FROM = 0;
    public static final double BOOST = 1.0;
    private static final boolean EXPLAIN = false;
    private static final String HIGHLIGHT_STYLE = "html";
    protected final double boost;
    private final int size;
    private final int from;
    private final String index;
    private final boolean explain;
    private final String highlightStyle;
    private final String[] highlightFields;
    private final String[] fields;
    private final SearchControl control;

    protected SearchQuery(Builder builder) {
        this.size = builder.size;
        this.from = builder.from;
        this.index = builder.index;
        this.explain = builder.explain;
        this.highlightStyle = builder.highlightStyle;
        this.highlightFields = builder.highlightFields;
        this.fields = builder.fields;
        this.control = builder.control;
        this.boost = builder.boost;
    }

    public int limit() {
        return this.size;
    }

    public int offset() {
        return this.from;
    }

    public String index() {
        return this.index;
    }

    public String[] fields() {
        return this.fields;
    }

    public SearchControl control() {
        return this.control;
    }

    public double boost() {
        return this.boost;
    }

    public abstract JsonObject queryJson();

    public JsonObject json() {
        JsonObject json = JsonObject.create();
        json.put("query", this.queryJson().put("boost", this.boost));
        JsonObject highlightJson = JsonObject.create();
        if (this.highlightStyle != null) {
            highlightJson.put("style", this.highlightStyle);
        }
        if (this.highlightFields != null) {
            highlightJson.put("fields", JsonArray.from(this.highlightFields));
        }
        if (highlightJson.size() > 0) {
            json.put("highlight", highlightJson);
        }
        if (this.fields != null) {
            json.put("fields", JsonArray.from(this.fields));
        }
        json.put("size", this.size);
        json.put("from", this.from);
        json.put("explain", this.explain);
        if (this.control != null) {
            json.put("ctl", this.control.json());
        }
        return json;
    }

    public static abstract class Builder {
        public boolean explain = false;
        public String highlightStyle = "html";
        public String[] highlightFields;
        public String[] fields;
        public SearchControl control = null;
        public double boost = 1.0;
        private int size = 10;
        private int from = 0;
        protected String index;

        protected Builder(String index) {
            this.index = index;
        }

        public abstract SearchQuery build();

        public Builder limit(int limit) {
            this.size = limit;
            return this;
        }

        public Builder offset(int offset) {
            this.from = offset;
            return this;
        }

        public Builder explain(boolean explain) {
            this.explain = explain;
            return this;
        }

        public Builder highlightStyle(String highlightStyle) {
            this.highlightStyle = highlightStyle;
            return this;
        }

        public Builder highlightFields(String ... highlightFields) {
            this.highlightFields = highlightFields;
            return this;
        }

        public Builder fields(String ... fields) {
            this.fields = fields;
            return this;
        }

        public Builder control(SearchControl control) {
            this.control = control;
            return this;
        }

        public Builder boost(double boost) {
            this.boost = boost;
            return this;
        }
    }
}

