/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.view;

import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.view.OnError;
import com.couchbase.client.java.view.Stale;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Arrays;

public class ViewQuery
implements Serializable {
    private static final long serialVersionUID = -9127974725934261293L;
    private static final int PARAM_REDUCE_OFFSET = 0;
    private static final int PARAM_LIMIT_OFFSET = 2;
    private static final int PARAM_SKIP_OFFSET = 4;
    private static final int PARAM_STALE_OFFSET = 6;
    private static final int PARAM_GROUPLEVEL_OFFSET = 8;
    private static final int PARAM_GROUP_OFFSET = 10;
    private static final int PARAM_ONERROR_OFFSET = 12;
    private static final int PARAM_DEBUG_OFFSET = 14;
    private static final int PARAM_DESCENDING_OFFSET = 16;
    private static final int PARAM_INCLUSIVEEND_OFFSET = 18;
    private static final int PARAM_STARTKEY_OFFSET = 20;
    private static final int PARAM_STARTKEYDOCID_OFFSET = 22;
    private static final int PARAM_ENDKEY_OFFSET = 24;
    private static final int PARAM_ENDKEYDOCID_OFFSET = 26;
    private static final int PARAM_KEY_OFFSET = 28;
    private static final int NUM_PARAMS = 15;
    private final String[] params;
    private final String design;
    private final String view;
    private boolean development;
    private boolean includeDocs;
    private boolean retainOrder;
    private Class<? extends Document<?>> includeDocsTarget;
    private String keysJson;

    private ViewQuery(String design, String view) {
        this.design = design;
        this.view = view;
        this.params = new String[30];
        this.includeDocs = false;
        this.retainOrder = false;
        this.includeDocsTarget = null;
    }

    public static ViewQuery from(String design, String view) {
        return new ViewQuery(design, view);
    }

    public ViewQuery development() {
        return this.development(true);
    }

    public ViewQuery development(boolean development) {
        this.development = development;
        return this;
    }

    public ViewQuery includeDocsOrdered() {
        return this.includeDocsOrdered(true, JsonDocument.class);
    }

    public ViewQuery includeDocsOrdered(Class<? extends Document<?>> target) {
        return this.includeDocsOrdered(true, target);
    }

    public ViewQuery includeDocsOrdered(boolean includeDocs) {
        return this.includeDocsOrdered(includeDocs, JsonDocument.class);
    }

    public ViewQuery includeDocsOrdered(boolean includeDocs, Class<? extends Document<?>> target) {
        this.includeDocs = includeDocs;
        this.retainOrder = includeDocs;
        this.includeDocsTarget = target;
        return this;
    }

    public ViewQuery includeDocs() {
        return this.includeDocs(true, JsonDocument.class);
    }

    public ViewQuery includeDocs(Class<? extends Document<?>> target) {
        return this.includeDocs(true, target);
    }

    public ViewQuery includeDocs(boolean includeDocs) {
        return this.includeDocs(includeDocs, JsonDocument.class);
    }

    public ViewQuery includeDocs(boolean includeDocs, Class<? extends Document<?>> target) {
        this.includeDocs = includeDocs;
        this.retainOrder = false;
        this.includeDocsTarget = target;
        return this;
    }

    public ViewQuery reduce(boolean reduce) {
        this.params[0] = "reduce";
        this.params[1] = Boolean.toString(reduce);
        return this;
    }

    public ViewQuery reduce() {
        return this.reduce(true);
    }

    public ViewQuery limit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("Limit must be >= 0.");
        }
        this.params[2] = "limit";
        this.params[3] = Integer.toString(limit);
        return this;
    }

    public ViewQuery group() {
        return this.group(true);
    }

    public ViewQuery group(boolean group) {
        this.params[10] = "group";
        this.params[11] = Boolean.toString(group);
        return this;
    }

    public ViewQuery groupLevel(int grouplevel) {
        this.params[8] = "group_level";
        this.params[9] = Integer.toString(grouplevel);
        return this;
    }

    public ViewQuery inclusiveEnd() {
        return this.inclusiveEnd(true);
    }

    public ViewQuery inclusiveEnd(boolean inclusive) {
        this.params[18] = "inclusive_end";
        this.params[19] = Boolean.toString(inclusive);
        return this;
    }

    public ViewQuery skip(int skip) {
        if (skip < 0) {
            throw new IllegalArgumentException("Skip must be >= 0.");
        }
        this.params[4] = "skip";
        this.params[5] = Integer.toString(skip);
        return this;
    }

    public ViewQuery stale(Stale stale) {
        this.params[6] = "stale";
        this.params[7] = stale.identifier();
        return this;
    }

    public ViewQuery onError(OnError onError) {
        this.params[12] = "on_error";
        this.params[13] = onError.identifier();
        return this;
    }

    public ViewQuery debug() {
        return this.debug(true);
    }

    public ViewQuery debug(boolean debug) {
        this.params[14] = "debug";
        this.params[15] = Boolean.toString(debug);
        return this;
    }

    public ViewQuery descending() {
        return this.descending(true);
    }

    public ViewQuery descending(boolean desc) {
        this.params[16] = "descending";
        this.params[17] = Boolean.toString(desc);
        return this;
    }

    public ViewQuery key(String key) {
        this.params[28] = "key";
        this.params[29] = this.encode("\"" + key + "\"");
        return this;
    }

    public ViewQuery key(int key) {
        this.params[28] = "key";
        this.params[29] = Integer.toString(key);
        return this;
    }

    public ViewQuery key(long key) {
        this.params[28] = "key";
        this.params[29] = Long.toString(key);
        return this;
    }

    public ViewQuery key(double key) {
        this.params[28] = "key";
        this.params[29] = Double.toString(key);
        return this;
    }

    public ViewQuery key(boolean key) {
        this.params[28] = "key";
        this.params[29] = Boolean.toString(key);
        return this;
    }

    public ViewQuery key(JsonObject key) {
        this.params[28] = "key";
        this.params[29] = this.encode(key.toString());
        return this;
    }

    public ViewQuery key(JsonArray key) {
        this.params[28] = "key";
        this.params[29] = this.encode(key.toString());
        return this;
    }

    public ViewQuery keys(JsonArray keys) {
        this.keysJson = keys.toString();
        return this;
    }

    public ViewQuery startKeyDocId(String id) {
        this.params[22] = "startkey_docid";
        this.params[23] = this.encode(id);
        return this;
    }

    public ViewQuery endKeyDocId(String id) {
        this.params[26] = "endkey_docid";
        this.params[27] = this.encode(id);
        return this;
    }

    public ViewQuery endKey(String key) {
        this.params[24] = "endkey";
        this.params[25] = this.encode("\"" + key + "\"");
        return this;
    }

    public ViewQuery endKey(int key) {
        this.params[24] = "endkey";
        this.params[25] = Integer.toString(key);
        return this;
    }

    public ViewQuery endKey(long key) {
        this.params[24] = "endkey";
        this.params[25] = Long.toString(key);
        return this;
    }

    public ViewQuery endKey(double key) {
        this.params[24] = "endkey";
        this.params[25] = Double.toString(key);
        return this;
    }

    public ViewQuery endKey(boolean key) {
        this.params[24] = "endkey";
        this.params[25] = Boolean.toString(key);
        return this;
    }

    public ViewQuery endKey(JsonObject key) {
        this.params[24] = "endkey";
        this.params[25] = this.encode(key.toString());
        return this;
    }

    public ViewQuery endKey(JsonArray key) {
        this.params[24] = "endkey";
        this.params[25] = this.encode(key.toString());
        return this;
    }

    public ViewQuery startKey(String key) {
        this.params[20] = "startkey";
        this.params[21] = this.encode("\"" + key + "\"");
        return this;
    }

    public ViewQuery startKey(int key) {
        this.params[20] = "startkey";
        this.params[21] = Integer.toString(key);
        return this;
    }

    public ViewQuery startKey(long key) {
        this.params[20] = "startkey";
        this.params[21] = Long.toString(key);
        return this;
    }

    public ViewQuery startKey(double key) {
        this.params[20] = "startkey";
        this.params[21] = Double.toString(key);
        return this;
    }

    public ViewQuery startKey(boolean key) {
        this.params[20] = "startkey";
        this.params[21] = Boolean.toString(key);
        return this;
    }

    public ViewQuery startKey(JsonObject key) {
        this.params[20] = "startkey";
        this.params[21] = this.encode(key.toString());
        return this;
    }

    public ViewQuery startKey(JsonArray key) {
        this.params[20] = "startkey";
        this.params[21] = this.encode(key.toString());
        return this;
    }

    protected String encode(String source) {
        try {
            return URLEncoder.encode(source, "UTF-8");
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not prepare view argument: " + ex);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean firstParam = true;
        for (int i = 0; i < this.params.length; ++i) {
            boolean even;
            if (this.params[i] == null) {
                ++i;
                continue;
            }
            boolean bl = even = i % 2 == 0;
            if (even && !firstParam) {
                sb.append("&");
            }
            sb.append(this.params[i]);
            firstParam = false;
            if (!even) continue;
            sb.append('=');
        }
        return sb.toString();
    }

    public String getDesign() {
        return this.design;
    }

    public String getView() {
        return this.view;
    }

    public String getKeys() {
        return this.keysJson;
    }

    boolean isOrderRetained() {
        return this.retainOrder;
    }

    public boolean isDevelopment() {
        return this.development;
    }

    public boolean isIncludeDocs() {
        return this.includeDocs;
    }

    public Class<? extends Document<?>> includeDocsTarget() {
        return this.includeDocsTarget;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ViewQuery viewQuery = (ViewQuery)o;
        if (this.development != viewQuery.development) {
            return false;
        }
        if (this.design != null ? !this.design.equals(viewQuery.design) : viewQuery.design != null) {
            return false;
        }
        if (!Arrays.equals(this.params, viewQuery.params)) {
            return false;
        }
        if (this.keysJson != null ? !this.keysJson.equals(viewQuery.keysJson) : viewQuery.keysJson != null) {
            return false;
        }
        return !(this.view != null ? !this.view.equals(viewQuery.view) : viewQuery.view != null);
    }

    public int hashCode() {
        int result = this.params != null ? Arrays.hashCode(this.params) : 0;
        result = 31 * result + (this.design != null ? this.design.hashCode() : 0);
        result = 31 * result + (this.view != null ? this.view.hashCode() : 0);
        result = 31 * result + (this.development ? 1 : 0);
        result = 31 * result + (this.keysJson != null ? this.keysJson.hashCode() : 0);
        return result;
    }
}

