/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public final class BackpressureUtils {
    private BackpressureUtils() {
        throw new IllegalStateException("No instances!");
    }

    public static <T> long getAndAddRequest(AtomicLongFieldUpdater<T> requested, T object, long n) {
        long next;
        long current;
        while (!requested.compareAndSet(object, current = requested.get(object), next = BackpressureUtils.addCap(current, n))) {
        }
        return current;
    }

    public static long getAndAddRequest(AtomicLong requested, long n) {
        long next;
        long current;
        while (!requested.compareAndSet(current = requested.get(), next = BackpressureUtils.addCap(current, n))) {
        }
        return current;
    }

    public static long multiplyCap(long a, long b) {
        long u = a * b;
        if ((a | b) >>> 31 != 0L && b != 0L && u / b != a) {
            u = Long.MAX_VALUE;
        }
        return u;
    }

    public static long addCap(long a, long b) {
        long u = a + b;
        if (u < 0L) {
            u = Long.MAX_VALUE;
        }
        return u;
    }
}

