package org.gcube.contentmanager.storageclient.model.protocol.smp;


import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.blobstorage.service.impl.ServiceEngine;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;

/**
* 
* This is invoked by the platform with a URL of the right protocol.
* @author Fabio Simeoni (University of Strathclyde)
*
*/
public class SMPURLConnection extends URLConnection {

	
	Logger logger= Logger.getAnonymousLogger();
	/**
	 * Constructs a new instance for a given <code>sm</code> URL.
	 * @param url the URL.
	 */
	public SMPURLConnection(URL url) {
		super(url);
	}

	/**{@inheritDoc}*/
	@Override public synchronized void connect() throws IOException {
		
		try {
//			node = ReadManagerCall.get(url.toURI(),GCUBEScopeManager.DEFAULT.getScope());
			connected=true;
		}
		catch (Exception e) {
			IOException ioe = new IOException();
			ioe.initCause(e);
			throw ioe;
		}
		
	}
	
	/**{@inheritDoc}*/
	@Override public synchronized InputStream getInputStream() throws IOException {
		if (!connected) 
			this.connect(); 
		try {
			StringWriter w = new StringWriter();
		return storageClient(this.url.toString());			
		}
		catch(Exception e) {
			IOException ioe = new IOException();
			ioe.initCause(e);
			throw ioe;
		}			
	}
	

	private InputStream storageClient(String url) throws Exception {
		if(logger.isLoggable(Level.INFO))
			logger.info("url :" + url);
		String [] urlParam=url.split("\\?");
//		String param=urlParam[1];
		logger.info("String encrypted "+urlParam[1]);
		String param=new StringEncrypter("DES").decrypt(urlParam[1]);
		logger.info("String decrypted: "+param);
		String [] getParam=param.split("\\&");
		String serviceClass=null;
		String serviceName=null;
		String owner=null;
		String accessType=null;
		String scopeType=null;
		AccessType type = null;
		String server= null;
		String [] par1;
		for(String par : getParam){
			if(par.contains("ServiceClass")){
				par1=par.split("=");
				serviceClass=par1[1];
			}else if(par.contains("ServiceName")){
				par1=par.split("=");
				serviceName=par1[1];
			}else if(par.contains("owner")){
				par1=par.split("=");
				owner=par1[1];
			}else if(par.contains("scope")){
				par1=par.split("=");
				scopeType=par1[1];
			}else if(par.contains("server")){
				par1=par.split("=");
				server=par1[1];
			}else if(par.contains("AccessType")){
				par1=par.split("=");
				accessType=par1[1];			
				if(accessType.equalsIgnoreCase("public")){
					type=type.PUBLIC;
				}else if(accessType.equalsIgnoreCase("shared")){
					type=type.SHARED;
				}
			}else{
				;
			}
		}
		if((serviceName==null) || (serviceClass==null) || (owner == null) || (scopeType==null) || (type == null))
			throw new MalformedURLException();
		GCUBEScope scope=GCUBEScope.getScope(scopeType);
		String location=extractLocation(urlParam[0]);
		if(logger.isLoggable(Level.INFO))
			logger.info("IStanzio Storage con parametri "+serviceClass+" "+serviceName+" "+owner+" "+type+" "+scope+ " location: "+urlParam[0]);
		IClient client=new StorageClient(serviceClass, serviceName, owner, type, scope, server).getClient();
		InputStream is=null;
		is=client.get().RFileAStream(location);
//		createFileTest(is);
		return is;
	}

	private String extractLocation(String url) {
		String location=null;
		String [] loc=url.split("//");
		if(logger.isLoggable(Level.INFO))
			logger.info("url extracted: "+loc[1]);
		return loc[1];
	}

	private void createFileTest(InputStream is){
		// write the inputStream to a FileOutputStream
		OutputStream out = null;
		try {
			out = new FileOutputStream(new File("/home/rcirillo/FilePerTest/uriSMPTest.jpg"));
			int read = 0;
			byte[] bytes = new byte[1024];
 			while ((read = is.read(bytes)) != -1) {
				out.write(bytes, 0, read);
			}
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	 
		try {
			is.close();
			out.flush();
			out.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		if(logger.isLoggable(Level.INFO))
			logger.info("New file created!");
	}

}
