/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageclient.model.protocol;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.ArrayList;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.contentmanager.storageclient.model.protocol.smp.Handler;

public class URIs {
    public static final String PROTOCOL = "smp";

    public static void validate(URI uri) throws URISyntaxException {
        if (!PROTOCOL.equals(uri.getScheme()) || uri.getAuthority() == null || uri.getPath() == null || uri.getPath().length() < 2) {
            throw new IllegalArgumentException(new URISyntaxException(uri.toString(), "uri is not a well-formed content URI"));
        }
    }

    public static URI make(String collectionID, String ... identifiers) throws IllegalArgumentException {
        if (collectionID == null || identifiers == null || identifiers.length == 0) {
            throw new IllegalArgumentException("null or empty input");
        }
        StringBuilder path = new StringBuilder();
        for (String id : identifiers) {
            path.append("/" + id.toString());
        }
        URI uri = null;
        try {
            uri = new URI(PROTOCOL, collectionID, path.toString(), null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("error in generation uri with smp," + collectionID + "," + path, e);
        }
        return uri;
    }

    public static String collectionID(URI uri) throws URISyntaxException {
        URIs.validate(uri);
        return uri.getAuthority();
    }

    public static String documentID(URI uri) throws URISyntaxException {
        int index;
        URIs.validate(uri);
        String p = uri.getPath().substring(1);
        if (p.endsWith("/")) {
            p = p.substring(0, p.length() - 1);
        }
        return p.substring(0, (index = p.indexOf("/")) > 0 ? index : p.length());
    }

    public static String nodeID(URI uri) throws URISyntaxException {
        URIs.validate(uri);
        return uri.getPath().substring(uri.getPath().lastIndexOf("/") + 1);
    }

    public static String[] nodeIDs(URI uri) throws URISyntaxException {
        URIs.validate(uri);
        ArrayList<String> ids = new ArrayList<String>();
        for (String s : uri.getPath().substring(1).split("/")) {
            ids.add(s);
        }
        return ids.toArray(new String[0]);
    }

    public static URI parentURI(URI uri) throws URISyntaxException {
        URIs.validate(uri);
        String u = uri.getPath();
        return URIs.make(uri.getAuthority(), u.substring(1, u.lastIndexOf("/")).split("/"));
    }

    public static URI documentURI(URI uri) throws URISyntaxException {
        URIs.validate(uri);
        return URIs.make(uri.getAuthority(), URIs.documentID(uri));
    }

    public static URLConnection connection(URI uri, String scope) throws IOException, URISyntaxException {
        URIs.validate(uri);
        URLConnection connection = uri.toURL().openConnection();
        GCUBEScopeManager.DEFAULT.setScope(GCUBEScope.getScope((String)scope));
        return connection;
    }

    static {
        Handler.activateProtocol();
    }
}

