/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageclient.wrapper;

import java.security.Key;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.service.impl.ServiceEngine;
import org.gcube.contentmanager.storageclient.wrapper.ISClientConnector;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private String clientID;
    private String typeAccess;
    private String memoryType;
    private String owner;
    private String scopeString;
    private String server;
    private String environment;
    private String sc;
    private String sn;
    private String user;
    private String password;
    private String passPhrase;
    private ISClientConnector isclient;
    private String RRScope;
    private String backendType;
    private String[] volatileHost;
    private String[] persistentHosts;
    private String resolverHost;
    private static final Logger logger = LoggerFactory.getLogger(Configuration.class);
    private static final String DEFAULT_BACKEND_TYPE = "MongoDB";
    private static final String WRITE_CONCERN_PROPERTY_NAME = "write_concern";
    private static final String READ_PREFERENCE_PROPERTY_NAME = "read_preference";
    private static final String DB_PROPERTY_NAME = "collection";
    private static final String DB_STRING_SEPARATOR = ";";
    private static final String HOME_LIBRARY_SERVICE_CLASS = "org.gcube.portlets.user";
    private static final String HOME_LIBRARY_SERVICE_NAME_DEV = "test-home-library";
    private static final String HOME_LIBRARY_SERVICE_NAME_PROD = "home-library";
    private static final String HL_CONTEXT = "/d4science.research-infrastructures.eu";
    private static final String HL_CONTEXT_DEV = "/gcube";
    private static final String HL_CONTEXT_PRE = "/pred4s";

    public Configuration(String sc, String sn, String scopeString, String owner, String clientID, String accessType, String memory) {
        this.sc = sc;
        this.sn = sn;
        this.owner = owner;
        this.clientID = clientID;
        this.typeAccess = accessType;
        this.memoryType = memory;
        this.setScopeString(scopeString);
    }

    public void getConfiguration() {
        String[] newServer = null;
        String currentScope = ScopeProvider.instance.get();
        logger.debug("Scope found on ScopeProvider instance is " + currentScope);
        if (this.RRScope == null) {
            this.RRScope = currentScope;
        }
        logger.debug("RuntimeResource scope " + this.RRScope);
        ServiceEndpoint resource = this.getISClient().getStorageEndpoint(this.RRScope);
        if (resource == null) {
            throw new IllegalStateException("the storage resource is not present on IS in scope: " + this.RRScope);
        }
        List<ServiceEndpoint> resolverResource = this.getISClient().getServiceEndpoint("Service", "HTTP-URI-Resolver");
        if (resolverResource == null || resolverResource.size() <= 0) {
            throw new IllegalStateException("the uri resolver resource is not present on IS in scope: " + currentScope);
        }
        this.setResolverHost(this.getISClient().getResolverHost(resolverResource.get(0)));
        if (this.server == null) {
            logger.debug("server not set. Try to query IS in scope: " + this.scopeString);
            String[] serverFound = Configuration.checkVarEnvMongo();
            if (serverFound == null) {
                serverFound = this.getISClient().retrieveConnectionInfo(resource);
                this.setUser(this.getISClient().getUsername());
                this.setPassword(this.getISClient().password);
                this.setBackendType(this.getISClient().getBackendType(resource));
            } else {
                this.setBackendType(Configuration.checkVarEnvBackendType());
                if (this.getBackendType() == null) {
                    this.setBackendType(DEFAULT_BACKEND_TYPE);
                }
                this.setUser(Configuration.checkVarEnvUser());
                this.setPassword(Configuration.checkVarEnvPassword());
            }
            newServer = serverFound;
        } else {
            String[] serverPassed;
            logger.debug("server found: " + this.server);
            newServer = serverPassed = new String[]{this.server};
            if (this.getBackendType() == null) {
                this.setBackendType(DEFAULT_BACKEND_TYPE);
            }
        }
        if (newServer == null) {
            throw new IllegalStateException("Resource not found on Information System");
        }
        this.setEnvironment(this.setAreaStorage(this.getSc(), this.getSn()));
        this.setServerHosts(newServer, this.isclient, resource);
        try {
            this.setPassPhrase(this.retrieveEncryptionPhrase());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setServerHosts(String[] newServer, ISClientConnector isclient, ServiceEndpoint resource) {
        if (this.getMemoryType() != null && (this.getMemoryType().equals(MemoryType.VOLATILE.toString()) || this.getMemoryType().equals(MemoryType.BOTH.toString()))) {
            this.setVolatileHost(isclient.getVolatileHost(resource));
            logger.info("backend host is the volatile server" + this.volatileHost[0]);
        }
        this.setPersistentHosts(newServer);
    }

    private String setAreaStorage(String sc, String sn) {
        String area = null;
        if (this.isHomeLibrary(sc, sn)) {
            return this.getHomeLibraryContext();
        }
        area = this.memoryType != null && this.memoryType.equals(MemoryType.VOLATILE.toString()) ? "VOLATILE" + this.scopeString + this.clientID : this.scopeString + this.clientID;
        return area;
    }

    private boolean isHomeLibrary(String sc, String sn) {
        return sc.equals(HOME_LIBRARY_SERVICE_CLASS) && sn.equals(HOME_LIBRARY_SERVICE_NAME_DEV) || sc.equals(HOME_LIBRARY_SERVICE_CLASS) && sn.equals(HOME_LIBRARY_SERVICE_NAME_PROD);
    }

    private String getHomeLibraryContext() {
        String area = null;
        String scope = ScopeProvider.instance.get();
        String context = null;
        if (scope.startsWith(HL_CONTEXT_DEV)) {
            context = HL_CONTEXT_DEV;
        } else if (scope.startsWith(HL_CONTEXT_PRE)) {
            context = HL_CONTEXT_PRE;
        } else if (scope.startsWith(HL_CONTEXT)) {
            context = HL_CONTEXT;
        } else {
            throw new RuntimeException("Unrecognized scope: " + scope);
        }
        area = context + this.clientID;
        if (this.getMemoryType() != null && this.getMemoryType().equals(MemoryType.VOLATILE.toString())) {
            area = "VOLATILE" + area;
        }
        return area;
    }

    protected void getOptionalPropertiesFromRR(String currentScope, ServiceEngine engine) {
        String write = null;
        String read = null;
        String[] dbNames = null;
        String dbString = null;
        if (this.getMemoryType() != null && !this.getMemoryType().equals(MemoryType.VOLATILE.toString())) {
            write = this.getISClient().retrievePropertyValue(WRITE_CONCERN_PROPERTY_NAME, currentScope);
            logger.debug("read preference: read from service endpoint");
            read = this.getISClient().retrievePropertyValue(READ_PREFERENCE_PROPERTY_NAME, currentScope);
            logger.debug(" write preference: read from service endpoint");
            dbString = this.getISClient().retrievePropertyValue(DB_PROPERTY_NAME, currentScope);
            if (write != null && read != null) {
                engine.setWriteConcern(write);
                engine.setReadConcern(read);
            }
            if (dbString != null) {
                if (dbString.contains(DB_STRING_SEPARATOR)) {
                    logger.debug("more than one collection read from ServiceEnpoint");
                    dbNames = dbString.split(DB_STRING_SEPARATOR);
                } else {
                    dbNames = new String[]{dbString};
                }
                if (dbNames.length > 1) {
                    logger.debug("multiple collection discovered");
                }
                engine.setDbNames(dbNames);
            }
        } else if (this.getMemoryType().equals(MemoryType.VOLATILE.toString()) && (dbString = this.getISClient().retrievePropertyValue(DB_PROPERTY_NAME, currentScope)) != null) {
            if (dbString.contains(DB_STRING_SEPARATOR)) {
                logger.debug("more than one collection read from ServiceEnpoint");
                dbNames = dbString.split(DB_STRING_SEPARATOR);
            } else {
                dbNames = new String[]{dbString};
            }
            if (dbNames.length > 1) {
                logger.debug("multiple collection discovered");
            }
            engine.setDbNames(dbNames);
        }
    }

    private static String[] checkVarEnvMongo() {
        Map<String, String> env = System.getenv();
        TreeSet<String> keys = new TreeSet<String>(env.keySet());
        Iterator<String> iter = keys.iterator();
        String server = null;
        while (iter.hasNext()) {
            String key = iter.next();
            if (!key.equalsIgnoreCase("STORAGE_MANAGER_MONGO_SERVER")) continue;
            server = env.get(key);
            break;
        }
        if (server != null) {
            String[] servers = new String[]{server};
            return servers;
        }
        return null;
    }

    private static String checkVarEnvBackendType() {
        Map<String, String> env = System.getenv();
        TreeSet<String> keys = new TreeSet<String>(env.keySet());
        Iterator<String> iter = keys.iterator();
        String type = null;
        while (iter.hasNext()) {
            String key = iter.next();
            if (!key.equalsIgnoreCase("STORAGE_MANAGER_BACKEND_TYPE")) continue;
            type = env.get(key);
            break;
        }
        if (type != null) {
            return type;
        }
        return null;
    }

    private static String checkVarEnvUser() {
        Map<String, String> env = System.getenv();
        TreeSet<String> keys = new TreeSet<String>(env.keySet());
        Iterator<String> iter = keys.iterator();
        String type = null;
        while (iter.hasNext()) {
            String key = iter.next();
            if (!key.equalsIgnoreCase("STORAGE_MANAGER_USER")) continue;
            type = env.get(key);
            break;
        }
        if (type != null) {
            return type;
        }
        return null;
    }

    private static String checkVarEnvPassword() {
        Map<String, String> env = System.getenv();
        TreeSet<String> keys = new TreeSet<String>(env.keySet());
        Iterator<String> iter = keys.iterator();
        String type = null;
        while (iter.hasNext()) {
            String key = iter.next();
            if (!key.equalsIgnoreCase("STORAGE_MANAGER_PASSWORD")) continue;
            type = env.get(key);
            break;
        }
        if (type != null) {
            return type;
        }
        return null;
    }

    public String retrieveEncryptionPhrase() throws Exception {
        String currentScope = ScopeProvider.instance.get();
        logger.debug("retrieve encryption prhase on scope: " + currentScope);
        String encryptedKey = null;
        logger.info("retrieve encryption phrase from scope " + currentScope);
        encryptedKey = this.getISClient().retrievePropertyValue("PassPhrase", currentScope);
        logger.info("encrypted prhase is " + encryptedKey);
        String decryptString = StringEncrypter.getEncrypter().decrypt(encryptedKey, new Key[0]);
        logger.debug("String decrypted");
        if (decryptString != null && decryptString.length() > 0) {
            logger.debug("String decrypted");
        } else {
            logger.warn("decryption result is null");
        }
        return decryptString;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public String getTypeAccess() {
        return this.typeAccess.toString();
    }

    public void setTypeAccess(String typeAccess) {
        this.typeAccess = typeAccess;
    }

    public String getMemoryType() {
        return this.memoryType.toString();
    }

    public void setMemoryType(String memoryType) {
        this.memoryType = memoryType;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String server) {
        this.environment = server;
    }

    public String getScopeString() {
        return this.scopeString;
    }

    public void setScopeString(String scopeString) {
        this.scopeString = scopeString;
    }

    public String getRRScope() {
        return this.RRScope;
    }

    public void setRRScope(String rRScope) {
        this.RRScope = rRScope;
    }

    public String getBackendType() {
        return this.backendType;
    }

    public void setBackendType(String backendType) {
        this.backendType = backendType;
    }

    public String[] getVolatileHost() {
        return this.volatileHost;
    }

    public void setVolatileHost(String[] volatileHost) {
        this.volatileHost = volatileHost;
    }

    public String[] getPersistentHosts() {
        return this.persistentHosts;
    }

    public void setPersistentHosts(String[] hosts) {
        this.persistentHosts = hosts;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassPhrase() {
        return this.passPhrase;
    }

    public void setPassPhrase(String passPhrase) {
        logger.debug("passPhrase set");
        this.passPhrase = passPhrase;
    }

    public String getResolverHost() {
        return this.resolverHost;
    }

    public void setResolverHost(String resolverHost) {
        this.resolverHost = resolverHost;
    }

    public ISClientConnector getISClient() {
        if (this.isclient == null) {
            this.isclient = new ISClientConnector();
        }
        return this.isclient;
    }

    public String getSc() {
        return this.sc;
    }

    public void setSc(String sc) {
        this.sc = sc;
    }

    public String getSn() {
        return this.sn;
    }

    public void setSn(String sn) {
        this.sn = sn;
    }
}

