/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageclient.wrapper;

import java.util.Objects;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.blobstorage.service.impl.ServiceEngine;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.BackendType;
import org.gcube.contentmanager.storageclient.wrapper.Configuration;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageClient {
    private String clientID;
    private AccessType typeAccess;
    private MemoryType memoryType;
    private String serviceClass;
    private String serviceName;
    private String owner;
    private String server;
    private String scopeString;
    private String currentScope;
    private String backendType;
    private String volatileHost;
    private String RRScope;
    private static final Logger logger = LoggerFactory.getLogger(StorageClient.class);
    private static final String DEFAULT_SERVICE_CLASS = "ExternalApplication";
    private static final String DEFAULT_SERVICE_NAME = "Default";
    private static final MemoryType DEFAULT_MEMORY_TYPE = MemoryType.PERSISTENT;

    public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType) {
        String id = owner;
        this.owner = owner;
        this.scopeString = SecretManagerProvider.instance.get().getContext();
        if (accessType == null) {
            throw new RuntimeException("AccessType parameter must be not null");
        }
        this.typeAccess = accessType;
        this.memoryType = MemoryType.BOTH;
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        this.setClientId(serviceClass, serviceName, id);
    }

    public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, BackendType backend) {
        String id = owner;
        this.owner = owner;
        this.scopeString = SecretManagerProvider.instance.get().getContext();
        if (accessType == null) {
            throw new RuntimeException("AccessType parameter must be not null");
        }
        this.typeAccess = accessType;
        this.memoryType = MemoryType.BOTH;
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        this.setBackendType(backend.toString());
        this.setClientId(serviceClass, serviceName, id);
    }

    public StorageClient(String owner, AccessType accessType, MemoryType memory) {
        String id = owner;
        this.owner = owner;
        this.scopeString = SecretManagerProvider.instance.get().getContext();
        if (accessType == null) {
            throw new RuntimeException("AccessType parameter must be not null");
        }
        this.typeAccess = accessType;
        if (memory == null) {
            throw new RuntimeException("MemoryType parameter must be not null");
        }
        this.memoryType = memory;
        this.serviceClass = DEFAULT_SERVICE_CLASS;
        this.serviceName = DEFAULT_SERVICE_NAME;
        this.setClientId(this.serviceClass, this.serviceName, id);
    }

    public StorageClient(String serviceClass, String serviceName, String owner, String server, AccessType accessType) {
        String id = owner;
        this.owner = owner;
        this.scopeString = SecretManagerProvider.instance.get().getContext();
        if (accessType == null) {
            throw new RuntimeException("AccessType parameter must be not null");
        }
        this.typeAccess = accessType;
        this.memoryType = MemoryType.BOTH;
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        this.server = server;
        this.memoryType = DEFAULT_MEMORY_TYPE;
        this.setClientId(serviceClass, serviceName, id);
    }

    public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, MemoryType memory) {
        String id = owner;
        this.owner = owner;
        this.scopeString = SecretManagerProvider.instance.get().getContext();
        if (accessType == null) {
            throw new RuntimeException("AccessType parameter must be not null");
        }
        this.typeAccess = accessType;
        if (memory == null) {
            throw new RuntimeException("MemoryType parameter must be not null");
        }
        this.memoryType = memory;
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        this.setClientId(serviceClass, serviceName, id);
    }

    public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, MemoryType memory, BackendType backend) {
        String id = owner;
        this.owner = owner;
        this.scopeString = SecretManagerProvider.instance.get().getContext();
        if (accessType == null) {
            throw new RuntimeException("AccessType parameter must be not null");
        }
        this.typeAccess = accessType;
        if (memory == null) {
            throw new RuntimeException("MemoryType parameter must be not null");
        }
        this.memoryType = memory;
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        this.setClientId(serviceClass, serviceName, id);
        this.setBackendType(backend.toString());
    }

    public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, MemoryType memory, String server) {
        String id = owner;
        this.owner = owner;
        this.scopeString = SecretManagerProvider.instance.get().getContext();
        if (accessType == null) {
            throw new RuntimeException("AccessType parameter must be not null");
        }
        this.typeAccess = accessType;
        if (this.memoryType == null) {
            throw new RuntimeException("MemoryType parameter must be not null");
        }
        this.memoryType = memory;
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        this.server = server;
        this.setClientId(serviceClass, serviceName, id);
    }

    public IClient getClient() {
        Configuration cfg = null;
        cfg = Objects.isNull(this.getBackendType()) ? new Configuration(this.serviceClass, this.serviceName, this.scopeString, this.owner, this.clientID, this.typeAccess.toString(), this.memoryType.toString()) : new Configuration(this.serviceClass, this.serviceName, this.scopeString, this.owner, this.clientID, this.typeAccess.toString(), this.memoryType.toString(), this.getBackendType());
        cfg.getConfiguration();
        ServiceEngine engine = new ServiceEngine(cfg.getPersistentHosts(), cfg.getVolatileHost(), cfg.getEnvironment(), cfg.getTypeAccess(), cfg.getOwner(), cfg.getMemoryType());
        engine.setServiceClass(this.getServiceClass());
        engine.setServiceName(this.getServiceName());
        engine.setGcubeAccessType(this.getTypeAccess().toString());
        engine.setBackendType(this.getBackendType());
        engine.setBackendUser(cfg.getUser());
        engine.setBackendPassword(cfg.getPassword());
        engine.setResolverHost(cfg.getResolverHost());
        engine.setRegion(cfg.getRegion());
        if (cfg.getPassPhrase() != null) {
            engine.setPassPhrase(cfg.getPassPhrase());
            engine.setToken(cfg.getPassPhrase());
        }
        if (this.getMemoryType() != null) {
            engine.setGcubeMemoryType(this.getMemoryType().toString());
        }
        engine.setGcubeScope(SecretManagerProvider.instance.get().getContext());
        engine.setOwnerGcube(this.owner);
        cfg.getOptionalPropertiesFromRR(engine);
        if (this.getCurrentScope() != null && !this.getCurrentScope().equals(SecretManagerProvider.instance.get().getContext())) {
            logger.warn("scope force to " + this.getCurrentScope() + "doesn't take effect. The current scope is set to" + SecretManagerProvider.instance.get().getContext());
        }
        return engine;
    }

    private void setClientId(String serviceClass, String serviceName, String id) {
        if (this.typeAccess == AccessType.PUBLIC) {
            this.clientID = "";
        } else if (this.typeAccess == AccessType.PRIVATE) {
            this.clientID = "/home/" + serviceClass + "/" + serviceName + "/" + id;
        } else if (this.typeAccess == AccessType.SHARED) {
            this.clientID = "/home/" + serviceClass + "/" + serviceName;
        } else {
            throw new IllegalArgumentException("type is not correctly: public, private or shared");
        }
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public AccessType getTypeAccess() {
        return this.typeAccess;
    }

    public void setTypeAccess(AccessType typeAccess) {
        this.typeAccess = typeAccess;
    }

    public MemoryType getMemoryType() {
        return this.memoryType;
    }

    public void setMemoryType(MemoryType memoryType) {
        this.memoryType = memoryType;
    }

    public String getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(String serviceClass) {
        this.serviceClass = serviceClass;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getScopeString() {
        return this.scopeString;
    }

    public void setScopeString(String scopeString) {
        this.scopeString = scopeString;
    }

    public String getCurrentScope() {
        return this.currentScope;
    }

    public void setCurrentScope(String currentScope) {
        this.currentScope = currentScope;
    }

    public String getBackendType() {
        if (Objects.isNull(this.backendType)) {
            this.backendType = "MongoDB";
        }
        logger.debug("backend type returned is " + this.backendType);
        return this.backendType;
    }

    public void setBackendType(String backendType) {
        this.backendType = backendType;
    }

    public String getVolatileHost() {
        return this.volatileHost;
    }

    public void setVolatileHost(String volatileHost) {
        this.volatileHost = volatileHost;
    }

    public String getRRScope() {
        return this.RRScope;
    }

    public void setRRScope(String rRScope) {
        this.RRScope = rRScope;
    }
}

