/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import java.util.Vector;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.operation.ChunkProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Monitor {
    final Logger logger = LoggerFactory.getLogger(Monitor.class);
    private Vector<MyFile> requestQueue = new Vector();

    public synchronized MyFile getRequest() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getRequest() - start");
        }
        while (this.requestQueue.size() == 0) {
            try {
                this.wait(10000L);
            }
            catch (InterruptedException e) {
                this.logger.error("getRequest()", e);
            }
        }
        MyFile myFile = this.requestQueue.remove(0);
        this.notifyAll();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getRequest() - end");
        }
        return myFile;
    }

    public synchronized MyFile getRequest(ChunkProducer producer) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getRequest(ChunkProducer) - start");
        }
        while (this.requestQueue.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                this.logger.error("getRequest(ChunkProducer)", e);
            }
        }
        MyFile myFile = this.requestQueue.remove(0);
        this.notifyAll();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getRequest(ChunkProducer) - end");
        }
        return myFile;
    }

    public synchronized void putRequest(MyFile richiesta) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("putRequest(MyFile) - start");
            this.logger.debug("request in queue, queue size: " + this.requestQueue.size());
        }
        while (this.requestQueue.size() > 10) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                this.logger.error("putRequest(MyFile)", e);
            }
        }
        this.requestQueue.addElement(richiesta);
        this.notifyAll();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("putRequest(MyFile) - end");
        }
    }
}

