/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.baselayer.networkFileTransfer;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.HttpsURL;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.contentmanagement.baselayer.BaseLayerStream;
import org.gcube.contentmanagement.baselayer.BaseLayerUtils;
import org.gcube.contentmanagement.baselayer.InstantiableManager;
import org.gcube.contentmanagement.baselayer.RawContentLocation;
import org.gcube.contentmanagement.baselayer.RawFileContentManager;
import org.gcube.contentmanagement.baselayer.exceptions.BaseLayerException;
import org.gcube.contentmanagement.baselayer.exceptions.TemporaryUnavailableException;
import org.gcube.contentmanagement.baselayer.exceptions.ValueNotValidException;
import org.gcube.contentmanagement.baselayer.networkFileTransfer.HTTPPseudoContentManager;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicStorageHints;

public class CommonsHTTPClientPseudeContentManager
implements RawFileContentManager,
InstantiableManager {
    public static final String HTTP_RESPONSE_HEADER_ELEMENT_CONTENT_LENGTH = "Content-Length";
    public static final String HTTP_RESPONSE_HEADER_TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String HTTP_RESPONSE_HEADER_ELEMENT_CONTENT_TYPE = "Content-Type";
    static final String HTTP_PREFIX = "http://";
    static final String HTTPS_PREFIX = "https://";
    static final String DATA_PROVIDER_PREFIX = "http://";
    final String URL_PREFIX;
    private static final Log log = LogFactory.getLog(HTTPPseudoContentManager.class);

    public static String getDataProviderPrefix() {
        return "http://";
    }

    public CommonsHTTPClientPseudeContentManager(String managedURL) {
        this.URL_PREFIX = managedURL;
    }

    URI getURLFor(String uniqueStorageID) throws ValueNotValidException {
        if (uniqueStorageID == null) {
            throw new ValueNotValidException("Storage location may not be null.", uniqueStorageID, "contentmanagement:location");
        }
        try {
            if (this.URL_PREFIX != null && !this.URL_PREFIX.equals("") && !uniqueStorageID.startsWith(this.URL_PREFIX)) {
                uniqueStorageID = this.URL_PREFIX + uniqueStorageID;
            }
            if (uniqueStorageID.startsWith(HTTPS_PREFIX)) {
                return new HttpsURL(uniqueStorageID);
            }
            return new HttpURL(uniqueStorageID);
        }
        catch (URIException e) {
            log.error((Object)e);
            throw new ValueNotValidException("Malformed URL as storage location.", uniqueStorageID, "contentmanagement:location");
        }
    }

    public RawContentLocation saveBinaryContent(String uniqueStorageID, BaseLayerStream binaryFileContent, BasicStorageHints hints) throws BaseLayerException {
        log.warn((Object)"saveBinaryContent is not supported in pseudo content manager");
        throw new UnsupportedOperationException("Cannot delete remote content.");
    }

    public BaseLayerStream getBinaryContent(RawContentLocation location, BasicStorageHints hints) throws BaseLayerException {
        GetMethod method;
        URI u = this.getURLFor(location.getContentID());
        Credentials cred = this.getCredentials(hints);
        HttpClient client = new HttpClient();
        String requestedMethod = hints.getHintValue("access-method", "GET");
        if ("GET".equals(requestedMethod)) {
            method = new GetMethod();
        } else if ("POST".equals(requestedMethod)) {
            method = new PostMethod();
        } else {
            throw new ValueNotValidException("The requested access method is not supported.", requestedMethod, "access-method");
        }
        method.setFollowRedirects(true);
        try {
            Header contLength;
            if (cred != null) {
                client.getState().setCredentials(null, u.getURI(), cred);
                method.setDoAuthentication(true);
            } else {
                method.setDoAuthentication(false);
            }
            HostConfiguration hc = new HostConfiguration();
            hc.setHost(u);
            int status = client.executeMethod((HttpMethod)method);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Request to " + u.getURI() + " returned " + status + "."));
            }
            if (status >= 400) {
                log.warn((Object)("Recieved response indicating unavailablity of content: " + status));
            }
            if (status == 503 || status == 504) {
                throw new TemporaryUnavailableException("Received HTTP error status " + status + " when trying to access " + location.getContentID() + ", which might be recoverable with time.");
            }
            long length = -1L;
            if (method.getResponseHeader(HTTP_RESPONSE_HEADER_TRANSFER_ENCODING) != null && (contLength = method.getResponseHeader(HTTP_RESPONSE_HEADER_ELEMENT_CONTENT_LENGTH)) != null) {
                try {
                    long l = Long.parseLong(contLength.getValue());
                    if (l >= 0L) {
                        length = l;
                    } else {
                        log.debug((Object)"Recieved negative content length - ignoring.");
                    }
                }
                catch (NumberFormatException nfe) {
                    log.debug((Object)("Recieved invalid of content length=" + contLength.getValue()), (Throwable)nfe);
                }
            }
            InputStream is = method.getResponseBodyAsStream();
            if (!hints.hasHint("content-mime-type") && BaseLayerUtils.requestsFor("guess-content-mime-type", hints)) {
                String mimeType;
                Header contType = method.getResponseHeader(HTTP_RESPONSE_HEADER_ELEMENT_CONTENT_TYPE);
                BaseLayerUtils.consumeHint("guess-content-mime-type", hints);
                if (contType != null && (mimeType = contType.getValue()) != null && !"content/unknown".equals(mimeType)) {
                    hints.addHint("content-mime-type", mimeType);
                }
            }
            if (length == -1L) {
                return new BaseLayerStream(is);
            }
            return new BaseLayerStream(is, length);
        }
        catch (IOException ioe) {
            log.error((Object)ioe);
            throw new BaseLayerException("Error in data access.", ioe);
        }
    }

    private Credentials getCredentials(BasicStorageHints hints) {
        UsernamePasswordCredentials cred = null;
        String user = null;
        String pass = null;
        if (hints.hasHint("user")) {
            user = hints.getHintValue("user");
            hints.markHint("user", true);
        }
        if (hints.hasHint("passwd")) {
            pass = hints.getHintValue("passwd");
            hints.markHint("passwd", true);
        }
        if (user != null || pass != null) {
            cred = new UsernamePasswordCredentials(user, pass);
        }
        return cred;
    }

    public boolean deleteBinaryContent(RawContentLocation location, BasicStorageHints hints) throws BaseLayerException {
        log.warn((Object)"deleteBinaryContent is not supported in pseudo content manager");
        throw new UnsupportedOperationException("Cannot delete remote content.");
    }

    public boolean existsBinaryContent(RawContentLocation location, BasicStorageHints hints) throws BaseLayerException {
        URI u = this.getURLFor(location.getContentID());
        HeadMethod method = new HeadMethod();
        method.setFollowRedirects(true);
        Credentials cred = this.getCredentials(hints);
        HttpClient client = new HttpClient();
        try {
            if (cred != null) {
                client.getState().setCredentials(null, u.getURI(), cred);
                method.setDoAuthentication(true);
            } else {
                method.setDoAuthentication(false);
            }
            HostConfiguration hc = new HostConfiguration();
            hc.setHost(u);
            int status = client.executeMethod((HttpMethod)method);
            return status < 400;
        }
        catch (FileNotFoundException fnf) {
            return false;
        }
        catch (IOException ioe) {
            log.error((Object)ioe);
            throw new BaseLayerException("Error in data access.", ioe);
        }
    }

    public boolean handles(String dataprovider) {
        if (this.URL_PREFIX == null || this.URL_PREFIX == "") {
            return dataprovider.startsWith("http://") || dataprovider.startsWith(HTTPS_PREFIX);
        }
        if (!dataprovider.startsWith(CommonsHTTPClientPseudeContentManager.getDataProviderPrefix())) {
            return false;
        }
        if (dataprovider.startsWith(this.getDataProvider())) {
            return true;
        }
        String newProvider = CommonsHTTPClientPseudeContentManager.getDataProviderPrefix() + BaseLayerUtils.removeProtocolUsernamePasswordFromURL(dataprovider);
        return newProvider.startsWith(this.getDataProvider());
    }

    public String getDataProvider() {
        if (this.URL_PREFIX == null || this.URL_PREFIX == "") {
            return "http://";
        }
        return this.URL_PREFIX;
    }

    public boolean supportsAppending() {
        return false;
    }

    public RawContentLocation makePermanentLocation(RawContentLocation currentLocation, BasicStorageHints hints) throws ValueNotValidException {
        StringBuffer newURL = new StringBuffer(CommonsHTTPClientPseudeContentManager.getDataProviderPrefix());
        if (hints.hasHint("user")) {
            newURL.append(hints.getHintValue("user"));
            if (hints.hasHint("passwd")) {
                newURL.append(':');
                newURL.append(hints.getHintValue("passwd"));
            }
            newURL.append('@');
        }
        newURL.append(BaseLayerUtils.removeProtocolUsernamePasswordFromURL(currentLocation.getContentID()));
        return new RawContentLocation(this.getDataProvider(), newURL.toString());
    }

    public static HTTPPseudoContentManager getManagerInstance(String[] params, String managerName) throws BaseLayerException {
        if (params.length > 0) {
            return new HTTPPseudoContentManager(params[0]);
        }
        return new HTTPPseudoContentManager("");
    }

    public String getUniqueStorageLocationIDFor(String objectID) {
        return objectID;
    }
}

