/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.baselayer.networkFileTransfer;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.log4j.Logger;
import org.bouncycastle.util.Arrays;

public class StreamUtils {
    private static final Logger log = Logger.getLogger((String)StreamUtils.class.getName());

    public static void copy(File inFile, File outFile) throws IOException {
        FileInputStream in = new FileInputStream(inFile);
        FileOutputStream out = new FileOutputStream(outFile);
        StreamUtils.copy(in, out, 0L, inFile.length());
    }

    public static void extractPart(File inFile, File outFile, long offset, long length) throws IOException {
        FileInputStream in = new FileInputStream(inFile);
        FileOutputStream out = new FileOutputStream(outFile);
        StreamUtils.copy(in, out, offset, length);
    }

    public static void copy(InputStream in, OutputStream out, long offset, long length) throws IOException {
        if (offset != in.skip(offset)) {
            throw new IOException("Offset inconsistency");
        }
        byte[] buf = new byte[256];
        int read = -1;
        long toCopy = length;
        while ((read = in.read(buf)) != -1 & toCopy > 0L) {
            if (toCopy >= (long)read) {
                out.write(buf, 0, read);
                toCopy -= (long)read;
                continue;
            }
            out.write(buf, 0, (int)toCopy);
            toCopy -= toCopy;
        }
        out.flush();
        out.close();
        in.close();
    }

    public static void copy(InputStream in, OutputStream out, long offset) throws IOException {
        if (offset != in.skip(offset)) {
            throw new IOException("Offset inconsistency");
        }
        byte[] buf = new byte[256];
        int read = -1;
        long byteCount = 0L;
        while ((read = in.read(buf)) != -1) {
            out.write(buf, 0, read);
            byteCount += (long)read;
        }
        out.flush();
        out.close();
        in.close();
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        StreamUtils.copy(in, out, 0L);
    }

    public static boolean areEqual(InputStream in1, InputStream in2) throws IOException {
        byte[] buf1 = new byte[256];
        byte[] buf2 = new byte[256];
        int read = -1;
        boolean areEqual = true;
        while ((read = in1.read(buf1)) != -1) {
            if (in2.available() < read) {
                areEqual = false;
                break;
            }
            in2.read(buf2);
            if (Arrays.areEqual((byte[])buf1, (byte[])buf2)) continue;
            areEqual = false;
            break;
        }
        if (in2.available() != 0) {
            areEqual = false;
        }
        in1.close();
        in2.close();
        return areEqual;
    }

    public static void copy(Reader in, Writer out, int offset) throws IOException {
        in = new BufferedReader(in);
        out = new BufferedWriter(out);
        if ((long)offset != in.skip(offset)) {
            throw new IOException("Offset inconsistency");
        }
        char[] buf = new char[256];
        int read = -1;
        long byteCount = 0L;
        while ((read = in.read(buf)) != -1) {
            out.write(buf, 0, read);
            byteCount += (long)read;
        }
        out.flush();
        out.close();
        in.close();
    }

    public static void copyToFile(InputStream in, File f) throws IOException {
        FileOutputStream out = new FileOutputStream(f);
        StreamUtils.copy(in, out, 0L);
    }

    public static void appendTo(File file, File newContent) throws IOException {
        FileInputStream in = new FileInputStream(newContent);
        FileOutputStream out = new FileOutputStream(file, true);
        StreamUtils.copy(in, out, 0L);
    }

    public static void copyFromFile(File f, OutputStream out) throws IOException {
        FileInputStream in = new FileInputStream(f);
        StreamUtils.copy(in, out, 0L);
    }

    public static String stringFromFile(File f, Charset encoding) throws IOException {
        StringWriter writer = new StringWriter();
        StreamUtils.copy(new InputStreamReader((InputStream)new FileInputStream(f), encoding), writer, 0);
        return writer.toString();
    }
}

