/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.util.remotefile.protocols.url.http;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.gcube.contentmanagement.util.logging.LoggingConfigurator;
import org.gcube.contentmanagement.util.stream.StreamUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPCommunicator {
    HttpURLConnection hpcon = null;
    static int DEFAULT_CHUNKSIZE = 0x500000;

    private static Logger getLog() {
        return LoggingConfigurator.getLogger(HTTPCommunicator.class);
    }

    static HttpURLConnection getConnection(URL url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDefaultUseCaches(false);
        conn.setUseCaches(false);
        conn.setRequestProperty("User-Agent", "Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.9.0.1) Gecko/2008072820 Firefox/3.0.1");
        return conn;
    }

    public static HashMap<String, String> extractParameters(String urlAndParameters) throws UnsupportedEncodingException {
        int parStart = urlAndParameters.indexOf("?");
        if (parStart != -1) {
            return HTTPCommunicator.decodeParameters(urlAndParameters.substring(parStart + 1));
        }
        return new HashMap<String, String>();
    }

    public static HashMap<String, String> decodeParameters(String parameters) throws UnsupportedEncodingException {
        String[] pairs = parameters.split("\\&");
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < pairs.length; ++i) {
            String[] fields = pairs[i].split("=");
            String name = URLDecoder.decode(fields[0], "UTF-8");
            String value = "";
            if (fields.length == 2) {
                value = URLDecoder.decode(fields[1], "UTF-8");
            }
            result.put(name, value);
        }
        return result;
    }

    private static String encodeParameters(HashMap<String, String> values) throws UnsupportedEncodingException {
        String parameters = "";
        Iterator<Map.Entry<String, String>> i = values.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, String> entry = i.next();
            parameters = parameters + URLEncoder.encode(entry.getKey(), "UTF-8") + "=" + URLEncoder.encode(entry.getValue(), "UTF-8");
            if (!i.hasNext()) continue;
            parameters = parameters + "&";
        }
        return parameters;
    }

    public static boolean resourceExist(URL url) {
        try {
            HttpURLConnection conn = HTTPCommunicator.getConnection(url);
            conn.setRequestMethod("HEAD");
            conn.connect();
            int responseCode = conn.getResponseCode();
            if (responseCode == 404) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HTTPHeader getHeader(URL url) throws IOException {
        HttpURLConnection conn = HTTPCommunicator.getConnection(url);
        try {
            conn.setRequestMethod("HEAD");
            conn.connect();
            HTTPHeader hTTPHeader = new HTTPHeader(conn.getHeaderFields());
            return hTTPHeader;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static void retrieve(URL url, File f) throws IOException {
        HTTPHeader header = HTTPCommunicator.getHeader(url);
        boolean tryMulti = true;
        HTTPCommunicator.getLog().info(header.getField("Accept-Ranges"));
        if (header.getField("Accept-Ranges") != null && header.getField("Accept-Ranges").contains("none")) {
            HTTPCommunicator.getLog().info((Object)"Server does not accept range-requests");
            tryMulti = false;
        }
        long length = -1L;
        if (header.getContentLength() == null) {
            HTTPCommunicator.getLog().info((Object)"Cannot determine content length");
            tryMulti = false;
        } else {
            length = header.getContentLength();
            if (length < (long)DEFAULT_CHUNKSIZE) {
                HTTPCommunicator.getLog().info((Object)("Content length (" + length + ") less than default chunksize (" + DEFAULT_CHUNKSIZE + ")"));
                tryMulti = false;
            }
        }
        if (!tryMulti) {
            HTTPCommunicator.retrieveSingleThreaded(url, f);
        } else {
            HTTPCommunicator.getLog().info((Object)("content lenght:" + length + " trying retrieving in multiple chunks"));
            try {
                HTTPCommunicator.retrieveMultithreaded(url, f, length);
            }
            catch (IOException e) {
                HTTPCommunicator.getLog().info((Object)"retrieving in chunks failed, trying to retrieve in single chunk");
                HTTPCommunicator.retrieveSingleThreaded(url, f);
            }
        }
    }

    public static void retrieveSingleThreaded(URL url, File f) throws IOException {
        if (url.toString().indexOf("?") == -1) {
            HTTPCommunicator.GET(url, f);
        } else {
            try {
                HTTPCommunicator.POST(url, f);
            }
            catch (IOException e) {
                if (e.getMessage().contains("405")) {
                    HTTPCommunicator.GET(url, f);
                }
                throw e;
            }
        }
    }

    public static void retrieveMultithreaded(URL url, File f, long length) throws IOException {
        ArrayList<ChunkDownloader> threads = new ArrayList<ChunkDownloader>();
        long size = 0L;
        int chunkNumber = 0;
        while (size < length) {
            long chunksize = DEFAULT_CHUNKSIZE;
            if ((long)DEFAULT_CHUNKSIZE > length - size) {
                chunksize = length - size;
            }
            ChunkDownloader downloader = new ChunkDownloader(size, size + chunksize - 1L, url, f.getName(), chunkNumber);
            threads.add(downloader);
            downloader.start();
            size += chunksize;
            ++chunkNumber;
        }
        for (ChunkDownloader t : threads) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        f.delete();
        Collections.sort(threads);
        for (ChunkDownloader downloader : threads) {
            if (downloader.error != null) {
                throw downloader.error;
            }
            StreamUtils.appendTo(f, downloader.f);
            downloader.f.delete();
        }
    }

    public static void retrieveChunk(URL url, File f, long start, long end) throws IOException {
        if (url.toString().indexOf("?") == -1) {
            HTTPCommunicator.GET(url, f, start, end);
        } else {
            try {
                HTTPCommunicator.POST(url, f, start, end);
            }
            catch (IOException e) {
                if (e.getMessage().contains("405")) {
                    HTTPCommunicator.GET(url, f, start, end);
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void GET(URL url, File f) throws IOException {
        HttpURLConnection conn = HTTPCommunicator.getConnection(url);
        try {
            conn.setDoInput(true);
            conn.setRequestMethod("GET");
            conn.connect();
            StreamUtils.copyToFile(conn.getInputStream(), f);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void GET(URL url, File f, long start, long end) throws IOException {
        HTTPCommunicator.getLog().info((Object)("downloading bytes:" + start + " " + end));
        HttpURLConnection conn = HTTPCommunicator.getConnection(url);
        try {
            conn.setDoInput(true);
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Range", "bytes=" + start + "-" + end);
            conn.connect();
            StreamUtils.copyToFile(conn.getInputStream(), f);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void POST(URL url, File f) throws IOException {
        HttpURLConnection conn = HTTPCommunicator.getConnection(url);
        try {
            conn.setDoInput(true);
            conn.setRequestMethod("POST");
            HashMap<String, String> parameters = HTTPCommunicator.extractParameters(url.toString());
            if (parameters.size() != 0) {
                String parametersString = HTTPCommunicator.encodeParameters(parameters);
                conn.setRequestProperty("Content-Length", "" + Integer.toString(parametersString.getBytes().length));
                conn.setRequestProperty("Content-Language", "en-US");
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                conn.setDoOutput(true);
                conn.connect();
                DataOutputStream printout = new DataOutputStream(conn.getOutputStream());
                printout.writeBytes(parametersString);
                printout.flush();
                printout.close();
            } else {
                conn.connect();
            }
            StreamUtils.copyToFile(conn.getInputStream(), f);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void POST(URL url, File f, long start, long end) throws IOException {
        HttpURLConnection conn = HTTPCommunicator.getConnection(url);
        try {
            conn.setDoInput(true);
            conn.setRequestMethod("POST");
            HashMap<String, String> parameters = HTTPCommunicator.extractParameters(url.toString());
            if (parameters.size() != 0) {
                String parametersString = HTTPCommunicator.encodeParameters(parameters);
                conn.setRequestProperty("Content-Length", "" + Integer.toString(parametersString.getBytes().length));
                conn.setRequestProperty("Content-Language", "en-US");
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                conn.setDoOutput(true);
                conn.setRequestProperty("Range", "bytes=" + start + "-" + end);
                conn.connect();
                DataOutputStream printout = new DataOutputStream(conn.getOutputStream());
                printout.writeBytes(parametersString);
                printout.flush();
                printout.close();
            } else {
                conn.connect();
            }
            StreamUtils.copyToFile(conn.getInputStream(), f);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static void main(String[] Args) throws Exception {
        String[] urls;
        File test = new File("/home/diego/Desktop/test.file");
        for (String urlString : urls = new String[]{"http://195.97.36.231/acrobatfiles/MTSAcrobatfiles/mts1.pdf"}) {
            URL url = new URL(urlString);
            if (HTTPCommunicator.resourceExist(url)) {
                HTTPCommunicator.getLog().info((Object)HTTPCommunicator.getHeader(url));
                long time = System.currentTimeMillis();
                HTTPCommunicator.retrieve(url, test);
                HTTPCommunicator.getLog().info((Object)("time:" + (System.currentTimeMillis() - time)));
                HTTPCommunicator.getLog().info((Object)("length:" + test.length()));
                continue;
            }
            HTTPCommunicator.getLog().info((Object)("resource " + urlString + " does not exist"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HTTPHeader {
        public static final String CONTENT_LENGHT = "Content-Length";
        public static final String CONTENT_MD5 = "Content-MD5";
        public static final String CONTENT_TYPE = "Content-Type";
        public static final String DATE = "Date";
        public static final String LAST_MODIFIED = "Last-Modified";
        Map<String, List<String>> header;

        private HTTPHeader(Map<String, List<String>> header) {
            this.header = header;
        }

        Long getContentLength() {
            if (this.getField(CONTENT_LENGHT).size() == 0) {
                return null;
            }
            return Long.parseLong(this.getField(CONTENT_LENGHT).get(0));
        }

        String getContentMD5() {
            if (this.getField(CONTENT_MD5).size() == 0) {
                return null;
            }
            return this.getField(CONTENT_MD5).get(0);
        }

        String getContentType() {
            if (this.getField(CONTENT_TYPE).size() == 0) {
                return null;
            }
            return this.getField(CONTENT_TYPE).get(0);
        }

        Calendar getDate() {
            if (this.getField(DATE).size() == 0) {
                return null;
            }
            try {
                Calendar c = Calendar.getInstance();
                long date = Long.parseLong(this.getField(DATE).get(0));
                c.setTimeInMillis(date);
                return c;
            }
            catch (Exception exception) {
                return null;
            }
        }

        Calendar getLastModified() {
            if (this.getField(LAST_MODIFIED).size() == 0) {
                return null;
            }
            try {
                Calendar c = Calendar.getInstance();
                long date = Long.parseLong(this.getField(LAST_MODIFIED).get(0));
                c.setTimeInMillis(date);
                return c;
            }
            catch (Exception exception) {
                return null;
            }
        }

        List<String> getField(String field) {
            if (this.header.containsKey(field)) {
                return this.header.get(field);
            }
            if (this.header.containsKey(field.toLowerCase())) {
                return this.header.get(field.toLowerCase());
            }
            if (this.header.containsKey(field.toUpperCase())) {
                return this.header.get(field.toUpperCase());
            }
            return new ArrayList<String>();
        }

        public String toString() {
            return this.header.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ChunkDownloader
    extends Thread
    implements Comparable<ChunkDownloader> {
        long start;
        long end;
        URL url;
        File f;
        int chunknumber;
        IOException error = null;

        public File getFile() {
            return this.f;
        }

        public ChunkDownloader(long start, long end, URL url, String filename, int chunknumber) throws IOException {
            this.end = end;
            this.f = File.createTempFile(filename, "-" + chunknumber);
            this.start = start;
            this.url = url;
        }

        @Override
        public void run() {
            try {
                HTTPCommunicator.retrieveChunk(this.url, this.f, this.start, this.end);
            }
            catch (IOException e) {
                this.error = e;
            }
            HTTPCommunicator.getLog().info((Object)("downloaded: " + this.f.getAbsolutePath() + "  " + this.f.length()));
        }

        @Override
        public int compareTo(ChunkDownloader other) {
            return Integer.valueOf(this.chunknumber).compareTo(other.chunknumber);
        }
    }
}

