/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.baselayer.inMessageImpl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.gcube.contentmanagement.baselayer.BaseLayerStream;
import org.gcube.contentmanagement.baselayer.exceptions.BaseLayerException;

public class InMemoryContentStream
extends BaseLayerStream {
    private byte[] content;

    public InMemoryContentStream(byte[] content) {
        super(new ByteArrayInputStream(content), content.length);
        this.content = content;
    }

    public InMemoryContentStream(BaseLayerStream binaryFileContent, ByteArrayOutputStream baosToUse) throws BaseLayerException {
        super(null);
        InMemoryContentStream.copyBytes(binaryFileContent, baosToUse);
        this.content = baosToUse.toByteArray();
        this.inputStream = new ByteArrayInputStream(this.content);
        this.length = this.content.length;
        this.setBuffered(true);
    }

    public byte[] getContent() {
        return this.content;
    }

    public static long copyBytes(BaseLayerStream binaryFileContent, ByteArrayOutputStream baos) throws BaseLayerException {
        return binaryFileContent.writeToStreamRespectingLimit(baos);
    }

    public void dispose() throws BaseLayerException {
        super.dispose();
        this.content = null;
    }
}

