/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.baselayer.streamutils;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.contentmanagement.baselayer.streamutils.FinishingAction;
import org.gcube.contentmanagement.baselayer.streamutils.FinishingActionStream;

public class FinishingActionInputStream
extends InputStream
implements FinishingActionStream {
    private static Log log = LogFactory.getLog(FinishingActionInputStream.class);
    private InputStream wrappedStream;
    private FinishingAction finishingAction;
    private boolean actionPerformed = false;
    private long count = 0L;
    private IOException capturedException = null;

    public FinishingActionInputStream(InputStream wrappedStream, FinishingAction action) {
        this.setWrappedStream(wrappedStream);
        this.setFinishingAction(action);
    }

    public int read() throws IOException {
        int result;
        try {
            result = this.wrappedStream.read();
        }
        catch (EOFException eof) {
            this.finish();
            throw eof;
        }
        if (result == -1) {
            this.finish();
        }
        this.incrementCount(1L);
        return result;
    }

    public void finish() throws IOException {
        try {
            this.wrappedStream.close();
        }
        catch (IOException ioe) {
            this.capturedException = ioe;
        }
        if (!this.actionPerformed && this.finishingAction != null) {
            this.finishingAction.finish(this);
            this.actionPerformed = true;
        }
        if (this.capturedException != null) {
            throw this.capturedException;
        }
    }

    public void close() throws IOException {
        this.finish();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int result;
        try {
            result = this.wrappedStream.read(b, off, len);
        }
        catch (EOFException eof) {
            this.finish();
            throw eof;
        }
        this.incrementCount(result);
        if (result < 1) {
            this.finish();
        }
        return result;
    }

    public int read(byte[] b) throws IOException {
        int result;
        try {
            result = this.wrappedStream.read(b);
        }
        catch (EOFException eof) {
            try {
                this.wrappedStream.close();
            }
            catch (IOException ioe) {
                log.debug((Object)"Caught IOException in attempt to close ended stream.", (Throwable)ioe);
            }
            this.finish();
            throw eof;
        }
        this.incrementCount(result);
        return result;
    }

    public long skip(long n) throws IOException {
        long result;
        try {
            result = this.wrappedStream.skip(n);
        }
        catch (EOFException eof) {
            this.finish();
            throw eof;
        }
        this.incrementCount(result);
        return result;
    }

    public int available() throws IOException {
        return this.wrappedStream.available();
    }

    public synchronized void mark(int readlimit) {
        this.wrappedStream.mark(readlimit);
    }

    public boolean markSupported() {
        return this.wrappedStream.markSupported();
    }

    public synchronized void reset() throws IOException {
        this.wrappedStream.reset();
    }

    public long getCount() {
        return this.count;
    }

    public long resetCount() {
        long previousCount = this.getCount();
        this.count = 0L;
        return previousCount;
    }

    public IOException exceptionBeforeFinishing() {
        return this.capturedException;
    }

    public void resetExceptionBeforeFinishing() {
        this.capturedException = null;
    }

    public void incrementCount(long valueToAdd) throws IOException {
        this.count += valueToAdd;
    }

    public FinishingAction getFinishingAction() {
        return this.finishingAction;
    }

    public void setFinishingAction(FinishingAction finishingAction) {
        this.finishingAction = finishingAction;
    }

    public Object getWrappedStream() {
        return this.wrappedStream;
    }

    public void setWrappedStream(Object wrappedStream) {
        this.wrappedStream = (InputStream)wrappedStream;
    }
}

