/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.baselayer.streamutils;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.contentmanagement.baselayer.streamutils.FinishingAction;
import org.gcube.contentmanagement.baselayer.streamutils.FinishingActionStream;

public class FinishingActionOutputStream
extends OutputStream
implements FinishingActionStream {
    private static Log log = LogFactory.getLog(FinishingActionOutputStream.class);
    private OutputStream wrappedStream;
    private FinishingAction finishingAction;
    private boolean actionPerformed = false;
    private long count = 0L;
    private IOException capturedException = null;

    public FinishingActionOutputStream(OutputStream wrappedStream, FinishingAction action) {
        this.setWrappedStream(wrappedStream);
        this.setFinishingAction(action);
    }

    public void close() throws IOException {
        this.finish();
    }

    public void finish() throws IOException {
        try {
            this.wrappedStream.close();
        }
        catch (IOException ioe) {
            this.capturedException = ioe;
        }
        if (!this.actionPerformed) {
            this.finishingAction.finish(this);
            this.actionPerformed = true;
        }
        if (this.capturedException != null) {
            throw this.capturedException;
        }
    }

    public void flush() throws IOException {
        this.wrappedStream.flush();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.wrappedStream.write(b, off, len);
        this.incrementCount(len);
    }

    public void write(byte[] b) throws IOException {
        this.wrappedStream.write(b);
        this.incrementCount(b.length);
    }

    public void write(int b) throws IOException {
        this.wrappedStream.write(b);
        this.incrementCount(1L);
    }

    public long getCount() {
        return this.count;
    }

    public long resetCount() {
        long previousCount = this.getCount();
        this.count = 0L;
        return previousCount;
    }

    public IOException exceptionBeforeFinishing() {
        return this.capturedException;
    }

    public void resetExceptionBeforeFinishing() {
        this.capturedException = null;
    }

    public void incrementCount(long valueToAdd) throws IOException {
        this.count += valueToAdd;
    }

    public FinishingAction getFinishingAction() {
        return this.finishingAction;
    }

    public void setFinishingAction(FinishingAction finishingAction) {
        this.finishingAction = finishingAction;
    }

    public Object getWrappedStream() {
        return this.wrappedStream;
    }

    public void setWrappedStream(Object wrappedStream) {
        this.wrappedStream = (OutputStream)wrappedStream;
    }
}

