/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.baselayer.filesystemImpl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.contentmanagement.baselayer.BaseLayerStream;
import org.gcube.contentmanagement.baselayer.BaseLayerUtils;
import org.gcube.contentmanagement.baselayer.InstantiableManager;
import org.gcube.contentmanagement.baselayer.RawContentLocation;
import org.gcube.contentmanagement.baselayer.RawFileContentManager;
import org.gcube.contentmanagement.baselayer.exceptions.BaseLayerException;
import org.gcube.contentmanagement.baselayer.exceptions.ObjectNotFoundException;
import org.gcube.contentmanagement.baselayer.exceptions.ValueNotValidException;
import org.gcube.contentmanagement.baselayer.streamutils.DeleteContentAction;
import org.gcube.contentmanagement.baselayer.streamutils.FinishingActionInputStream;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicStorageHints;
import org.gcube.contentmanagement.layerindependent.servicehelper.UUIDUtils;

public class LocalFilesystemStorage
implements RawFileContentManager,
InstantiableManager {
    private static final Log log = LogFactory.getLog(LocalFilesystemStorage.class);
    static final String DATA_PROVIDER_PREFIX = "rawcontentstorage:";
    static final String dataProvider = "rawcontentstorage:";
    final File rawContentStorageRoot;
    static LocalFilesystemStorage managerInstance;

    public static LocalFilesystemStorage getInstance() {
        return managerInstance;
    }

    public static LocalFilesystemStorage getManagerInstance(String[] params, String managerName) throws BaseLayerException {
        if (managerInstance == null) {
            managerInstance = new LocalFilesystemStorage();
        }
        return LocalFilesystemStorage.getInstance();
    }

    private LocalFilesystemStorage() throws ValueNotValidException {
        String storageDir = GHNContext.getContext().getStorageRoot() + "/gcoredb/rawcontentstorage";
        this.rawContentStorageRoot = new File(storageDir);
        if (!this.rawContentStorageRoot.exists()) {
            if (!this.rawContentStorageRoot.mkdirs()) {
                throw new ValueNotValidException("Directory could not be created.", this.rawContentStorageRoot.getAbsolutePath(), "contentmanagement:location");
            }
        } else if (!this.rawContentStorageRoot.isDirectory()) {
            throw new ValueNotValidException("Storage root is not a directory.", this.rawContentStorageRoot.getAbsolutePath(), "contentmanagement:location");
        }
        if (!this.rawContentStorageRoot.canRead()) {
            throw new ValueNotValidException("Storage Root cannot be read!!", this.rawContentStorageRoot.getAbsolutePath(), "contentmanagement:location");
        }
        if (!this.rawContentStorageRoot.canWrite()) {
            throw new ValueNotValidException("Storage Root cannot be written!!", this.rawContentStorageRoot.getAbsolutePath(), "contentmanagement:location");
        }
    }

    public String getDataProvider() {
        return "rawcontentstorage:";
    }

    public static String getDataProviderPrefix() {
        return "rawcontentstorage:";
    }

    public static synchronized LocalFilesystemStorage getManagerFor(String directory) throws BaseLayerException {
        return LocalFilesystemStorage.getInstance();
    }

    public static LocalFilesystemStorage getManagerFor(RawContentLocation rcl) throws BaseLayerException {
        String s = rcl.getDataprovider();
        if (s.startsWith("rawcontentstorage:")) {
            s = s.substring("rawcontentstorage:".length());
            return LocalFilesystemStorage.getManagerFor(s);
        }
        throw new BaseLayerException("Not the appropriate dataprovider.");
    }

    public boolean supportsAppending() {
        return true;
    }

    public boolean handles(String dataProvider) {
        if (dataProvider == null) {
            return false;
        }
        return dataProvider.equals(this.getDataProvider());
    }

    public RawContentLocation saveBinaryContent(String uniqueStorageID, BaseLayerStream binaryFileContent, BasicStorageHints hints) throws BaseLayerException {
        if (BaseLayerUtils.requestsFor("create-new-file-when-file-exists", hints) && !hints.isConsumedHint("create-new-file-when-file-exists")) {
            uniqueStorageID = BaseLayerUtils.makePseudoUniqueLocation(new RawContentLocation(uniqueStorageID, this.getDataProvider()), this, hints).getContentID();
            hints.markHint("create-new-file-when-file-exists", true);
        }
        log.debug((Object)("saving binary content at location " + uniqueStorageID));
        File storageLocationFile = this.getFileFor(uniqueStorageID);
        RawContentLocation loc = this.saveBinaryContent(storageLocationFile, binaryFileContent, hints);
        loc.setContentID(uniqueStorageID);
        return loc;
    }

    public String getUniqueStorageLocationIDFor(String objectID) {
        return UUIDUtils.getLocationFromUUID((String)objectID);
    }

    public RawContentLocation saveBinaryContent(File outputFile, BaseLayerStream binaryFileContent, BasicStorageHints hints) throws BaseLayerException {
        try {
            BufferedOutputStream os;
            if (!outputFile.exists()) {
                outputFile.getParentFile().mkdirs();
                if (!outputFile.createNewFile()) {
                    throw new ValueNotValidException("Could not create new file '" + outputFile.getAbsolutePath() + "'.", outputFile.getName(), "contentmanagement:location");
                }
            }
            if (!outputFile.canWrite()) {
                throw new ValueNotValidException("Cannot write to file '" + outputFile.getAbsolutePath() + "'.", outputFile.getName(), "contentmanagement:location");
            }
            if (BaseLayerUtils.requestsFor("append-content", hints)) {
                os = new BufferedOutputStream(new FileOutputStream(outputFile, true));
                hints.markHint("append-content", true);
            } else {
                os = new BufferedOutputStream(new FileOutputStream(outputFile, false));
            }
            binaryFileContent.setLimit(hints);
            long transferred = binaryFileContent.writeToStreamRespectingLimit(os);
            hints.addHint("bytes-transferred", transferred + "");
            hints.markHint("bytes-transferred", true);
            binaryFileContent.dispose();
            ((OutputStream)os).flush();
            ((OutputStream)os).close();
            return new RawContentLocation(outputFile.getName(), "rawcontentstorage:");
        }
        catch (IOException ioe) {
            throw new BaseLayerException("Error while transferring data.", ioe);
        }
    }

    public BaseLayerStream getBinaryContent(RawContentLocation rcl, BasicStorageHints hints) throws BaseLayerException {
        File file = this.getFileFor(rcl.getContentID());
        return this.getBinaryContent(file, hints);
    }

    public BaseLayerStream getBinaryContent(File file, BasicStorageHints hints) throws ObjectNotFoundException, ValueNotValidException, BaseLayerException {
        if (!file.exists()) {
            throw new ObjectNotFoundException("File does not exist", file.getPath());
        }
        if (!file.canRead()) {
            throw new ValueNotValidException("Cannot read file.", file.getPath(), "contentmanagement:location");
        }
        try {
            InputStream is = new FileInputStream(file);
            if (BaseLayerUtils.requestsFor("guess-content-mime-type", hints)) {
                String mimeType = URLConnection.guessContentTypeFromName(file.getName());
                BaseLayerUtils.consumeHint("guess-content-mime-type", hints);
                if (mimeType != null && !"content/unknown".equals(mimeType)) {
                    hints.addHint("content-mime-type", mimeType);
                }
            }
            if (BaseLayerUtils.requestsFor("delete-after-transfer", hints)) {
                log.debug((Object)"Requested for deletion of content, delaying this until stream has been read entirely.");
                DeleteContentAction fa = new DeleteContentAction(this, new RawContentLocation(file.getAbsolutePath(), this.getDataProvider()), new BasicStorageHints(), true);
                is = new FinishingActionInputStream(is, fa);
                hints.markHint("delete-after-transfer", true);
            }
            BaseLayerStream bls = new BaseLayerStream(is, file.length());
            return bls;
        }
        catch (IOException ioe) {
            throw new BaseLayerException("Error while opening file '" + file.getAbsolutePath() + "'.", ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteBinaryContent(RawContentLocation rcl, BasicStorageHints hints) throws BaseLayerException {
        String string = rcl.getContentID();
        synchronized (string) {
            File file = this.getFileFor(rcl.getContentID());
            log.debug((Object)("Trying to delete file " + file.getAbsolutePath()));
            if (file.exists()) {
                if (!file.canWrite()) {
                    throw new ValueNotValidException("Cannot delete file.", rcl.getContentID(), "contentmanagement:location");
                }
                if (!this.removeFileAndEmptyParents(file)) {
                    throw new BaseLayerException("File '" + file.getAbsolutePath() + "' could not be deleted");
                }
                return true;
            }
            log.debug((Object)("file " + file.getAbsolutePath() + " does not exist, cannot remove"));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsBinaryContent(RawContentLocation rcl, BasicStorageHints hints) throws ValueNotValidException {
        String string = rcl.getContentID();
        synchronized (string) {
            File file = this.getFileFor(rcl.getContentID());
            return file.exists();
        }
    }

    public RawContentLocation makePermanentLocation(RawContentLocation currentLocation, BasicStorageHints hints) throws ValueNotValidException {
        if (BaseLayerUtils.containsDownloadCredentials(hints)) {
            throw new ValueNotValidException("Hints for username and/or password are not allowed in this context.", "permanent location", "contentmanagement:location");
        }
        return currentLocation;
    }

    private boolean removeFileAndEmptyParents(File file) {
        log.debug((Object)("removing file " + file.getAbsolutePath()));
        if (!file.delete()) {
            return false;
        }
        log.debug((Object)("done removing " + file.getAbsolutePath()));
        File parent = file.getParentFile();
        while (!parent.equals(this.rawContentStorageRoot)) {
            log.debug((Object)("removing file " + parent.getAbsolutePath()));
            if (parent.listFiles().length != 0) {
                log.debug((Object)(parent.getAbsolutePath() + "not empty"));
            }
            if (!parent.delete()) {
                log.debug((Object)(parent.getAbsolutePath() + "cannot be deleted because it's not empty"));
                break;
            }
            log.debug((Object)("deleted " + parent.getAbsolutePath()));
            parent = parent.getParentFile();
        }
        return true;
    }

    File getFileFor(String uniqueStorageID) {
        return new File(this.rawContentStorageRoot, uniqueStorageID);
    }
}

