/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.baselayer.networkFileTransfer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import org.gcube.contentmanagement.baselayer.BaseLayerStream;
import org.gcube.contentmanagement.baselayer.BaseLayerUtils;
import org.gcube.contentmanagement.baselayer.InstantiableManager;
import org.gcube.contentmanagement.baselayer.RawContentLocation;
import org.gcube.contentmanagement.baselayer.RawFileContentManager;
import org.gcube.contentmanagement.baselayer.exceptions.BaseLayerException;
import org.gcube.contentmanagement.baselayer.exceptions.TemporaryUnavailableException;
import org.gcube.contentmanagement.baselayer.exceptions.ValueNotValidException;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicStorageHints;
import org.globus.ftp.FTPClient;
import org.globus.ftp.exception.FTPException;
import org.globus.io.streams.FTPInputStream;
import org.globus.io.streams.FTPOutputStream;
import org.globus.util.GlobusURL;

public class CoGFTPContentManager
implements RawFileContentManager,
InstantiableManager {
    static final String DATA_PROVIDER_PREFIX = "ftp://";
    final String URL_PREFIX;

    public static String getDataProviderPrefix() {
        return DATA_PROVIDER_PREFIX;
    }

    public CoGFTPContentManager(String managedURL) {
        this.URL_PREFIX = managedURL;
    }

    GlobusURL getURLFor(String uniqueStorageID) throws ValueNotValidException {
        GlobusURL url;
        try {
            url = this.URL_PREFIX == null || this.URL_PREFIX.equals("") || uniqueStorageID.startsWith(this.URL_PREFIX) ? new GlobusURL(uniqueStorageID) : new GlobusURL(this.URL_PREFIX + uniqueStorageID);
        }
        catch (MalformedURLException e) {
            throw new ValueNotValidException("Malformed URL as storage location.", uniqueStorageID, "contentmanagement:location");
        }
        return url;
    }

    public RawContentLocation saveBinaryContent(String uniqueStorageID, BaseLayerStream binaryFileContent, BasicStorageHints hints) throws BaseLayerException {
        if (BaseLayerUtils.requestsFor("create-new-file-when-file-exists", hints) && !hints.isConsumedHint("create-new-file-when-file-exists")) {
            uniqueStorageID = BaseLayerUtils.makePseudoUniqueLocation(new RawContentLocation(uniqueStorageID, this.getDataProvider()), this, hints).getContentID();
            hints.markHint("create-new-file-when-file-exists", true);
        }
        GlobusURL u = this.getURLFor(uniqueStorageID);
        try {
            FTPOutputStream os;
            String pass;
            String user;
            if (hints.hasHint("user")) {
                user = hints.getHintValue("user");
                hints.markHint("user", true);
            } else {
                user = u.getUser();
            }
            if (hints.hasHint("passwd")) {
                pass = hints.getHintValue("passwd");
                hints.markHint("passwd", true);
            } else {
                pass = u.getPwd();
            }
            String file = URLDecoder.decode(u.getPath(), "UTF-8");
            if (BaseLayerUtils.requestsFor("append-content", hints)) {
                os = new FTPOutputStream(u.getHost(), u.getPort(), user, pass, file, true);
                hints.markHint("append-content", true);
            } else {
                os = new FTPOutputStream(u.getHost(), u.getPort(), user, pass, file, true);
            }
            binaryFileContent.setLimit(hints);
            long transferred = binaryFileContent.writeToStreamRespectingLimit((OutputStream)os);
            hints.addHint("bytes-transferred", transferred + "");
            hints.markHint("bytes-transferred", true);
            binaryFileContent.dispose();
            os.flush();
            os.close();
            return new RawContentLocation(uniqueStorageID, this.getDataProvider());
        }
        catch (IOException ioe) {
            throw new BaseLayerException("Error in data access.", ioe);
        }
        catch (FTPException ftpe) {
            throw new BaseLayerException("GridFTP client error while tranferring data to'" + uniqueStorageID + "'.", ftpe);
        }
    }

    public BaseLayerStream getBinaryContent(RawContentLocation location, BasicStorageHints hints) throws BaseLayerException {
        GlobusURL u = this.getURLFor(location.getContentID());
        try {
            String pass;
            String user;
            if (hints.hasHint("user")) {
                user = hints.getHintValue("user");
                hints.markHint("user", true);
            } else {
                user = u.getUser();
            }
            if (hints.hasHint("passwd")) {
                pass = hints.getHintValue("passwd");
                hints.markHint("passwd", true);
            } else {
                pass = u.getPwd();
            }
            String file = URLDecoder.decode(u.getPath(), "UTF-8");
            FTPInputStream is = new FTPInputStream(u.getHost(), u.getPort(), user, pass, file);
            long size = is.getSize();
            if (size < 0L) {
                size = Long.MIN_VALUE;
            }
            return new BaseLayerStream((InputStream)is, size);
        }
        catch (IOException ioe) {
            throw new BaseLayerException("Error in data access.", ioe);
        }
        catch (FTPException ftpe) {
            int ftpErrorCode = ftpe.getCode();
            if (ftpErrorCode == 421) {
                throw new TemporaryUnavailableException("Received FTP error code " + ftpErrorCode + " when trying to access " + location.getContentID() + ", which might be recoverable with time.", ftpe);
            }
            throw new BaseLayerException("FTP client error while tranferring data from'" + location.getContentID() + "'.", ftpe);
        }
    }

    public boolean deleteBinaryContent(RawContentLocation location, BasicStorageHints hints) throws BaseLayerException {
        GlobusURL u = this.getURLFor(location.getContentID());
        try {
            String pass;
            String user;
            FTPClient client = new FTPClient(u.getHost(), u.getPort());
            if (hints.hasHint("user")) {
                user = hints.getHintValue("user");
                hints.markHint("user", true);
            } else {
                user = u.getUser();
            }
            if (hints.hasHint("passwd")) {
                pass = hints.getHintValue("passwd");
                hints.markHint("passwd", true);
            } else {
                pass = u.getPwd();
            }
            if (user != null || pass != null) {
                client.authorize(user, pass);
            }
            client.setPassive();
            client.setLocalActive();
            client.deleteFile(u.getPath());
            client.close();
        }
        catch (IOException ioe) {
            throw new BaseLayerException("I/O error while deleting file.", ioe);
        }
        catch (FTPException ftpe) {
            throw new BaseLayerException("FTP client error while tranferring data from'" + location.getContentID() + "'.", ftpe);
        }
        return true;
    }

    public boolean existsBinaryContent(RawContentLocation location, BasicStorageHints hints) throws BaseLayerException {
        GlobusURL u = this.getURLFor(location.getContentID());
        try {
            String pass;
            String user;
            FTPClient client = new FTPClient(u.getHost(), u.getPort());
            if (hints.hasHint("user")) {
                user = hints.getHintValue("user");
                hints.markHint("user", true);
            } else {
                user = u.getUser();
            }
            if (hints.hasHint("passwd")) {
                pass = hints.getHintValue("passwd");
                hints.markHint("passwd", true);
            } else {
                pass = u.getPwd();
            }
            if (user != null || pass != null) {
                client.authorize(user, pass);
            }
            client.setPassive();
            client.setLocalActive();
            boolean exists = client.exists(u.getPath());
            client.close();
            return exists;
        }
        catch (IOException ioe) {
            throw new BaseLayerException("I/O error while checking for file.", ioe);
        }
        catch (FTPException ftpe) {
            throw new BaseLayerException("FTP client error while tranferring data from'" + location.getContentID() + "'.", ftpe);
        }
    }

    public boolean handles(String dataprovider) {
        if (!dataprovider.startsWith(CoGFTPContentManager.getDataProviderPrefix())) {
            return false;
        }
        if (dataprovider.startsWith(this.getDataProvider())) {
            return true;
        }
        String newProvider = CoGFTPContentManager.getDataProviderPrefix() + BaseLayerUtils.removeProtocolUsernamePasswordFromURL(dataprovider);
        return newProvider.startsWith(this.getDataProvider());
    }

    public String getDataProvider() {
        if (this.URL_PREFIX == null || this.URL_PREFIX == "") {
            return DATA_PROVIDER_PREFIX;
        }
        return this.URL_PREFIX;
    }

    public boolean supportsAppending() {
        return true;
    }

    public RawContentLocation makePermanentLocation(RawContentLocation currentLocation, BasicStorageHints hints) throws ValueNotValidException {
        StringBuffer newURL = new StringBuffer(CoGFTPContentManager.getDataProviderPrefix());
        if (hints.hasHint("user")) {
            newURL.append(hints.getHintValue("user"));
            if (hints.hasHint("passwd")) {
                newURL.append(':');
                newURL.append(hints.getHintValue("passwd"));
            }
            newURL.append('@');
        }
        newURL.append(BaseLayerUtils.removeProtocolUsernamePasswordFromURL(currentLocation.getContentID()));
        return new RawContentLocation(this.getDataProvider(), newURL.toString());
    }

    public static CoGFTPContentManager getManagerInstance(String[] params, String managerName) throws BaseLayerException {
        return new CoGFTPContentManager("");
    }

    public String getUniqueStorageLocationIDFor(String objectID) {
        return objectID;
    }
}

