/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.storagelayer;

import java.io.File;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.security.SecurityCredentials;
import org.gcube.contentmanagement.baselayer.BaseLayerStream;
import org.gcube.contentmanagement.baselayer.BaseLayerUtils;
import org.gcube.contentmanagement.baselayer.RawContentLocation;
import org.gcube.contentmanagement.baselayer.RawContentLocationSelectionStrategy;
import org.gcube.contentmanagement.baselayer.RawFileContentManager;
import org.gcube.contentmanagement.baselayer.RelationshipAndPropertyManager;
import org.gcube.contentmanagement.baselayer.exceptions.BaseLayerException;
import org.gcube.contentmanagement.baselayer.exceptions.DuplicateIDException;
import org.gcube.contentmanagement.baselayer.exceptions.ObjectNotFoundException;
import org.gcube.contentmanagement.baselayer.exceptions.ValueNotValidException;
import org.gcube.contentmanagement.baselayer.inMessageImpl.InMemoryContentManager;
import org.gcube.contentmanagement.baselayer.inMessageImpl.InMemoryRawContentLocation;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicInfoObjectDescription;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicPropertyDescription;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicReferenceDescription;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicStorageHints;
import org.gcube.contentmanagement.layerindependent.servicehelper.CredentialsProvider;
import org.gcube.contentmanagement.layerindependent.servicehelper.StorageManagementProperties;
import org.gcube.contentmanagement.storagelayer.StorageLayerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorageManager {
    static final String SUBSYSTEM_RAPM = "Relationship and Property Management";
    static final String SUBSYSTEM_RFCM = "Raw File Content Management";
    private static GCUBEServiceContext serviceContext = null;
    private static final Log log = LogFactory.getLog(StorageManager.class);
    static HashMap managers;
    static boolean performAdditionalChecks;
    static RawFileContentManager rfcm;
    static RelationshipAndPropertyManager rapm;
    static long defaultSmallSizeThreshold;
    static long maxSmallSizeThreshold;
    static RawContentLocationSelectionStrategy rawstrategy;
    public static CredentialsProvider provider;
    public static boolean initialized;

    public static void init(File configDir, GCUBEServiceContext ctx) {
        if (initialized) {
            log.debug((Object)"Storage Manager already initialized, skipping");
            return;
        }
        initialized = true;
        provider = new CredentialsProvider(){

            public SecurityCredentials getCredentials() {
                return null;
            }
        };
        log.info((Object)"Initializing Storage Manager started");
        StorageManagementProperties.getInstance().loadFromDir(configDir);
        try {
            performAdditionalChecks = StorageManagementProperties.getInstance().getBooleanProperty("PerformAdditionalChecks");
            log.info((Object)("Perform additional checks: " + performAdditionalChecks));
            log.info((Object)"loading managers");
            managers = new HashMap();
            int numManagers = StorageManagementProperties.getInstance().getIntegerProperty("manager.count");
            for (int h = 0; h < numManagers; ++h) {
                String[] manager = StorageManagementProperties.getInstance().getArrayProperty("manager." + h);
                String managerName = manager[0];
                String className = manager[1];
                String[] params = new String[manager.length - 2];
                System.arraycopy(manager, 2, params, 0, params.length);
                log.info((Object)("instantiating manager '" + managerName + "'"));
                log.info((Object)("class: '" + className + "'"));
                if (params.length > 0) {
                    log.info((Object)"with parameters:");
                }
                for (String p : params) {
                    log.info((Object)("'" + p + "'"));
                }
                managers.put(managerName, BaseLayerUtils.instantiateManager(className, params, managerName, provider));
            }
            String rfcmName = StorageManagementProperties.getInstance().getProperty("DefaultRawFileContentManager");
            if (!managers.containsKey(rfcmName)) {
                log.error((Object)"Name of Default Raw File Content Manager does not correspond to any manager");
                throw new IllegalArgumentException("Name of Default Raw File Content Manager does not correspond to any manager");
            }
            rfcm = (RawFileContentManager)managers.get(rfcmName);
            String rapmName = StorageManagementProperties.getInstance().getProperty("DefaultRelationshipAndPropertyManager");
            if (!managers.containsKey(rfcmName)) {
                log.error((Object)"Name of Default Raw Relationships and Properties Manager does not correspond to any manager");
                throw new IllegalArgumentException("Name of Default Raw Relationships and Properties Manager does not correspond to any manager");
            }
            rapm = (RelationshipAndPropertyManager)managers.get(rapmName);
            log.info((Object)"Setting buffer size");
            String defaultBufferSize = StorageManagementProperties.getInstance().getProperty("DefaultBufferSize");
            if (defaultBufferSize != null) {
                try {
                    BaseLayerStream.setDefaultBufferSize(Integer.parseInt(defaultBufferSize));
                    log.info((Object)("Set default buffer size to: " + defaultBufferSize));
                }
                catch (NumberFormatException nfe) {
                    log.error((Object)"Could not adjust default buffer size, specified value was not a valid integer.", (Throwable)nfe);
                }
            }
            log.info((Object)"Small file size");
            String defaultSmallSize = StorageManagementProperties.getInstance().getProperty("DefaultSmallFileSizeThreshold");
            if (defaultSmallSize != null) {
                try {
                    defaultSmallSizeThreshold = Long.parseLong(defaultSmallSize);
                }
                catch (NumberFormatException nfe) {
                    log.error((Object)"Could not adjust default small file size threshold, specified value was not a valid long value.", (Throwable)nfe);
                }
            }
            log.info((Object)"Setting up handlers");
            int numHandlers = StorageManagementProperties.getInstance().getIntegerProperty("protocol.handler.count");
            for (int h = 0; h < numHandlers; ++h) {
                String[] handler = StorageManagementProperties.getInstance().getArrayProperty("protocol.handler." + h);
                String className = handler[0];
                String[] params = new String[handler.length - 1];
                System.arraycopy(handler, 1, params, 0, params.length);
                log.info((Object)("registering protocol handler " + handler[0]));
                if (params.length > 0) {
                    log.info((Object)"with parameters:");
                }
                for (String p : params) {
                    log.info((Object)p);
                }
                BaseLayerUtils.registerProtocolHandler(className, params, "protocol.handler." + h, provider);
            }
            log.info((Object)"registering managers as protocol handlers");
            for (Object m : managers.values()) {
                BaseLayerUtils.registerProtocolHandler((RawFileContentManager)m);
            }
            log.info((Object)("Using storage manager with a default buffer size of " + BaseLayerStream.getDefaultBufferSize() + " bytes."));
            log.info((Object)"Finished Storage Manager Initialization.");
        }
        catch (Exception e) {
            log.fatal((Object)"Error while updating configuration.");
            log.error((Object)e);
            throw new RuntimeException("StorageManager could not be initialized successfully. Please check if database etc. is available.", e);
        }
    }

    public static String createInfoObject(String name, String type, BasicStorageHints hints) throws StorageLayerException {
        try {
            log.info((Object)("Creating new object with '" + name + "' of type '" + type + "'."));
            String id = rapm.createInfoObject(name, type, hints);
            log.debug((Object)("New object created with oid'" + id + "'."));
            return id;
        }
        catch (BaseLayerException ble) {
            log.error((Object)"Error creating the info object", (Throwable)ble);
            throw new StorageLayerException("Create info object failed.", ble, SUBSYSTEM_RAPM);
        }
    }

    public static boolean removeInfoObject(String objectID) throws StorageLayerException {
        try {
            log.info((Object)("removing info object " + objectID));
            return rapm.removeInfoObject(objectID);
        }
        catch (BaseLayerException ble) {
            log.error((Object)"Error removing the info object.", (Throwable)ble);
            throw new StorageLayerException("Could not remove info object. ", ble, SUBSYSTEM_RAPM);
        }
    }

    public static boolean hasRawContent(String objectID) throws StorageLayerException {
        try {
            log.info((Object)("hasRawContent objectID: " + objectID));
            return rapm.hasRawContent(objectID);
        }
        catch (BaseLayerException ble) {
            log.error((Object)"Error in hasRawContent", (Throwable)ble);
            throw new StorageLayerException("Could not determine if info object has raw content.", ble, SUBSYSTEM_RAPM);
        }
    }

    public static BasicInfoObjectDescription getInfoObject(String objectID, String targetFileLocation, BasicStorageHints hints) throws StorageLayerException {
        BasicInfoObjectDescription info;
        if (log.isInfoEnabled()) {
            log.info((Object)("Get info object with id " + objectID + " target location " + targetFileLocation + " and hints " + hints));
        }
        try {
            if (BaseLayerUtils.requestsFor("return-plain-object", hints)) {
                log.debug((Object)"Requested for plain object, retrieving no properties or relationships.");
                info = rapm.getInfoObjectDescription(objectID, false, false, false);
            } else if (BaseLayerUtils.requestsFor("return-object-without-references", hints)) {
                log.debug((Object)"Requested for object without refernces, retrieving properties only.");
                info = rapm.getInfoObjectDescription(objectID, true, false, false);
            } else {
                log.debug((Object)"Retrieving object information including properties and references");
                info = rapm.getInfoObjectDescription(objectID);
            }
        }
        catch (BaseLayerException ble) {
            log.error((Object)"Error getting the info object", (Throwable)ble);
            throw new StorageLayerException("Could not retrieve info object with id '" + objectID + "'.", ble, SUBSYSTEM_RAPM);
        }
        if (hints.hasHint("do-not-transfer-if-no-update-since")) {
            long timestamp;
            log.debug((Object)"Check if updated.");
            try {
                timestamp = BaseLayerUtils.convertHintToLong(hints.getHintValue("do-not-transfer-if-no-update-since"), "do-not-transfer-if-no-update-since");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Requested only for files which have been updated since: " + timestamp));
                }
            }
            catch (ValueNotValidException vnve) {
                log.debug((Object)vnve);
                throw new StorageLayerException("Value of hint 'do-not-transfer-if-no-update-since' was not valid.", vnve, SUBSYSTEM_RAPM);
            }
            if (!info.updatedSince(timestamp)) {
                log.info((Object)("Object has not been modified since " + timestamp + "."));
                targetFileLocation = "/dev/null";
                hints.addConsumedHint("content-stored-at", targetFileLocation);
            } else {
                log.debug((Object)("Object has been modified since " + timestamp));
            }
            hints.markHint("do-not-transfer-if-no-update-since", true);
        }
        if (targetFileLocation == null || "/dev/null".equals(targetFileLocation)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No need / request to transfer raw content.");
                log.debug((Object)("Consumed hints are: " + hints.getUnconsumedHints()));
            }
            return info;
        }
        RawContentLocation newloc = null;
        try {
            log.debug((Object)"Retrieving all possible locations where the raw content is present.");
            List<RawContentLocation> locs = rapm.retrieveObjectContentLocations(objectID);
            if (locs.size() == 0) {
                log.debug((Object)"Info object has no raw data.");
                return info;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Retrieving raw content using strategy '" + rawstrategy.getClass().getName() + "' and hints '" + hints + "'..."));
                for (RawContentLocation location : locs) {
                    log.debug((Object)("location : " + location));
                }
            }
            BaseLayerStream bls = rawstrategy.retrieveFromPreferredLocation(locs, hints);
            log.debug((Object)"Handling start offset and limit (if necessary");
            bls.setLimit(hints);
            log.debug((Object)"Checking if small files should be transferred in message.");
            if (BaseLayerUtils.requestsFor("send-small-files-in-message", hints)) {
                String hintvalue = hints.getHintValue("small-files-threshold");
                long smallSizeThreshold = hintvalue != null ? BaseLayerUtils.convertHintToLong(hintvalue, "small-files-threshold") : defaultSmallSizeThreshold;
                if ((smallSizeThreshold = Math.min(smallSizeThreshold, maxSmallSizeThreshold)) == BaseLayerUtils.convertHintToLong(hintvalue, "small-files-threshold")) {
                    hints.markHint("small-files-threshold", true);
                }
                if (!bls.hasImpliciteLength() && bls.getLength() < smallSizeThreshold || bls.needsLimitTreatment() && bls.getLimit() < smallSizeThreshold) {
                    targetFileLocation = "inmessage://";
                    hints.markHint("send-small-files-in-message", true);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Raw content will be transferred in message since " + bls.getLength() + " is less than " + smallSizeThreshold + " bytes."));
                    }
                }
            }
            if (BaseLayerUtils.requestsFor("append-objectid-to-location", hints) && targetFileLocation != null && !targetFileLocation.equalsIgnoreCase("/dev/null") && !targetFileLocation.equalsIgnoreCase("inmessage://")) {
                log.debug((Object)"Appending OID to target file location");
                targetFileLocation = targetFileLocation + info.getName();
                hints.markHint("append-objectid-to-location", true);
            }
            if (BaseLayerUtils.requestsFor("append-name-to-location", hints) && targetFileLocation != null && !targetFileLocation.equalsIgnoreCase("/dev/null") && !targetFileLocation.equalsIgnoreCase("inmessage://")) {
                log.debug((Object)"Appending name to target file location");
                String name = info.getName();
                name = name.replace('/', '_');
                name = name.replace('\\', '_');
                name = name.replace("..", "_");
                targetFileLocation = targetFileLocation + name;
                hints.markHint("append-name-to-location", true);
            }
            RawFileContentManager contentSaver = BaseLayerUtils.getProtocolHandlerFor(targetFileLocation, hints);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Saving raw content at '" + targetFileLocation + "' using " + contentSaver.getClass().getName() + " and hints " + hints));
            }
            long start = System.currentTimeMillis();
            newloc = contentSaver.saveBinaryContent(targetFileLocation, bls, hints);
            long stop = System.currentTimeMillis();
            long elapsedTime = stop - start;
            log.debug((Object)("Elapsed time for transfer: " + elapsedTime));
            if (hints != null && hints != new BasicStorageHints()) {
                if (!hints.isConsumedHint("content-stored-at")) {
                    log.debug((Object)"Saving target location as consumed hint.");
                    hints.addConsumedHint("content-stored-at", newloc.getContentID());
                }
                hints.addConsumedHint("elapsed-transfer-time", "" + elapsedTime);
            }
            if (newloc instanceof InMemoryRawContentLocation) {
                info.setTemporaryRawContent(((InMemoryRawContentLocation)newloc).getContent());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Done with getInfoObject. Consumed hints are " + hints.getConsumedHints()));
            }
            return info;
        }
        catch (BaseLayerException ble) {
            log.error((Object)ble);
            throw new StorageLayerException("Could not save content at location '" + targetFileLocation + "'.", ble, newloc == null ? SUBSYSTEM_RFCM : "Raw File Content Management " + newloc.getDataprovider());
        }
    }

    public static boolean existsInfoObject(String oid) throws StorageLayerException {
        try {
            return rapm.existsInfoObject(oid);
        }
        catch (BaseLayerException ble) {
            log.error((Object)ble);
            throw new StorageLayerException("Could not determine existence of object with ID '" + oid + "'.", ble, SUBSYSTEM_RAPM);
        }
    }

    public static boolean existsReference(String sourceoid, String targetoid, String role, String secondaryRole) throws StorageLayerException {
        try {
            return rapm.existsReference(sourceoid, targetoid, role, secondaryRole);
        }
        catch (BaseLayerException ble) {
            log.error((Object)ble);
            throw new StorageLayerException("Could not determine existence of relation between '" + sourceoid + "' and '" + targetoid + "' with role '" + role + "' and secondary role '" + secondaryRole + "'.", ble, SUBSYSTEM_RAPM);
        }
    }

    public static void associateRawContent(String objectID, byte[] rawContent, BasicStorageHints hints) throws StorageLayerException {
        RawContentLocation newloc;
        log.info((Object)("associateRawContent objectID: " + objectID + " rawContent.length: " + rawContent.length + " hints: " + hints));
        if (StorageManager.hasRawContent(objectID)) {
            StorageManager.updateRawContent(objectID, rawContent, hints);
            return;
        }
        log.debug((Object)("Associating new inmemory:// content to  object '" + objectID + "' using hints " + hints + "."));
        if (rawContent == null) {
            log.debug((Object)"New raw content was null - nothing to associate. Object remains without content.");
            return;
        }
        try {
            if (BaseLayerUtils.requestsFor("append-content", hints)) {
                log.info((Object)"Requested appending content, where there has been no previous content to append to. Hint will be removed.");
                hints.removeHint("append-content");
            }
        }
        catch (ValueNotValidException vnve) {
            throw new StorageLayerException("Hint value for 'append-content' not valid.", vnve, SUBSYSTEM_RFCM);
        }
        try {
            BaseLayerStream bls = InMemoryContentManager.getInstance().getBinaryContent(rawContent, hints);
            newloc = StorageManager.saveRawContent(objectID, bls, hints);
            StorageManager.setStorageProperty(objectID, "contentmanagement:ObjectFlavour", "xsd:string", "contentmanagement:Materialized");
            StorageManager.finalizeInputStream(bls);
            BaseLayerUtils.consumeHint("keep-raw-content-external", hints);
        }
        catch (ValueNotValidException ve) {
            throw new StorageLayerException("Invalid parameters for importing raw content.", ve, SUBSYSTEM_RFCM);
        }
        StorageManager.registerNewLocation(objectID, newloc, hints);
    }

    public static void associateRawContent(String objectID, String fileLocation, BasicStorageHints hints) throws StorageLayerException {
        RawContentLocation newloc;
        log.debug((Object)"Checking if raw content already exists");
        if (StorageManager.hasRawContent(objectID)) {
            StorageManager.updateRawContent(objectID, fileLocation, hints);
            return;
        }
        log.debug((Object)("Associating new content from '" + fileLocation + "' to  object '" + objectID + "' using hints " + hints + "."));
        try {
            if (BaseLayerUtils.requestsFor("append-content", hints)) {
                log.info((Object)"Requested appending content, where there has been no previous content to append to. Hint will be removed.");
                hints.removeHint("append-content");
            }
        }
        catch (ValueNotValidException vnve) {
            throw new StorageLayerException("Hint value for 'append-content' not valid.", vnve, SUBSYSTEM_RFCM);
        }
        try {
            newloc = StorageManager.prepareNewLink(objectID, fileLocation, hints);
        }
        catch (ValueNotValidException ve) {
            throw new StorageLayerException("Invalid parameters for importing raw content.", ve, SUBSYSTEM_RFCM);
        }
        StorageManager.registerNewLocation(objectID, newloc, hints);
    }

    private static void registerNewLocation(String objectID, RawContentLocation newloc, BasicStorageHints hints) throws StorageLayerException {
        try {
            rapm.addLinkContentLocation(objectID, newloc);
        }
        catch (BaseLayerException ble) {
            log.fatal((Object)ble);
            throw new StorageLayerException("Associate file to '" + objectID + "' failed.", ble, SUBSYSTEM_RAPM);
        }
        String userDN = hints.consumeHint("initiated-by", false);
        if (userDN != null) {
            try {
                rapm.setProperty(objectID, "contentmanagement:ObjectLastModifiedBy", "X.509.DistinguishedName", userDN);
            }
            catch (BaseLayerException ble) {
                log.error((Object)("Could not update modifier to " + userDN));
            }
        }
    }

    private static void finalizeInputStream(BaseLayerStream bls) {
        try {
            if (bls != null) {
                bls.dispose();
            }
        }
        catch (BaseLayerException e) {
            log.error((Object)("Error while closing source stream: " + e.getMessage()));
            log.error((Object)e);
        }
    }

    private static RawContentLocation prepareNewLink(String objectID, String fileLocation, BasicStorageHints hints) throws ValueNotValidException, StorageLayerException {
        RawContentLocation newloc;
        if (BaseLayerUtils.requestsFor("keep-raw-content-external", hints)) {
            newloc = BaseLayerUtils.getExternalLocation(fileLocation, hints);
            StorageManager.setStorageProperty(objectID, "contentmanagement:ObjectFlavour", "xsd:string", "contentmanagement:Virtual");
        } else {
            BaseLayerStream bls = StorageManager.openRawContent(fileLocation, hints);
            newloc = StorageManager.saveRawContent(objectID, bls, hints);
            StorageManager.setStorageProperty(objectID, "contentmanagement:ObjectFlavour", "xsd:string", "contentmanagement:Materialized");
            StorageManager.finalizeInputStream(bls);
            StorageManager.deleteSourceContentIfRequested(fileLocation, hints);
        }
        BaseLayerUtils.consumeHint("keep-raw-content-external", hints);
        return newloc;
    }

    static BaseLayerStream openRawContent(String fileLocation, BasicStorageHints hints) throws StorageLayerException {
        RawFileContentManager fileSource = null;
        try {
            fileSource = BaseLayerUtils.getProtocolHandlerFor(fileLocation, hints);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Retrieving raw content from location '" + fileLocation + "'..."));
            }
            return fileSource.getBinaryContent(new RawContentLocation(fileLocation, fileSource.getDataProvider()), hints);
        }
        catch (BaseLayerException ble) {
            log.error((Object)("Could not access raw content at location '" + fileLocation + "' as requested. Reason: " + StorageManager.getVerboseMessage(ble)));
            log.debug((Object)ble);
            throw new StorageLayerException("Could not access raw content at location '" + fileLocation + "' as requested.", ble, fileSource == null ? SUBSYSTEM_RFCM : "Raw File Content Management " + fileSource.getDataProvider());
        }
    }

    static void deleteSourceContentIfRequested(String fileLocation, BasicStorageHints hints) throws StorageLayerException {
        RawFileContentManager fileSource = null;
        try {
            if (BaseLayerUtils.requestsFor("delete-after-transfer", hints)) {
                fileSource = BaseLayerUtils.getProtocolHandlerFor(fileLocation, hints);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removing raw content from location '" + fileLocation + "'..."));
                }
                fileSource.deleteBinaryContent(new RawContentLocation(fileLocation, fileSource.getDataProvider()), hints);
                BaseLayerUtils.consumeHint("delete-after-transfer", hints);
            }
        }
        catch (BaseLayerException ble) {
            log.error((Object)("Could not remove content at location '" + fileLocation + "' as requested. Reason: " + StorageManager.getVerboseMessage(ble)));
            log.debug((Object)ble);
            throw new StorageLayerException("Could not remove content at location '" + fileLocation + "' as requested.", ble, fileSource == null ? SUBSYSTEM_RFCM : "Raw File Content Management " + fileSource.getDataProvider());
        }
    }

    static RawContentLocation saveRawContent(String objectID, BaseLayerStream bls, BasicStorageHints hints) throws StorageLayerException {
        RawContentLocation newLoc = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Saving raw content using strategy '" + rawstrategy.getClass().getName() + "' and hints '" + hints + "'..."));
            }
            long start = System.currentTimeMillis();
            newLoc = rawstrategy.saveAtPreferredLocation(objectID, bls, hints);
            long stop = System.currentTimeMillis();
            long elapsedTime = stop - start;
            log.debug((Object)("Elapsed time for transfer: " + elapsedTime));
            if (hints != null && hints != new BasicStorageHints()) {
                hints.addConsumedHint("elapsed-transfer-time", "" + elapsedTime);
            }
            if (hints.hasHint("bytes-transferred")) {
                long tranferred = BaseLayerUtils.convertHintToLong(hints.getHintValue("bytes-transferred"), "bytes-transferred");
                boolean appended = BaseLayerUtils.requestsFor("append-content", hints) && hints.isConsumedHint("append-content");
                StorageManager.updateContentLengthInformation(objectID, tranferred, appended);
            } else {
                StorageManager.deleteContentLengthInformation(objectID);
            }
            if (BaseLayerUtils.requestsFor("guess-content-mime-type", hints) && !hints.isConsumedHint("guess-content-mime-type")) {
                String name = StorageManager.retrieveStorageProperty(objectID, "contentmanagement:ObjectName").getValue();
                String mimeType = URLConnection.guessContentTypeFromName(name);
                BaseLayerUtils.consumeHint("guess-content-mime-type", hints);
                if (mimeType != null && !"content/unknown".equals(mimeType)) {
                    hints.addHint("content-mime-type", mimeType);
                }
            }
            if (hints.hasHint("content-mime-type")) {
                String mimeType = hints.getHintValue("content-mime-type");
                log.debug((Object)("MIME-Type of " + objectID + " is set to " + mimeType));
                StorageManager.setStorageProperty(objectID, "contentmanagement:MimeType", "MIME Media-Type", mimeType);
                BaseLayerUtils.consumeHint("content-mime-type", hints);
            } else if (!BaseLayerUtils.requestsFor("do-not-update-content-mime-type", hints)) {
                log.trace((Object)"unsetting MimeType");
                StorageManager.unsetStorageProperty(objectID, "contentmanagement:MimeType");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Consumed hints are: " + hints.getConsumedHints()));
            }
            return newLoc;
        }
        catch (BaseLayerException ble) {
            log.error((Object)("Failure transferring file to storage location:" + StorageManager.getVerboseMessage(ble)));
            log.debug((Object)ble);
            ble.printStackTrace();
            throw new StorageLayerException("Failed transferring file to storage location. ", ble, newLoc == null ? SUBSYSTEM_RFCM : "Raw File Content Management " + newLoc.getDataprovider());
        }
    }

    public static void updateRawContent(String objectID, byte[] rawContent, BasicStorageHints hints) throws StorageLayerException {
        if (!StorageManager.hasRawContent(objectID)) {
            StorageManager.associateRawContent(objectID, rawContent, hints);
            return;
        }
        log.debug((Object)("Updating content with inmemory:// content to  object '" + objectID + "' using hints " + hints + "."));
        if (rawContent == null) {
            log.debug((Object)"New raw content was null, hence deleting previously associated content.");
            StorageManager.unassociateAndDeleteRawContent(objectID, hints);
            return;
        }
        RawContentLocation newloc = null;
        try {
            BaseLayerStream bls = InMemoryContentManager.getInstance().getBinaryContent(rawContent, hints);
            newloc = StorageManager.saveRawContent(objectID, bls, hints);
            StorageManager.setStorageProperty(objectID, "contentmanagement:ObjectFlavour", "xsd:string", "contentmanagement:Materialized");
            StorageManager.finalizeInputStream(bls);
            BaseLayerUtils.consumeHint("keep-raw-content-external", hints);
        }
        catch (ValueNotValidException ve) {
            throw new StorageLayerException("Invalid parameters for importing raw content.", ve, newloc == null ? SUBSYSTEM_RFCM : "Raw File Content Management " + newloc.getDataprovider());
        }
        StorageManager.updateLinkLocation(objectID, newloc, hints);
    }

    public static void updateRawContent(String objectID, String fileLocation, BasicStorageHints hints) throws StorageLayerException {
        log.debug((Object)"Checking if raw content already exists");
        if (!StorageManager.hasRawContent(objectID)) {
            StorageManager.associateRawContent(objectID, fileLocation, hints);
            return;
        }
        if ("/dev/null".equals(fileLocation)) {
            StorageManager.unassociateAndDeleteRawContent(objectID, hints);
            return;
        }
        log.debug((Object)("Updating raw content from '" + fileLocation + "' to  object '" + objectID + "' using hints " + hints + "."));
        RawContentLocation newloc = null;
        try {
            newloc = StorageManager.prepareNewLink(objectID, fileLocation, hints);
        }
        catch (ValueNotValidException ve) {
            throw new StorageLayerException("Invalid parameters for importing raw content.", ve, newloc == null ? SUBSYSTEM_RFCM : "Raw File Content Management " + newloc.getDataprovider());
        }
        StorageManager.updateLinkLocation(objectID, newloc, hints);
    }

    private static void updateLinkLocation(String objectID, RawContentLocation newloc, BasicStorageHints hints) throws StorageLayerException {
        try {
            rapm.updateLinkContentLocations(objectID, newloc);
        }
        catch (BaseLayerException ble) {
            log.error((Object)("Failure updating inforamtion for " + objectID + ": " + StorageManager.getVerboseMessage(ble)));
            log.debug((Object)ble);
            throw new StorageLayerException("Updating location information for '" + objectID + "' failed.", ble, SUBSYSTEM_RAPM);
        }
        String userDN = hints.consumeHint("initiated-by", false);
        if (userDN != null) {
            try {
                rapm.setProperty(objectID, "contentmanagement:ObjectLastModifiedBy", "X.509.DistinguishedName", userDN);
            }
            catch (BaseLayerException ble) {
                log.error((Object)("Could not update modifier to " + userDN));
            }
        }
    }

    public static void unassociateAndDeleteRawContent(String objectID, BasicStorageHints hints) throws StorageLayerException {
        log.debug((Object)("Removing all raw content of object " + objectID));
        try {
            rapm.removeAllRawContentOf(objectID, hints);
            StorageManager.deleteContentLengthInformation(objectID);
        }
        catch (BaseLayerException ble) {
            throw new StorageLayerException("Removing raw content for  '" + objectID + "' failed.", ble, SUBSYSTEM_RAPM);
        }
    }

    public static boolean removeRawContent(String objectID, BasicStorageHints hints) throws StorageLayerException {
        boolean result = false;
        try {
            result = rapm.removeAllRawContentOf(objectID, hints);
        }
        catch (BaseLayerException ble) {
            log.error((Object)("Failure removing raw content for " + objectID + ": " + StorageManager.getVerboseMessage(ble)));
            log.debug((Object)ble);
            throw new StorageLayerException("Could not remove raw content for '" + objectID + "'.", ble, SUBSYSTEM_RAPM);
        }
        StorageManager.deleteContentLengthInformation(objectID);
        return result;
    }

    public static void addReference(String sourceObjectID, String targetObjectID, String role, String secondaryRole, int position, String propagationRule) throws StorageLayerException {
        try {
            log.info((Object)("addReference sourceObjectID: " + sourceObjectID + ",targetObjectID: " + targetObjectID + ", role: " + role + ", secondaryRole: " + secondaryRole + ", position: " + position + ", propagationRule: " + propagationRule));
            rapm.addReference(sourceObjectID, targetObjectID, role, secondaryRole, position, propagationRule);
        }
        catch (BaseLayerException ble) {
            log.error((Object)"Error adding reference", (Throwable)ble);
            throw new StorageLayerException("Could not add reference.", ble, SUBSYSTEM_RAPM);
        }
    }

    private static String getVerboseMessage(BaseLayerException ble) {
        String msg = ble.getMessage();
        if (ble instanceof ObjectNotFoundException) {
            msg = msg + " Missing object ID was: '" + ((ObjectNotFoundException)ble).getInvalidValue() + "'.";
        } else if (ble instanceof DuplicateIDException) {
            msg = msg + " Duplicate ID was: '" + ((DuplicateIDException)ble).getInvalidValue() + "'.";
        } else if (ble instanceof ValueNotValidException) {
            msg = msg + " Invalid value was: '" + ((ValueNotValidException)ble).getInvalidValue() + "'.";
        }
        if (StorageManager.printCausesInErrorMessages() && ble.getCause() != null) {
            msg = msg + " Caused by: " + ble.getCause().getMessage();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Got " + ble.getClass().getCanonicalName() + " with verbose message:" + msg));
        }
        return msg;
    }

    private static boolean printCausesInErrorMessages() {
        return log.isInfoEnabled();
    }

    public static boolean removeReference(String sourceObjectID, String targetObjectID, String role, String secondaryRole) throws StorageLayerException {
        try {
            return rapm.removeReference(sourceObjectID, targetObjectID, role, secondaryRole);
        }
        catch (BaseLayerException ble) {
            log.debug((Object)ble);
            throw new StorageLayerException("Could not remove reference.", ble, SUBSYSTEM_RAPM);
        }
    }

    public static List<BasicReferenceDescription> retrieveReferences(String sourceObjectID, String role, String secondaryRole) throws StorageLayerException {
        try {
            return rapm.retrieveReferences(sourceObjectID, role, secondaryRole);
        }
        catch (BaseLayerException ble) {
            log.debug((Object)ble);
            throw new StorageLayerException("Could not retrieve references.", ble, SUBSYSTEM_RAPM);
        }
    }

    public static List<BasicReferenceDescription> retrieveReferencesOrderedByPosition(String sourceObjectID, String role, String secondaryRole) throws StorageLayerException {
        try {
            return rapm.retrieveReferencesOrderedByPosition(sourceObjectID, role, secondaryRole);
        }
        catch (BaseLayerException ble) {
            log.debug((Object)ble);
            throw new StorageLayerException("Could not retrieve references.", ble, SUBSYSTEM_RAPM);
        }
    }

    public static List<BasicReferenceDescription> retrieveReferred(String targetObjectID, String role, String secondaryRole) throws StorageLayerException {
        try {
            return rapm.retrieveReferred(targetObjectID, role, secondaryRole);
        }
        catch (BaseLayerException ble) {
            log.debug((Object)ble);
            throw new StorageLayerException("Could not retrieve references.", ble, SUBSYSTEM_RAPM);
        }
    }

    public static List<String> retrieveReferredSourceOIDs(String targetObjectID, String role, String secondaryRole) throws StorageLayerException {
        try {
            return rapm.retrieveReferredSourceOIDs(targetObjectID, role, secondaryRole);
        }
        catch (BaseLayerException ble) {
            log.debug((Object)ble);
            throw new StorageLayerException("Could not retrieve references.", ble, SUBSYSTEM_RAPM);
        }
    }

    public static List<String> retrieveReferredTargetOIDs(String sourceObjectID, String role, String secondaryRole) throws StorageLayerException {
        try {
            return rapm.retrieveReferredTargetOIDs(sourceObjectID, role, secondaryRole);
        }
        catch (BaseLayerException ble) {
            log.debug((Object)ble);
            throw new StorageLayerException("Could not retrieve references.", ble, SUBSYSTEM_RAPM);
        }
    }

    public static long countReferences(String oid, boolean isSource, String role, String secondaryRole) throws StorageLayerException {
        try {
            return rapm.countReferences(oid, isSource, role, secondaryRole);
        }
        catch (BaseLayerException ble) {
            log.debug((Object)ble);
            throw new StorageLayerException("Could not count references.", ble, SUBSYSTEM_RAPM);
        }
    }

    public static void setStorageProperty(String objectID, String name, String type, String value) throws StorageLayerException {
        log.info((Object)("setStorageProperty objectID: " + objectID + ", name: " + name + ", type: " + type + ", value: " + value));
        try {
            rapm.setProperty(objectID, name, type, value);
        }
        catch (BaseLayerException ble) {
            log.error((Object)"Error setting info object property", (Throwable)ble);
            throw new StorageLayerException("Could not set property.", ble, SUBSYSTEM_RAPM);
        }
    }

    public static boolean unsetStorageProperty(String objectID, String name) throws StorageLayerException {
        try {
            return rapm.unsetProperty(objectID, name);
        }
        catch (BaseLayerException ble) {
            log.debug((Object)ble);
            throw new StorageLayerException("Could not remove property.", ble, SUBSYSTEM_RAPM);
        }
    }

    public static Map<String, BasicPropertyDescription> retrieveObjectStorageProperties(String objectID) throws StorageLayerException {
        try {
            return rapm.retrieveObjectProperties(objectID);
        }
        catch (BaseLayerException ble) {
            log.debug((Object)ble);
            throw new StorageLayerException("Could not retrieve properties.", ble, SUBSYSTEM_RAPM);
        }
    }

    public static BasicPropertyDescription retrieveStorageProperty(String objectID, String name) throws StorageLayerException {
        try {
            return rapm.getProperty(objectID, name);
        }
        catch (BaseLayerException ble) {
            log.debug((Object)ble);
            throw new StorageLayerException("Could not retrieve property.", ble, SUBSYSTEM_RAPM);
        }
    }

    public static boolean hasStorageProperty(String oid, String name) throws StorageLayerException {
        try {
            return rapm.hasProperty(oid, name);
        }
        catch (BaseLayerException ble) {
            log.debug((Object)ble);
            throw new StorageLayerException("Could not retrieve property.", ble, SUBSYSTEM_RAPM);
        }
    }

    public static List<String> retrieveObjectIDsByStorageProperty(String name, String value) throws StorageLayerException {
        try {
            return rapm.retrieveOIDByProperty(name, value);
        }
        catch (BaseLayerException ble) {
            log.debug((Object)ble);
            throw new StorageLayerException("Could not retrieve objects.", ble, SUBSYSTEM_RAPM);
        }
    }

    public static void updateContentLengthInformation(String objectID, long newLengthInformation, boolean appended) throws StorageLayerException {
        if (newLengthInformation < 0L) {
            StorageManager.deleteContentLengthInformation(objectID);
        } else {
            if (appended) {
                try {
                    BasicPropertyDescription prop = StorageManager.retrieveStorageProperty(objectID, "contentmanagement:LengthOfRawContent");
                    if (prop != null) {
                        newLengthInformation += Long.parseLong(prop.getValue());
                    }
                }
                catch (StorageLayerException re) {
                    log.debug((Object)re);
                }
            }
            log.debug((Object)("Updating length information for " + objectID + " to " + newLengthInformation));
            StorageManager.setStorageProperty(objectID, "contentmanagement:LengthOfRawContent", "contentmanagement:LengthInBytes", Long.toString(newLengthInformation));
        }
    }

    public static void deleteContentLengthInformation(String objectID) throws StorageLayerException {
        StorageManager.unsetStorageProperty(objectID, "contentmanagement:LengthOfRawContent");
    }

    public static synchronized void ensureInit() {
        log.info((Object)"Storage Manager has been initialized.");
    }

    public static RawFileContentManager getManagerForDataProvider(String dataProvider) {
        for (Object o : managers.values()) {
            RawFileContentManager manager = (RawFileContentManager)o;
            log.debug((Object)("trying " + manager.getDataProvider()));
            if (!manager.handles(dataProvider)) continue;
            return manager;
        }
        return null;
    }

    static {
        performAdditionalChecks = true;
        defaultSmallSizeThreshold = 1500000L;
        maxSmallSizeThreshold = 2500000L;
        rawstrategy = new SelectFirstSuitableProvider();
        initialized = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SelectFirstSuitableProvider
    extends RawContentLocationSelectionStrategy {
        SelectFirstSuitableProvider() {
        }

        @Override
        public BaseLayerStream retrieveFromPreferredLocation(List<RawContentLocation> locations, BasicStorageHints hints) throws BaseLayerException {
            RawFileContentManager manager = null;
            RawContentLocation selectedLocation = null;
            for (RawContentLocation location : locations) {
                log.debug((Object)("searching manager for location " + location));
                manager = StorageManager.getManagerForDataProvider(location.getDataprovider());
                if (manager == null) continue;
                selectedLocation = location;
                break;
            }
            if (selectedLocation == null) {
                log.warn((Object)"No registered provider handles any of the possible locations.");
                throw new ValueNotValidException("No registered provider handles any of the possible locations.", null, manager.getDataProvider());
            }
            return manager.getBinaryContent(selectedLocation, hints);
        }

        @Override
        protected RawFileContentManager selectManagerForWriting(String uniqueStorageID, BasicStorageHints storageHints) {
            return rfcm;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AlwaysSelectDefaultProvider
    extends RawContentLocationSelectionStrategy {
        AlwaysSelectDefaultProvider() {
        }

        @Override
        public BaseLayerStream retrieveFromPreferredLocation(List<RawContentLocation> locations, BasicStorageHints hints) throws BaseLayerException {
            RawContentLocation selectedLocation = null;
            for (RawContentLocation location : locations) {
                if (!rfcm.handles(location.getDataprovider())) continue;
                selectedLocation = location;
                break;
            }
            if (selectedLocation == null) {
                log.warn((Object)"None of the existing locations can be handled by the default provider. More elaborate provider is needed.");
                throw new ValueNotValidException("Default provider does not handle any of the possible locations.", null, rfcm.getDataProvider());
            }
            return rfcm.getBinaryContent(selectedLocation, hints);
        }

        @Override
        protected RawFileContentManager selectManagerForWriting(String uniqueStorageID, BasicStorageHints storageHints) {
            return rfcm;
        }
    }
}

