/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.baselayer.networkFileTransfer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.contentmanagement.baselayer.BaseLayerStream;
import org.gcube.contentmanagement.baselayer.BaseLayerUtils;
import org.gcube.contentmanagement.baselayer.InstantiableManager;
import org.gcube.contentmanagement.baselayer.RawContentLocation;
import org.gcube.contentmanagement.baselayer.RawFileContentManager;
import org.gcube.contentmanagement.baselayer.exceptions.BaseLayerException;
import org.gcube.contentmanagement.baselayer.exceptions.ObjectNotFoundException;
import org.gcube.contentmanagement.baselayer.exceptions.TemporaryUnavailableException;
import org.gcube.contentmanagement.baselayer.exceptions.ValueNotValidException;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicStorageHints;
import org.gcube.contentmanagement.layerindependent.servicehelper.CredentialsProvider;
import org.gcube.contentmanagement.layerindependent.servicehelper.CredentialsReceiver;
import org.globus.ftp.GridFTPClient;
import org.globus.ftp.exception.ClientException;
import org.globus.ftp.exception.FTPException;
import org.globus.ftp.exception.ServerException;
import org.globus.io.streams.GridFTPInputStream;
import org.globus.io.streams.GridFTPOutputStream;
import org.globus.util.GlobusURL;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

public class GridFTPContentManager
implements RawFileContentManager,
CredentialsReceiver,
InstantiableManager {
    private static final Log log = LogFactory.getLog(GridFTPContentManager.class);
    static final String DATA_PROVIDER_PREFIX = "gsiftp://";
    final String URL_PREFIX;
    private CredentialsProvider credProv = null;
    private String dataProvider = "gsiftp://";

    public static String getDataProviderPrefix() {
        return DATA_PROVIDER_PREFIX;
    }

    public void put(File localFile, String remotePath) throws BaseLayerException {
        try {
            if (!localFile.exists()) {
                throw new ObjectNotFoundException("File does not exist", localFile.getCanonicalPath());
            }
            if (!localFile.canRead()) {
                throw new ValueNotValidException("Cannot read file.", localFile.getCanonicalPath(), "contentmanagement:location");
            }
            GlobusURL u = new GlobusURL(remotePath);
            String host = u.getHost();
            int port = u.getPort();
            String path = u.getPath();
            GSSCredential credential = this.getCredentials();
            GridFTPClient client = new GridFTPClient(host, port);
            client.authenticate(credential);
            client.setProtectionBufferSize(16384);
            client.setDataChannelProtection(4);
            client.setPassive();
            client.setLocalActive();
            client.put(localFile, path, false);
            client.close();
        }
        catch (IOException ioe) {
            log.error((Object)ioe);
            throw new BaseLayerException("Error tranferring local file '" + localFile.getAbsolutePath() + "'.", ioe);
        }
        catch (GSSException gsse) {
            log.error((Object)gsse);
            throw new BaseLayerException("Security error while tranferring file.", gsse);
        }
        catch (ServerException se) {
            log.error((Object)se);
            throw new BaseLayerException("GridFTP server error while tranferring file to'" + remotePath + "'.", se);
        }
        catch (ClientException ce) {
            log.error((Object)ce);
            throw new BaseLayerException("GridFTP client error while tranferring file to'" + remotePath + "'.", ce);
        }
    }

    private GSSCredential getCredentials() throws GSSException {
        log.debug((Object)"Returning host credentials...");
        ExtendedGSSManager manager = (ExtendedGSSManager)ExtendedGSSManager.getInstance();
        return manager.createCredential(0);
    }

    private GSSCredential getCredentials(BasicStorageHints hints) throws GSSException {
        if (hints == null) {
            return this.getCredentials();
        }
        String credsAsString = hints.consumeHint("delegated-credentials", false);
        log.debug((Object)("Hints contianed credentials: " + credsAsString));
        if (credsAsString == null) {
            return this.getCredentials();
        }
        ExtendedGSSManager manager = (ExtendedGSSManager)ExtendedGSSManager.getInstance();
        return manager.createCredential(credsAsString.getBytes(), 0, 0, null, 0);
    }

    public void get(String remotePath, File localFile) throws BaseLayerException {
        try {
            if (!localFile.canWrite() && !localFile.createNewFile()) {
                throw new ValueNotValidException("Cannot write to file.", localFile.getAbsolutePath(), "contentmanagement:location");
            }
            GlobusURL u = new GlobusURL(remotePath);
            String host = u.getHost();
            int port = u.getPort();
            String path = u.getPath();
            GSSCredential credential = this.getCredentials();
            GridFTPClient client = new GridFTPClient(host, port);
            client.authenticate(credential);
            client.setProtectionBufferSize(16384);
            client.setDataChannelProtection(4);
            client.setPassive();
            client.setLocalActive();
            client.get(path, localFile);
            client.close();
        }
        catch (IOException ioe) {
            log.error((Object)ioe);
            throw new BaseLayerException("Error creating local file '" + localFile.getAbsolutePath() + "'.", ioe);
        }
        catch (GSSException gsse) {
            log.error((Object)gsse);
            throw new BaseLayerException("Security error while tranferring file.", gsse);
        }
        catch (ServerException se) {
            log.error((Object)se);
            throw new BaseLayerException("GridFTP server error while tranferring file to'" + remotePath + "'.", se);
        }
        catch (ClientException ce) {
            log.error((Object)ce);
            throw new BaseLayerException("GridFTP client error while tranferring file to'" + remotePath + "'.", ce);
        }
    }

    GlobusURL getURLFor(String uniqueStorageID) throws ValueNotValidException {
        try {
            if (this.URL_PREFIX == null || this.URL_PREFIX.equals("") || uniqueStorageID.startsWith(this.URL_PREFIX)) {
                return new GlobusURL(uniqueStorageID);
            }
            return new GlobusURL(this.URL_PREFIX + uniqueStorageID);
        }
        catch (MalformedURLException e) {
            log.error((Object)e);
            throw new ValueNotValidException("Malformed URL as storage location.", uniqueStorageID, "contentmanagement:location");
        }
    }

    public RawContentLocation saveBinaryContent(String uniqueStorageID, BaseLayerStream binaryFileContent, BasicStorageHints hints) throws BaseLayerException {
        if (BaseLayerUtils.requestsFor("create-new-file-when-file-exists", hints) && !hints.isConsumedHint("create-new-file-when-file-exists")) {
            uniqueStorageID = BaseLayerUtils.makePseudoUniqueLocation(new RawContentLocation(uniqueStorageID, this.getDataProvider()), this, hints).getContentID();
            hints.markHint("create-new-file-when-file-exists", true);
        }
        GlobusURL u = this.getURLFor(uniqueStorageID);
        try {
            GSSCredential cred = this.getCredentials(hints);
            boolean append = false;
            if (BaseLayerUtils.requestsFor("append-content", hints)) {
                append = true;
                hints.markHint("append-content", true);
            }
            GridFTPOutputStream os = new GridFTPOutputStream(cred, u.getHost(), u.getPort(), u.getPath(), append);
            binaryFileContent.setLimit(hints);
            long transferred = binaryFileContent.writeToStreamRespectingLimit((OutputStream)os);
            hints.addHint("bytes-transferred", transferred + "");
            hints.markHint("bytes-transferred", true);
            binaryFileContent.dispose();
            os.flush();
            os.close();
            return new RawContentLocation(uniqueStorageID, this.getDataProvider());
        }
        catch (GSSException gsse) {
            log.error((Object)gsse);
            throw new BaseLayerException("Security error while tranferring file.", gsse);
        }
        catch (FTPException ftpe) {
            log.error((Object)ftpe);
            throw new BaseLayerException("GridFTP client error while tranferring data to'" + uniqueStorageID + "'.", ftpe);
        }
        catch (IOException ioe) {
            log.error((Object)ioe);
            throw new BaseLayerException("Error in data access.", ioe);
        }
    }

    public BaseLayerStream getBinaryContent(RawContentLocation location, BasicStorageHints hints) throws BaseLayerException {
        GlobusURL u = this.getURLFor(location.getContentID());
        try {
            GSSCredential cred = this.getCredentials(hints);
            GridFTPInputStream is = new GridFTPInputStream(cred, u.getHost(), u.getPort(), u.getPath());
            return new BaseLayerStream((InputStream)is, is.getSize());
        }
        catch (IOException ioe) {
            log.error((Object)ioe);
            throw new BaseLayerException("Error in data access.", ioe);
        }
        catch (GSSException gsse) {
            log.error((Object)gsse);
            throw new BaseLayerException("Security error while tranferring file.", gsse);
        }
        catch (FTPException ftpe) {
            int ftpErrorCode = ftpe.getCode();
            if (ftpErrorCode == 421) {
                throw new TemporaryUnavailableException("Received GridFTP error code " + ftpErrorCode + " when trying to access " + location.getContentID() + ", which might be recoverable with time.", ftpe);
            }
            log.error((Object)ftpe);
            throw new BaseLayerException("GridFTP client error while tranferring data from'" + location.getContentID() + "'.", ftpe);
        }
    }

    public boolean deleteBinaryContent(RawContentLocation location, BasicStorageHints hints) throws BaseLayerException {
        GlobusURL u = this.getURLFor(location.getContentID());
        try {
            GSSCredential cred = this.getCredentials(hints);
            GridFTPClient client = new GridFTPClient(u.getHost(), u.getPort());
            client.authenticate(cred);
            client.setProtectionBufferSize(1024);
            client.setDataChannelProtection(4);
            client.setPassive();
            client.setLocalActive();
            client.deleteFile(u.getPath());
            client.close();
        }
        catch (IOException ioe) {
            log.error((Object)ioe);
            throw new BaseLayerException("I/O error while deleting file.", ioe);
        }
        catch (GSSException gsse) {
            log.error((Object)gsse);
            throw new BaseLayerException("Security error while tranferring file.", gsse);
        }
        catch (FTPException ftpe) {
            log.error((Object)ftpe);
            throw new BaseLayerException("GridFTP client error while tranferring data from'" + location.getContentID() + "'.", ftpe);
        }
        return true;
    }

    public boolean existsBinaryContent(RawContentLocation location, BasicStorageHints hints) throws BaseLayerException {
        GlobusURL u = this.getURLFor(location.getContentID());
        try {
            GSSCredential cred = this.getCredentials(hints);
            GridFTPClient client = new GridFTPClient(u.getHost(), u.getPort());
            client.authenticate(cred);
            client.setProtectionBufferSize(1024);
            client.setDataChannelProtection(4);
            client.setPassive();
            client.setLocalActive();
            boolean exists = client.exists(u.getPath());
            client.close();
            return exists;
        }
        catch (IOException ioe) {
            log.error((Object)ioe);
            throw new BaseLayerException("I/O error while checking for file.", ioe);
        }
        catch (GSSException gsse) {
            log.error((Object)gsse);
            throw new BaseLayerException("Security error while tranferring file.", gsse);
        }
        catch (FTPException ftpe) {
            log.error((Object)ftpe);
            throw new BaseLayerException("GridFTP client error while tranferring data from'" + location.getContentID() + "'.", ftpe);
        }
    }

    public boolean handles(String dataprovider) {
        if (dataprovider == null) {
            return false;
        }
        if (dataprovider.startsWith("gsiftp:")) {
            return true;
        }
        return dataprovider.startsWith("gridftp:");
    }

    public void ensureResponsibleFor(RawContentLocation rcl) throws ValueNotValidException {
        if (!rcl.getDataprovider().equals(this.dataProvider)) {
            throw new ValueNotValidException("Not responsible for this data location.", rcl.getDataprovider(), "contentmanagement:location");
        }
    }

    public String getDataProvider() {
        if (this.URL_PREFIX == null || this.URL_PREFIX == "") {
            return DATA_PROVIDER_PREFIX;
        }
        return this.URL_PREFIX;
    }

    public GridFTPContentManager(String managedURL) {
        this.URL_PREFIX = managedURL;
    }

    public boolean supportsAppending() {
        return true;
    }

    public RawContentLocation makePermanentLocation(RawContentLocation currentLocation, BasicStorageHints hints) throws ValueNotValidException {
        if (BaseLayerUtils.containsDownloadCredentials(hints)) {
            throw new ValueNotValidException("Hints for username and/or password are not allowed in this context.", "permanent location", "contentmanagement:location");
        }
        return currentLocation;
    }

    public static GridFTPContentManager getManagerInstance(String[] params, String managerName) throws BaseLayerException {
        if (params.length > 0) {
            return new GridFTPContentManager(params[0]);
        }
        return new GridFTPContentManager("");
    }

    public void setCredentialsProvider(CredentialsProvider provider) {
        log.debug((Object)("Set credentials provider to " + (provider == null ? null : "instance of " + provider.getClass().getName())));
        this.credProv = provider;
    }

    public String getUniqueStorageLocationIDFor(String objectID) {
        return objectID;
    }
}

