/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.rs;

import com.thoughtworks.xstream.XStream;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderException;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.field.StringField;
import java.net.URI;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class RSXStreamIterator<E>
implements Iterator<E> {
    protected Logger logger = Logger.getLogger(RSXStreamIterator.class);
    protected Iterator<GenericRecord> rsIterator;
    protected XStream stream;
    protected String fieldName;
    protected ForwardReader<GenericRecord> reader;

    public RSXStreamIterator(String locator, String fieldName) throws GRS2ReaderException {
        this(URI.create(locator), fieldName);
    }

    public RSXStreamIterator(URI locator, String fieldName) throws GRS2ReaderException {
        this(locator, fieldName, 120L, TimeUnit.SECONDS);
    }

    public RSXStreamIterator(URI locator, String fieldName, long iteratorTimeout, TimeUnit timeUnit) throws GRS2ReaderException {
        this.reader = new ForwardReader(locator);
        this.reader.setIteratorTimeout(iteratorTimeout);
        this.reader.setIteratorTimeUnit(timeUnit);
        this.rsIterator = this.reader.iterator();
        this.stream = new XStream();
        this.fieldName = fieldName;
    }

    protected void closeReader() {
        try {
            this.reader.close();
        }
        catch (GRS2ReaderException e) {
            this.logger.error((Object)"Error closing the RS reader", (Throwable)e);
        }
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = this.rsIterator.hasNext();
        if (!hasNext) {
            this.closeReader();
        }
        return hasNext;
    }

    @Override
    public E next() {
        GenericRecord record = this.rsIterator.next();
        try {
            StringField field = (StringField)record.getField(this.fieldName);
            String value = field.getPayload();
            return (E)this.stream.fromXML(value);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error getting the record from RS", (Throwable)e);
            return null;
        }
    }

    @Override
    public void remove() {
        this.rsIterator.remove();
    }
}

